; Miscellaneous Output register
;
; unsigned char MOread_reg(void);
; void MOset_reg(unsigned char value);
; void MOset_regm(unsigned char value, unsigned char mask);
;      reg= (!mask & reg) | (mask & value)
BMASK   EQU     [BP+8]
VALUE   EQU     [BP+6]
;
MOread  EQU     03CCh
MOwrite EQU     03C2h
;
MO_TEXT   SEGMENT byte public 'CODE'
        ASSUME  cs:MO_TEXT, ds:NOTHING
        PUBLIC  _MOread_reg
        PUBLIC  _MOset_reg
        PUBLIC  _MOset_regm
_MOread_reg     PROC    far
        mov     dx,MOread
        in      al,dx
        xor     ah,ah
        ret             ; return to C
_MOread_reg     ENDP
_MOset_reg      PROC    far
        push    bp
        mov     bp,sp
        mov     dx,MOwrite
        mov     al,VALUE
        out     dx,al
        xor     ax,ax
        pop     bp
        ret             ; return to C
_MOset_reg      ENDP
_MOset_regm     PROC    far
        push    bp
        mov     bp,sp

        mov     dx,MOread
        in      al,dx
        mov     bl,BMASK
        not     bl
        and     al,bl
        mov     cl,al
        mov     dx,MOwrite
        mov     al,VALUE
        mov     bl,BMASK
        and     al,bl
        or      al,cl
        out     dx,al   

        xor     ax,ax
        pop     bp
        ret             ; return to C
_MOset_regm     ENDP
MO_TEXT   ENDS
        END

