#include <conio.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <pc.h>
#include <go32.h>
#include <sys/types.h>

#include "gfxmisc.h"

void gfxNewRotate(char *image, char *screen, int angle)
{
	register long rowU, rowV, dU, dV;
	unsigned long y, x, u, v, tx, ty;

	dU = sinTab[angle];
	dV = cosTab[angle];

	rowU = startingPointU[angle];
	rowV = startingPointV[angle];

	y=200;
	while (y--) {
		u = rowU;
		v = rowV;

		x = 320;
		while (x--) {
			ty = (v >> 10);
			tx = (u >> 10);

			if (ty<=199 && tx<=319) {
				*screen = *(image + yTab[ty] + tx);
			}
			screen++;

			u+=dV;
			v+=dU;
		}

		rowU -= dU;
		rowV += dV;
	}
}

void main(void)
{
	int angle = 0;
	int aDir = 4;
	char *scrImage;
	char *screen;
	long frames = 0L;
	u_short convSel = _go32_conventional_mem_selector();
	u_short mySel = _go32_my_ds();
	unsigned scrOffset;
	unsigned imgOffset;
	double start_time, end_time;

	screen = (char *) malloc(64000);
	if (screen == NULL) {
		printf("Error allocating screen memory.\n");
		return;
	}
	memset(screen, 0, 64000);
	scrOffset = (unsigned) screen;

	gfxInitTables();

	gfxSetMode(0x13);
	gfxExtendMode();

	scrImage = gfxLoadPCX("test.pcx", NULL);
	imgOffset = (unsigned) scrImage;

	movedata(mySel, imgOffset, convSel, 0xA0000, 64000);
	getch();

	start_time = clock();
	while (!kbhit()) {
		gfxNewRotate(scrImage, screen, angle);

		movedata(mySel, scrOffset, convSel, 0xA0000, 64000);
		memset(screen, 0, 64000);

		angle += aDir;
		if (angle >= 255) {
			angle = 255;
			aDir = -4;
		} else if (angle < 1) {
			angle = 0;
			aDir = 4;
		}

		frames++;
	}
	end_time = clock();

	getch();

	gfxSetMode(0x03);

	printf("scrImage: %p, %x (%p, %x)\n", scrImage, (unsigned) scrImage, &scrImage, (unsigned) &scrImage);
	printf("     DOS: %x\n", convSel);

	free(scrImage);
	free(screen);

	gfxCleanup();

	printf("  Time: %3.2f\n", (double) ((end_time-start_time) / 1000000));
	printf("Frames: %lu\n", frames);
	printf("   FPS: %3.2f\n", (double) (double) frames / (double) ((end_time-start_time) / 1000000));
}

