/*
   glcomp.c: a ".gl" file composer/decomposer.

   To compose a new ".gl" file, enter each file's name in a listfile.
   Supply the listfile's name as the second argument.

   Originally programmed for TurboC.
   Should be portable enough though.

   Donated to the public domain by S.R.van den Berg on 1990-11-08
   (That means I will not support the code any further, and you can do
   with the code whatever you want (except copyright it :-)).
   Reachable on INTERNET as:
                  berg%cip-s01.informatik.rwth-aachen.de@unido.bitnet
   Reachable on BITNET as:
                  berg%cip-s01.informatik.rwth-aachen.de@unido
*/

#pragma  option   -a- -r -O -Z -f-
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/stat.h>
#define  S_IFILE  (S_IFREG|S_IREAD|S_IWRITE)

#define  BUFSIZ   8000U
#define  MAXFILES 1024

#define  RECLEN   17

unsigned _stklen=1024,_heaplen=4U;
typedef unsigned char uchar;
struct {long offset;char name[13];} file[MAXFILES];
uchar buffer[BUFSIZ];
int in,out;

long fgetl(){unsigned i;
 i=fgetw();return i|(long)(unsigned)fgetw()<<16;}

main(argc,argv)char*argv[];{int i;char *p;
 if(argc<2||argc>3){
   putse("Usage: glcomp xxx.gl [listfile]\n");return 1;}
 if(0>(in=open(argv[argc-1],O_RDONLY|O_BINARY))){
couldntfind:
   putse("Couldn't find ");putse(argv[argc-1]);return 2;}
 if(argc==2){
   if(fgetw()/RECLEN>MAXFILES){
toomanyfiles:
      putse("Too many files\n");return 3;}
   i=0;
   do{
      file[i].offset=fgetl();read(in,file[i].name,RECLEN-4);}
   while(*file[i++].name);
   i=0;
   do{
      if(0>
         (out=open(p=file[i].name,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,S_IFILE))){
couldntopen:
         putse("Couldn't open ");putse(p);return 4;}
      puts(p);puts("\n");lseek(in,SEEK_SET,file[i].offset);copyfw(fgetl());
      close(out);}
   while(*file[++i].name);}
 else{long len;
   for(i=0;;){
      if(i>MAXFILES)
         goto toomanyfiles;
      p=file[i++].name;
      do
         if(eof(in))
            goto nomorefiles;
      while((*p=fgetc())<=' ');
      while((*++p=fgetc())>' ');
      *p='\0';}
nomorefiles:
   close(in);*p='\0';
   if(0>(out=open(p=argv[1],O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,S_IFILE)))
      goto couldntopen;
   fputw(i=i*RECLEN);write(out,file,i);
   i=0;
   puts("Reading:\n");
   do{
      if(0>(in=open(p=file[i].name,O_RDONLY|O_BINARY)))
         goto couldntfind;
      puts(p);puts("\n");file[i].offset=lseek(out,0L,SEEK_CUR);
      fputl(len=lseek(in,0L,SEEK_END));lseek(in,0L,SEEK_SET);copyfw(len);
      close(in);}
   while(*file[++i].name);
   lseek(out,2L,SEEK_SET);i=0;
   do{
      fputl(file[i].offset);write(out,file[i].name,RECLEN-4);}
   while(*file[i++].name);}
 return 0;}

fgetc(){uchar i;
 read(in,&i,1);return i;}

fgetw(){int i;
 i=fgetc();return i|fgetc()<<8;}

fputc(i){uchar j;
 j=i;write(out,&j,1);}

fputw(i){
 fputc(i);fputc(i>>8);}

fputl(i)long i;{
 fputw(i);fputw(i>>16);}

copyfw(i)long i;{long j;
 while(i>0L){j=i;
   i-=
   (unsigned)write(out,buffer,read(in,buffer,(unsigned)min(i,(long)BUFSIZ)));
   if(i>=j){
      putse("Choking...  Need space...\n");close(in);close(out);abort();}}}

#define STDOUT 1
#define STDERR 2
#include <io.h>

puts(a)char *a;{putsfd(a,STDOUT);}

putse(a)char *a;{putsfd(a,STDERR);}

putsfd(a,fd)register char *a;{register char *b;
 b=a;
 while(*a) a++;
 write(fd,b,a-b);}

_setupio(){}   /* Only use this if NO streams are used */