Program Title;

Uses crt,spx_vga,spx_eff,spx_key,spx_img;

const
  path = '';    { default work path }

type
  PMyCycle = ^TmyCycle;
  TMyCycle = object(TCycle)
               procedure cycle_move; virtual;
             end;

var
  MyCycle : PMyCycle;
  nsize   : integer;

procedure setup;
begin
  openmode(2);
  setpageactive(2);         { set page 2 as the active page }
  loadpcx(path+'casfnl.pcx'); { load pcx file on page 2 }
  fsetcolors(rgb256);       { set the palette to the pcx palette }
  nsize :=0;
  MyCycle := new(PMyCycle,init(50,nsize));
end;


procedure animate;
begin
  repeat
    if minus and (nsize>0)
      then
        begin
          dec(nsize);
          MyCycle^.changewave(50,nsize);
        end
      else
    if plus and (nsize<100)
      then
        begin
          inc(nsize);
          MyCycle^.changewave(50,nsize);
        end;
    if space
      then MyCycle^.docycle(2,1,1)
      else MyCycle^.docycle(2,1,2);
  until esc;
  fadeout(40,rgb256);
end;

(**) { TCycle Methods }

procedure TMyCycle.cycle_move;
begin
  {if np[6,2] or np[9,2] or np[3,2]
    then cyclex := (cyclex+1) mod 320
    else
      if np[4,2] or np[7,2] or np[1,2]
        then cyclex := (cyclex+319) mod 320;
  if np[8,2] or np[7,2] or np[9,2]
    then cycley := (cycley+1) mod 200
    else
      if np[1,2] or np[2,2] or np[3,2]
        then cycley := (cycley+199) mod 200;}
  cyclex := (cyclex+1) mod 320;

end;



begin
  setup;
  animate;
  dispose(MyCycle,done);
  closemode;
end.