Program autoload;

{ by Aaron Wacker }

Uses crt,spx_vga,spx_key,spx_obj,spx_img,spx_tim,spx_txt,spx_fnc,
     spritelo;

const
  path = '';
  max  = 10;

type
  Pballs = ^Tballs;
  Tballs = object(Tobjs)
             width,height,              { dimension of sprite }
             kind,                      { sprite number }
             ox,oy,                     { old position }
             x,y,                       { new position }
             dx,dy : integer;           { direction }
             constructor init(nx,ny,k:integer);
             procedure drawitemobject;virtual;
             procedure eraseitemobject;virtual;
             procedure updateitemobject;virtual;
             procedure calcitemobject;virtual;
           end;

var
  balls : balltype; { balltype is defined in spriteload tpu }
  pal   : RGBlist;
  head,
  tail  : plist;

procedure setup;
var
  p : plist;
  d : integer;
  spritenum : integer;
  train : boolean;
begin
  openmode(3);
  randomize;

  setpageactive(2);
  loadpcx(path+'ship.pcx');
  loadcolors(path+'ship.pal',pal,256);

{ get sprite from 200x100 area of image }
regionize(1,200,1,100, spritenum, false, balls);


  head := nil; tail := nil;
  for d := 1 to max do
    begin
      new(p);
      p^.item := new(Pballs,init(random(320),random(200),d mod 3+1));
      p^.item^.powner := p;
      addp(head,tail,p);
    end;
  fsetcolors(zdc);  { all black palette }
  pcopy(3,2);       { copy to work page }
  pcopy(3,1);       { copy to visual }
  fadein(40,pal);
end;


procedure placespeed(mode:objmode);
begin
  case mode of
    dErase  : pcopy(3,2);
    dUpdate : pcopy(2,1);
  end;
end;


procedure animate;
var
  p : pointer;
begin
  setpageactive(2);
  repeat
    doallitems(head,dErase);
    placespeed(dErase);
    if not space
      then doallitems(head,dCalc);
    doallitems(head,dDraw);
    placespeed(dDraw);
    doallitems(head,dUpdate);
    placespeed(dUpdate);
  until esc;
end;

(**) { Tballs methods }

constructor Tballs.init(nx,ny,k:integer);
begin
  Tobjs.init;
  kind := k;
  x := nx; y := ny; 
  ox := x; oy := y;
  repeat
    dx := random(7)-3;
    dy := random(7)-3;
  until (dx<>0) and (dy<>0);
  imagedims(balls[kind]^,width,height);
end;


procedure Tballs.eraseitemobject;
begin
  CopyRect(ox-width shr 1,oy-height shr 1,ox+width shr 1,oy+height shr 1,pages[3]^,pages[2]^);
  CopyRect(x-width shr 1,y-height shr 1,x+width shr 1,y+height shr 1,pages[3]^,pages[2]^);
end;


procedure Tballs.updateitemobject;
begin
  CopyRect(ox-width shr 1,oy-height shr 1,ox+width shr 1,oy+height shr 1,pages[2]^,pages[1]^);
  CopyRect(x-width shr 1,y-height shr 1,x+width shr 1,y+height shr 1,pages[2]^,pages[1]^);
end;


procedure Tballs.drawitemobject;
begin
  ftput_clip(x,y,balls[kind]^,true);
end;


procedure Tballs.calcitemobject;
begin
  ox := x; oy := y;
  inc(x,dx); inc(y,dy);
  if (x<0) or (x>319)
    then dx := -dx;
  if (y<0) or (y>199)
    then dy := -dy;
end;


procedure showit;
begin
   clrscr;
   writeln('Keys:');
   writeln(' ESC          - quit demo');
   writeln(' SPACE        - pause ');
   writeln;
   write('Press SPACE to continue.');
   clearbuffer;
   repeat until space;
end;


begin
  showit;
  setup;
  animate;
  clean_plist(head,tail);
  closemode;
end.