Unit Spritelo;

Interface

Uses SPX_VGA, SPX_OBJ;


type      balltype = array[0..50] of pointer;


procedure seperate(x1,x2,y1,y2,threshold,pn: integer);
procedure regionize(x1,x2,y1,y2: integer;
          var regnum: integer; trn: boolean;
          var balls : balltype
);


Implementation

procedure seperate(x1,x2,y1,y2,threshold,pn: integer);
{ turn all pixels above threshold white, and below threshold black }
{ performs all work on page pn. if pn=2 then it performs out of sight }
var
x,y     : Integer;
p       : Integer;
begin
  setpageactive(pn);
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
        p:=Point(x,y,pn);
        if p>threshold then pset(x,y,255) else begin
           pset(x,y,0);
           setpageactive(3);  { this will change near zero pixels to zero }
           pset(x,y,0);       { it is helpful for masking of converted pics }
           setpageactive(pn);
        end;
      end;
  end;
end;


procedure regionize(x1,x2,y1,y2: integer;
          var regnum: integer; trn: boolean;
          var balls : balltype);

var x,y             : integer;
    xx,yy : integer;
    pcolor          : integer;
    a,p,e           : integer;
    ar,pe,el        : integer;
    xmin,xmax,ymin,ymax      : integer;    { sides of a bounding box }
    cx,cy                    : integer;
    dummy                    : integer;

begin
  pcopy(2,3);  { copy to page three - we'll mess up page two }
  seperate(x1,x2,y1,y2,3,2); { this will leave page 2 a b/w image }
  regnum:=1;

  pcolor:=30;
  { check page 2 for white blobs }
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
         if Point(x,y,2)=255 then begin
            if pcolor>255 then pcolor:=30;

            setpageactive(2);
            { change it from white to a color label }
            paint(x,y,pcolor);

{ given a color label this finds the bounding box surrounding a region }
{ does not modify page }
              begin
                xmin:=500; xmax:=0;
                ymin:=500; ymax:=0;
                for xx:=x1 to x2 do begin
                  for yy:=y1 to y2 do begin
                    if point(xx,yy,2)=pcolor then begin
                      if xx>xmax then xmax:=xx;
                      if xx<xmin then xmin:=xx;
                      if yy>ymax then ymax:=yy;
                      if yy<ymin then ymin:=yy;
                    end;
                  end;
                end;
              end;



              { copy object to double linked list }
              setpageactive(3);

              getmem(balls[regnum],buffsize(xmax-xmin+1,ymax-ymin+1));
              fget(xmin,ymin,xmax,ymax,balls[regnum]^);

              regnum:=regnum+1;              { tally the number of regions }

              pcolor:=pcolor+7;              { color label for object }

         end;
      end;
  end;
end;

end.