Program threed;

Uses CRT,SPX_IMG,SPX_VGA,SPX_KEY,SPX_OBJ,SPX_T3D,SPX_TXT,SPX_FNC;

const
  pbeg : plist = nil;
  pend : plist = nil;
  path = '';    { default work path }
  xsize = 5;
  ysize = 5;
  zsize = 5;
  spacing = 7;

type
  Ppoint = ^Tpoint;
  Tpoint = object(Tobjs)
             x,y,z : integer;
             constructor init(nx,ny,nz:integer);
           end;

var
  oldexit   : pointer;
  d,m,r     : integer;
  pal   : RGBlist;
  balls : array[0..39] of pointer;
  xpos,ypos,zpos        : integer;
  xa,ya,za              : integer;
  NewSize  : pointer;
  dir      : integer;
  sx,sy,sz,vx,vy,vz : array[1..50] of integer;

procedure cleanup;far;
begin
  clean_plist(pbeg,pend);
  closemode;
  exitproc := oldexit;
end;

procedure setup;
begin
  getmem(NewSize,buffsize(70,70));
  openmode(3); randomize;
  setpageactive(3);
  loadpcx(path+'stars.pcx'); { load pcx file on page 3 }
  pcopy(3,2);
  pcopy(3,1);
  loadvsp(path+'ship.vsp',balls);
  loadcolors(path+'ship.pal',pal,256);
  fsetcolors(pal);  { palette }
  oldexit := exitproc; exitproc := @cleanup;
end;

procedure twodimto3d(lx1,lx2,ly1,ly2,page: integer);
var x,y,pcolor,
    xx,yy,zz                           : integer;
    p                                  : plist;
begin
   setpageactive(page);
   { grey scale image to derive depth }
   loadpcx(path+'test.pcx');   { load pcx file on page }
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
       if (x mod spacing =0) and (y mod spacing=0) then begin    { take every eigth point }
         pcolor:=point(x,y,page);
         new(p);
         p^.item := new(ppoint,init(x-(lx2 div 2),-(pcolor div 8),y-(ly2 div 2)));
         p^.item^.powner := p;
         addp(pbeg,pend,p);
       end;
      end;
   end;
end;


procedure setlevel;
const
  lv1 : array[0..8,0..1] of integer =
        ((-3,-5),(3,-5),(5,-3),(5,3),(3,5),(-3,5),(-5,3),(-5,-3),(-3,-5));
var
  p : plist;
  d,e,a,i : integer;
begin
    twodimto3d(1,260,1,200,2);
end;

procedure addballs;
const
  lv1 : array[0..8,0..1] of integer =
        ((-3,-5),(3,-5),(5,-3),(5,3),(3,5),(-3,5),(-5,3),(-5,-3),(-3,-5));
var
  grid : array[1..100,0..1] of integer;
  p : plist;
  d,e : integer;
begin
      for d:=1 to 100 do begin
        if (d mod 3 = 0) then begin {every third one }
          new(p);
          p^.item := new(ppoint,init(lv1[d,0]*10,lv1[d,1]*10,0));
          p^.item^.powner := p;
          addp(pbeg,pend,p);
        end;
      end;
end;

procedure scale(typ,z,h,w: integer);
var
    vscale   : integer;
    factor   : integer;
begin
    { range of m is -200 to 135 }
    factor:=(200+m)+(z+100);
    if factor<0 then factor:=0;
    vscale:=(factor div 30);
    if vscale<2 then vscale:=2;
    if vscale>195 then vscale:=195;
    ScaleVSP(balls[typ]^,Newsize^,((vscale)+2),(vscale));  { Changes MySprite to be size 16x16 }
end;


procedure drawlist;
var
  nx,ny,nz,
  ox,oy,oz : integer;
  p        : plist;
  dumx,dumy  :integer;
    vscale   : integer;

begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        nx := x; ny := y; nz := z;
        rotate256xyz(nx,ny,nz,0,0,r);
        if p<>pbeg
          then
            begin
            { draw converted point }
              setpoints((nx),(ny),(nz),dumx,dumy);
              ftput(dumx,dumy,balls[21]^,true);
            {pset3d(nx,ny,nz,255);}
            end;

{    if dir=0 then ftput(160,160,balls[5]^,true)
       else if dir=4 then ftput(160,160,balls[8]^,true)
       else if dir=1 then ftput(160,160,balls[10]^,true)
       else if dir=3 then ftput(160,160,balls[15]^,true)
       else if dir=2 then ftput(160,160,balls[0]^,true);
}
        ox := nx; oy := ny; oz := nz;
        p := p^.next;
      end;
end;


procedure getkey;
begin
  if plus
    then r := (r+1)mod 256
    else
     if minus
       then r := (r+255)mod 256;

  {left or right}
  if np[4,2] and (xv>-300)
    then begin
      dir:=4;
    end
    else
      if np[6,2] and (xv<300)
        then begin
          dir:=2;
        end

  {up or down}
  else if np[8,2] and (yv>-300)
    then begin
      dir:=3;
    end
    else
      if np[2,2] and (yv<300)
        then begin
        dir:=1;
      end
  else dir:=0;

  {in or out}
  if np[4,1] and (m>-200)
    then dec(m,5)
    else
      if np[6,1] and (m<135)
        then inc(m,5);


  if dir=1 then inc(yv,5)
     else if dir=2 then inc(xv,5)
     else if dir=3 then dec(yv,5)
     else if dir=4 then dec(xv,5);
end;


procedure drawall(draw:boolean);
var x,y  : integer;
  nx,ny,nz,
  ox,oy,oz : integer;
  p        : plist;
  dumx,dumy  :integer;
    vscale   : integer;

begin
pcopy(3,2);
  setpageactive(2);
  drawlist;
end;


procedure Animate;
begin
  setlevel; zv := 300; m := 0; r := 0;
  repeat
    {drawall(false);}
    getkey;
    drawall(true);
    pcopy(2,1);
  until esc;
end;



procedure initarray;
var x,y,z: integer;
    dummy     : integer;
begin
  for x:=1 to xsize do begin
      for y:=1 to ysize do begin
          for z:=1 to zsize do begin
          xpos:=x;
          ypos:=y;
          zpos:=z;
          {addballs; }
          end;
      end;
  end;
end;

(**) { tpoint methods }

constructor tpoint.init(nx,ny,nz:integer);
begin
  {inherited init;}
  x := nx; y := ny; z := nz;
end;


procedure showit;
begin
   writeln;
   writeln('Keys:');
   writeln(' ESC          - quit demo');
   writeln(' Arrow keys   - change viewer''s postition');
   writeln(' A/D          - move object along Z');
   writeln(' +/-          - rotate object along Z axis');
   writeln;
   write('Press any key.');
   clearbuffer;
   repeat until anykey;
end;


begin
  showit;
  setup;
  Animate;
end.