Program Iris;
   { digital imaging system }
   { Copyright 1993 }
   { by Aaron Wacker }

{$X+ }
{$R- }
{$M 38467,0,655360}

Uses spx_vga,spx_fnc,spx_img,spx_geo,
     spx_obj,spx_ini,spx_gui,spx_txt,
     spx_t3d,Mouse;


Type
  {$IFOPT N+}
    Float = Double;
  {$Else}
    Float = Real;
  {$ENDIF}
  Complex = Record
              Real: Float;
              Imag: Float;
            End; { Record }
  ArrayNP = array[0..255] of integer;
  dvaltype = array[1..25] of integer;

  { This object is for the storage of recognized objects }
  Pballs = ^Tballs;
  Tballs = object(Tobjs)
             width,height,              { dimension of sprite }
             kind,                      { sprite number }
             ox,oy,                     { old position }
             x,y,                       { new position }
             dx,dy : integer;           { direction }
             a,p,e : integer;           { area, perim, elongation }
             train : boolean;           { belongs to training set }
             constructor init(area,perim,elong,nx,ny,k:integer;trn:boolean);
             procedure drawitemobject;virtual;
             procedure eraseitemobject;virtual;
             procedure updateitemobject;virtual;
             procedure calcitemobject;virtual;
             function checkhit(ha,he:integer;item:pobjs):boolean;virtual;
           end;
  Ppoint = ^Tpoint;
  Tpoint = object(Tobjs)
             color      : integer;
             x,y,z      : integer;
             constructor init(nx,ny,nz,c:integer);
           end;

const
   visible     : boolean = True;   { TRUE if mouse cursor is visible }
   mousehere   : boolean = false;   { TRUE if the mouse drv is here }
   mousewason  : boolean = false;   { TRUE is mouse was on from last MOUSEOFF call }
   mouseoncall : boolean = false;   { TRUE if last call was MOUSEON, MOUSEOFF }
   skl         : integer = 1;       { Scale value for X,  some mouse drivers }
   id_quit = 1;               { button handles or id numbers for gui }
   id_go = 2;                 { button handles or id numbers for gui }
   path ='';                  { path to look for files }
   max  = 100;                { maximum number of objects }
   { this is a linked list for the storage of objects such as recognized }
   { shapes.  There are pointers to the beginning and end }
   pbeg : plist = nil;
   pend : plist = nil;
   p2beg : plist = nil;
   p2end : plist = nil;
  xsize = 5;  ysize = 5;  zsize = 5;   { three D visualization stuff }
  spacing = 3;
  recx1 = 1;  recx2 = 320;  recy1 = 1;  recy2 = 200;
  sw = 4; { 1/2 sprite width from center }
  xjump = 10;  yjump = 10;

var
   dummy                           : integer;
   oldexit,oldexitproc             : pointer;  { used to quit }
   d                               : byte;
   s,cf,bf,pl,l                             : string;
   threshold                       : integer;
   hcont,lcont, nothresh           : boolean;  { thresholding opts }
   menuing,expansion,rob,direct    : boolean;  { more options }
   nkbeg,nkend                     : plist;    { object list }
   kill                            : pkill;    { list of obs to remove }
   rsmisc                          : array[0..39] of pointer;
   mx,my,vmx,vmy,mdown      : integer;
   ovx,ovy,gx,gy            : integer;
   placex, placey           : integer;    { use for placing objects }
   placetype,placeframes    : integer;    { number of flip frames the placed ob has}
   placename                : string;     { literal name of object }
   scp                      : RGBlist;    { standard RGB color palette }
   dac                      : RGBlist;    { custom pal from file or pcx }
   lx1,ly1,lx2,ly2          : Integer;    { localized coordinates }
   factr                    : Integer;
   irun,first               : boolean; { program run from .ini file }
   no,ro,so,so3,ed,di,au,hi,
   me,lo,re,ex,th,tr,td,la     : integer;       { options in gui }
   lapE                        : integer;
   list : TobjList;                    { list to contain all objects }
     p,q  : pButton;                   { object pointers }
     pr   : integer;                   { gui choice variable }
     quit,go : boolean;                { gui run/exit variables }
     cradio : integer;          { variable to keep track of which r btn}
     pal   : RGBlist;
     stri                  : string;
     regnum                : integer;    { number of object regions }
     butn, dum             : integer;    { test for mouse }
     balls : array[0..50] of pointer;    { objects captured from image }
     head,tail             : plist;
     odd                   : boolean;             { for gaussian procedure }
     value_save            : float;
  m,r     : integer;
  xpos,ypos,zpos        : integer;
  xa,ya,za              : integer;
  NewSize  : pointer;
  dir      : integer;

function Atan360( x, y: Float): Float;
{ procedure to compute atan360 for the directional values }
{ This will be used in the roberts and sobel procedures. }
Var
  Angle: Float;
Begin
  if X=0 then Angle := Pi/2.0 else angle := ArcTan(Y/X);
  angle := angle*180.0/pi;
  if (X<=0.0) and (Y<0) then angle := angle - 180.0;
  if (X< 0.0) and (Y>0) then angle := angle + 180.0;
  If angle < 0 then angle := angle+360.0;
  Atan360 := angle;
End;

function gauss( mean, StdDev: Float): Float;

{ returns a sample from a Gaussian distribution with the specified }
{ mean and standard deviation. It does it from the taking 2 }
{ independant samples from a uniform distribution. }

const
  sqrt2: Float = 1.414213562373095150;
  pi2:   Float = 6.283185307179586230;

var
  a, b: Float;
  temp1, temp2:  Float;

begin
  if odd Then
   begin
    odd := False;
    gauss := Value_save * StdDev + mean;
    exit;
   end; { if }
   a := Random;
   b := random;
   temp1 := pi2 * a;
   temp2 := Sqrt2 * Sqrt( -ln(b));
   gauss := Cos( Temp1) * temp2 * STDDev + mean;
   value_save := Sin( Temp1) * temp2;
   odd := True;
end;

function area(lx1,lx2,ly1,ly2,c: integer): integer;
{ given local coordinates returns total of pixels }
{ with color c }
var x,y,a  : integer;
begin
   a:=0;
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
         if (point(x,y,2)=c) then a:=a+1;
      end;
   end;
   area:=a;
end;

function perimeter(lx1,lx2,ly1,ly2,c: integer): integer;
{ counts the number of pixels that make up the perimeter }
{ of an object }
var x,y,p  : integer;
begin
   p:=0;
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
         if (point(x,y,2)=c) then
         begin
            if (point(x,y-1,2)=0) or (point(x+1,y,2)=0) or
               (point(x,y+1,2)=0) or (point(x-1,y,2)=0) then
                  p:=p+1;
         end;
      end;
   end;
   perimeter:=p;
end;

function elongation(perim,area: integer): integer;
{ given the area and perimeter, computes elongation }
var e:  integer;
begin
   e:=((perim*perim) div area);
   elongation:=e;
end;

function centroid(x1,x2,y1,y2,area,page,pcolor,cxy : integer): integer;
{ computes the centroid of x and y given boundaries of an object and }
{ info on the page, and color of thresholded object label }
{ cxy 0 is centroid for x  all other vals for cxy give centroid for y }
var x,y,cx,cy  : integer;
begin
   cx:=0; cy:=0;
   for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
         if point(x,y,page)=pcolor then begin
           if cxy=0 then cx:=cx+x else cy:=cy+y;
         end;
      end;
   end;
   if cxy=0 then
      centroid:=round(cx*(1/area)) else
      centroid:=round(cy*(1/area));
end;

procedure copypoints(lx1,lx2,ly1,ly2,c,source,fr,t: integer);
{ checks region label at page source.  if the color is found, }
{ it then copies pixels from one page to another }
var x,y,color  : integer;
begin
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
         if point(x,y,source)=c then color:=point(x,y,fr);
         pset(x,y,t);
      end;
   end;
end;

procedure removeunwant(lx1,lx2,ly1,ly2,c,source,target: integer);
{ checks region labels at page source}
{ then removes pixels that don't belong to region from target }
var x,y,color  : integer;
begin
   setpageactive(target);
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
         if point(x,y,source)<>c then pset(x,y,0); { change to black }
      end;
   end;
end;

procedure drawitems;
var
  p : plist;
begin
  p := pbeg;
  while p<>nil do
    begin
      p^.item^.drawitemobject;
      p := p^.next;
    end;
end;

procedure computeitems;
var
  p : plist;
begin
  p := pbeg;
  while p<>nil do
    begin
      p^.item^.calcitemobject;
      p := p^.next;
    end;
end;

procedure addregion(area,perim,elong,locx,locy,k: integer; training:boolean);
{ add a node to list, and give it properties of an object }
{ found from an image }
var
  p : plist;
  d,e : integer;
begin
      new(p);
      p^.item := new(pballs,init(area,perim,elong,locx,locy,k,training));
      p^.item^.powner := p;
      addp(pbeg,pend,p);
end;

(**) { Tballs methods }

constructor Tballs.init(area,perim,elong,nx,ny,k:integer;trn: boolean);
{ set the variables of a single object in the list }
begin
  Tobjs.init;
  kind := k;
  a:=area; p:=perim; e:=elong;
  x := nx; y := ny; 
  ox := x; oy := y;
    dx := 0;  { motion }
    dy := 0;  { motion }
  train:=trn;
  imagedims(balls[kind]^,width,height);
end;


procedure Tballs.eraseitemobject;
{ erase a drawn object from the screen by copying the original's }
{ rectangle over it }
begin
  CopyRect(ox-width shr 1,oy-height shr 1,ox+width shr 1,oy+height shr 1,pages[3]^,pages[2]^);
  CopyRect(x-width shr 1,y-height shr 1,x+width shr 1,y+height shr 1,pages[3]^,pages[2]^);
end;


procedure Tballs.updateitemobject;
{ refresh the screen with only the rectangle of sprite needed }
{ doing it this way save on redraw time }
begin
  CopyRect(ox-width shr 1,oy-height shr 1,ox+width shr 1,oy+height shr 1,pages[2]^,pages[1]^);
  CopyRect(x-width shr 1,y-height shr 1,x+width shr 1,y+height shr 1,pages[2]^,pages[1]^);
end;


procedure Tballs.drawitemobject;
{ procedure to draw object to page 1.}
{ the pixels with the val of 0 will be masked }
begin
  ftput(x+20,y+20,balls[kind]^,true);
end;


procedure Tballs.calcitemobject;
begin
  if train=false then begin { only check for matches with train set }
    if (checkhit(a,e,@self)) then putletter(x-20,y,230,'train');
  end;
end;

function Tballs.checkhit(ha,he:integer;item:pobjs):boolean;
var ch : boolean;
begin
  ch := (abs(ha-a)<10) and (abs(he-e)<10);
  if (ch=true) and (train=true) then begin  { must match and be training ob }
     putletter(x,y,230,' Here is a possible match. ');
     ftput(x+20,y+20,balls[kind]^,true);
     checkhit:=ch;
  end
  else checkhit:=false;
end;

procedure loadinifile;
{ load a file of default setup options  }
begin
     { dummy will later server for error correction of file reading }
      ro:=(getIniInt('iris.ini','roberts',0,ro));
      so:=(getIniInt('iris.ini','sobel',0,so));
      ed:=(getIniInt('iris.ini','edge',0,ed));
      di:=(getIniInt('iris.ini','direction',0,di));
      au:=(getIniInt('iris.ini','athresh',0,au));
      hi:=(getIniInt('iris.ini','hthresh',0,hi));
      me:=(getIniInt('iris.ini','mthresh',0,me));
      lo:=(getIniInt('iris.ini','lthresh',0,lo));
end;

procedure checkmouseerr;
{ check if mouse exist, display message if not found }
begin
     if mousereset=0
       then message('Mouse not installed',true)
       else normalizemx;           { check mouse horzontal position }
end;


procedure addobs;
{ add gui objects }
begin
    with list do begin

     addobject(new(pbutton,init(140,180,50,15,2,'I',false,'|I|mage File')));
     addobject(new(pButton,init(200,180,50,15,3,'G',false,'|G|o!')));
     addobject(new(pButton,init(260,180,50,15,id_quit,#27,false,'|ESC| Quit')));

     { create radio and check buttons }
     addobject(new(pcheck,init(10,10,60,18,4,'R',false,'|R|oberts   ',false)));
     addobject(new(pcheck,init(10,30,60,18,5,'S',false,'|S|obel     ',false)));
     addobject(new(pcheck,init(10,50,60,18,27,'Z',false,'Sobel 3x3',false)));
     addobject(new(pradio,init(10,70,60,18,6,4,'E',false,'|E|dge      ',cradio=5)));
     addobject(new(pradio,init(10,90,60,18,7,4,'D',false,'|D|irection ',cradio=6)));
     addobject(new(pcheck,init(10,110,60,18,20,'!',false,'Noise|!|    ',false)));

     addobject(new(pcheck,init(10,140,60,18,19,'O',false,'|O|bjects',false)));
     addobject(new(pcheck,init(10,160,60,18,21,'S',false,'Load Sprites',false)));

     addobject(new(pcheck,init(170,10,60,18,22,'@',false,'2d to 3d',false)));
     addobject(new(pButton,init(170,30,60,18,23,'#',false,'Bump Map')));
     addobject(new(pButton,init(170,50,60,18,24,'$',false,'Color Map')));
     addobject(new(pButton,init(170,70,60,18,25,'$',false,'Palette')));

     p:=addobject(new(pstring,init(90,90,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(90,105,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(90,120,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(90,135,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(90,150,34,16,11,#0,false,'','0',3)));

     p:=addobject(new(pstring,init(124,90,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(124,105,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(124,120,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(124,135,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(124,150,34,16,11,#0,false,'','0',3)));

     p:=addobject(new(pstring,init(158,90,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(158,105,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(158,120,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(158,135,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(158,150,34,16,11,#0,false,'','0',3)));

     p:=addobject(new(pstring,init(192,90,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(192,105,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(192,120,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(192,135,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(192,150,34,16,11,#0,false,'','0',3)));

     p:=addobject(new(pstring,init(226,90,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(226,105,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(226,120,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(226,135,34,16,11,#0,false,'','0',3)));
     p:=addobject(new(pstring,init(226,150,34,16,11,#0,false,'','0',3)));

     p:=addobject(new(pstring,init(260,105,60,16,14,'1',false,'Factor','3',3)));
     p:=addobject(new(pstring,init(260,135,60,16,14,'1',false,'Bias  ','3',3)));

     addobject(new(pradio,init(90,50,60,18,8,5,'A',false,'|A| Thresh',cradio=7)));
     addobject(new(pradio,init(90,70,60,18,9,5,'H',false,'|H| Thresh',cradio=8)));
     {
     addobject(new(pradio,init(90,90,60,18,10,5,'M',false,'|M| Thresh',cradio=9)));
     addobject(new(pradio,init(90,110,60,18,11,5,'L',false,'|L| Thresh',cradio=10)));
     addobject(new(pradio,init(90,130,60,18,18,5,'N',true,'|N|o Thresh',cradio=11)));
     }
     addobject(new(pcheck,init(90,10,60,18,12,'X',false,'E|x|pansion',false)));
     addobject(new(pcheck,init(90,30,60,18,13,'T',false,'|T|hinning',false)));

     { create scrollers }
     {addobject(new(pscroll,init(20,100,100,15,8,1,100,1,50,true)));}
     {addobject(new(pscroll,init(160,20,15,100,9,1,100,2,50,false)));}

     { create pick box }
     {addobject(new(ppbox,init(180,20,100,10,10,'Pick Box')));}

     { create string input boxes }
     p:=addobject(new(pstring,init(250,10,60,16,14,'1',false,'|1| X1','3',3)));
     p:=addobject(new(pstring,init(250,26,60,16,15,'2',false,'|2| X2','100',3)));
     p:=addobject(new(pstring,init(250,42,60,16,16,'3',false,'|3| Y1','3',3)));
     p:=addobject(new(pstring,init(250,58,60,16,17,'4',false,'|4| Y2','100',3)));
    end;
end;

procedure drawpage;
{ load a pcx 320-200 file and fade in its set of colors }
var
x,y           : Integer;

begin
  { copy pcx file to page 1 }
  fsetcolors(zdc);
  setpageactive(1);
  loadpcx(s);
  pcopy(1,2);
  pcopy(1,3);
  fadein(20,rgb256);
end;

procedure drawpage2;
{ same as above without modifying page 1 }
{ page is drawn quietly in background }
var
x,y           : Integer;
begin
  { copy pcx file to page 2 }
  fsetcolors(zdc);
  setpageactive(2);
  loadpcx(s);
  pcopy(2,3);
  setpageactive(1);
end;

procedure loadtrains;
{ will be used to load a pcx file to provide a training set }
{ for object recognition }
var
x,y           : Integer;
begin
  { copy training file to page 2 }
  fsetcolors(zdc);
  setpageactive(2);
  loadpcx(s);
  pcopy(2,3);
  setpageactive(1);
end;


procedure initgui;
{ load the title page, and setup palettes }
{ get the gui setup, and adjust the cosmetics of gui }
begin
     checkmouseerr;
     list.init;         { init object list }
     { add the buttons to the linked list }
     addobs;
     setpageactive(1);
     cradio := 5;       { Set radios to Default }
     fsetcolors(zdc);   { all black palette }
     if first then begin
        loadpcx(path+'iristitl.pcx');
        menucolors := burntsienna;
        fadein(80,rgb256);
        fadeout(40,rgb256);
        cls(0);
        fadein(20,rgb256);
     end;
     adjustmenupalette;
end;

     
procedure rungui;
{ check button objects for input and adjust option variables }
var   t            : integer;

   begin
     setdefptr;
     visible:=true;
     {loadinifile;} { load init values for buttons }
     with list do
       begin
        showall;
        mouseon; { turn on mouse if available }
        quit := false; { set exit flag }
        go   := false;

        { program loop... }
         repeat
           inkey;                    { grab key and mouse strokes }
           pr := checkpress(p);      { process key and mouse strokes }
          { check if any objects were activated }
           case pr of

             1 : quit := yes('Exit Iris?');

             { button - call disk dialog box }
             2 : begin
                  stri := diskdo(24,10,'','pcx','Enter image name to process',true);
                  if stri<>''
                  then begin
                    dummy:=setIniString('iris.ini','imfile',stri);
                    {message('File is '+stri,true);}
                    s:=stri;
                    drawpage2;
                  end;
                end;

             3 : begin
               go :=yes('Run with these options?');
             end;
             4 : begin
               setIniInt('iris.ini','roberts',1);
               setIniInt('iris.ini','sobel',0);
               ro:=1; so:=0; so3:=0;
             end;
             5 : begin
               setIniInt('iris.ini','roberts',0);
               setIniInt('iris.ini','sobel',1);
               ro:=0; so:=1; so3:=0;
             end;
             6 : begin
               setIniInt('iris.ini','edge',1);
               setIniInt('iris.ini','direction',0);
               ed:=1; di:=0;
             end;
             7 : begin
               setIniInt('iris.ini','edge',0);
               setIniInt('iris.ini','direction',1);
               ed:=0; di:=1;
             end;
             8 : begin
               setIniInt('iris.ini','athresh',1);
               setIniInt('iris.ini','hthresh',0);
               setIniInt('iris.ini','mthresh',0);
               setIniInt('iris.ini','lthresh',0);
               au:=1; hi:=0; me:=0; lo:=0;
             end;
             9 : begin
               setIniInt('iris.ini','athresh',0);
               setIniInt('iris.ini','hthresh',1);
               setIniInt('iris.ini','mthresh',0);
               setIniInt('iris.ini','lthresh',0);
               au:=0; hi:=1; me:=0; lo:=0;
             end;
             10 : begin
               setIniInt('iris.ini','athresh',0);
               setIniInt('iris.ini','hthresh',0);
               setIniInt('iris.ini','mthresh',1);
               setIniInt('iris.ini','lthresh',0);
               au:=0; hi:=0; me:=1; lo:=0;
             end;
             11 : begin
               setIniInt('iris.ini','athresh',0);
               setIniInt('iris.ini','hthresh',0);
               setIniInt('iris.ini','mthresh',0);
               setIniInt('iris.ini','lthresh',1);
               au:=0; hi:=0; me:=0; lo:=1;
             end;
             12 : begin
               setIniInt('iris.ini','expansion',1);
               if ex<>1 then ex:=1 else ex:=0;
             end;
             13 : begin
               setIniInt('iris.ini','thinning',1);
               if th<>1 then th:=1 else th:=0;
             end;
             14 : begin
               t := vl(pstring(p)^.tstr);  { grab text string }
               if between(t,3,317)     { check for legal values }
               then
                 begin
                   lx1:=t;
                 end;
               setIniInt('iris.ini','x1',1);
             end;
             15 : begin
               t := vl(pstring(p)^.tstr);  { grab text string }
               if between(t,3,317)     { check for legal values }
               then
                 begin
                   lx2:=t;
                 end;
               setIniInt('iris.ini','x2',1);
             end;
              16 : begin
               t := vl(pstring(p)^.tstr);  { grab text string }
               if between(t,3,197)     { check for legal values }
               then
                 begin
                   ly1:=t;
                 end;
               setIniInt('iris.ini','y1',1);
             end;
             17 : begin
               t := vl(pstring(p)^.tstr);  { grab text string }
               if between(t,3,197)     { check for legal values }
               then
                 begin
                   ly2:=t;
                 end;
               setIniInt('iris.ini','y2',1);
             end;
             18 : begin
               setIniInt('iris.ini','athresh',0);
               setIniInt('iris.ini','hthresh',0);
               setIniInt('iris.ini','mthresh',0);
               setIniInt('iris.ini','lthresh',0);
               au:=0; hi:=0; me:=0; lo:=0;
             end;
              19 : begin
               {message('Select a threshold for objects ',true);}
               re:=1;
              end;
              20 : begin
                no:=1;
              end;
             { button - call disk dialog box }
             21 : begin
                  stri := diskdo(24,10,'','pcx','Enter training template image to use',true);
                  if stri<>''
                  then begin
                    message('Template file is '+stri,true);
                    s:=stri;
                    loadtrains;
                    tr:=1;
                  end;
                end;
             22 : begin
                    td:=1;
                end;
             23 : begin
                  stri := diskdo(24,10,'','pcx','Enter image to use as height info.',true);
                  if stri<>''
                  then begin
                    message('bump map file is '+stri,true);
                    bf:=stri;
                  end;
                end;
             24 : begin
                  stri := diskdo(24,10,'','pcx','Enter image to use as color info.',true);
                  if stri<>''
                  then begin
                    message('color file is '+stri,true);
                    cf:=stri;
                  end;
                end;
             25 : begin
                  stri := diskdo(24,10,'','pal','Enter palette to use.',true);
                  if stri<>''
                  then begin
                    message('palette file is '+stri,true);
                    pl:=stri;
                  end;
                end;
             26 : begin
                    la:=1;
                end;
             27 : begin
               setIniInt('iris.ini','roberts',0);
               setIniInt('iris.ini','sobel',0);
               ro:=0; so:=0; so3:=1;
             end;
             28 : begin
               t := vl(pstring(p)^.tstr);  { grab text string }
               if between(t,1,255)     { check for legal values }
               then
                 begin
                   lapE:=t;
                 end;
             end;

           end;
         until quit or go;
       end;
   end;


procedure initrun(var filename: string);
{ load a set of operating variables to use as default settings }
var
     dummy                : integer;
begin
      { dummy will later serve for error correction of file reading }
      dummy:=getIniString('iris.ini','imname','train.pcx',filename);
      dummy:=(getIniInt('iris.ini','roberts',0,ro));
      dummy:=(getIniInt('iris.ini','sobel',0,so));
      dummy:=(getIniInt('iris.ini','edge',0,ed));
      dummy:=(getIniInt('iris.ini','direction',0,di));
      dummy:=(getIniInt('iris.ini','athresh',0,au));
      dummy:=(getIniInt('iris.ini','hthresh',0,hi));
      dummy:=(getIniInt('iris.ini','mthresh',0,me));
      dummy:=(getIniInt('iris.ini','lthresh',0,lo));
end;

procedure zerooptions;
{ set gui options to zero as a default }
begin
  no:=0; ro:=0; so:=0; ed:=0; di:=0; td:=0; la:=0;
  au:=0; hi:=0; me:=0; lo:=0; re:=0; ex:=0; th:=0;
end;


procedure setparms;
{ initialize linked lists and initialize gui options }
var
  d : integer;
  p : plist;
begin
  kill := nil;
  nkbeg := nil; nkend := nil;
  lx1:=3;  lx2:=100;  ly1:=3;  ly2:=100;
  regnum:=0;
  zerooptions;
end;

procedure setup;
var dummy :Integer;
    filename  : string;
begin
 randomize;
 if paramcount<1
 then
  begin
     initrun(filename);
     s:=filename;
     irun:=true;
     lapE:=3;
  end
  else begin

  s := paramstr(1); l := '';
  for d := 2 to paramcount do
    l := l+ups(paramstr(d));

  { warn user if pcx file isn't there }
  if not exist(s)
    then
      if exist(s+'.PCX')
        then s := s+'.PCX'
        else
            begin
                writeln('The file: ',s,' could not be found');
                halt(1);
            end;

     {hcont := (pos('/H',l)<>0);
     lcont := (pos('/L',l)<>0);
     nothresh := (pos('/N',l)<>0);
     expansion := not (pos('/E',l)<>0);
     rob       := (pos('/R',l)<>0);
     direct    := (pos('/D',l)<>0);}

     { define threshold according to user choice }
     if hcont then threshold:=65
       else if lcont then threshold:=15
            else if nothresh then threshold:=5
                 else threshold:=25;
  end;   { interactive }

  randomize;
  setparms;
  {clearbuffer;}
  openmode(3);

end;

procedure cleanup; far;
begin
   { close graphics mode 13 }
   closemode;
   { turn off mouse if available }
   mouseoff;
   { deallocate object list }
   list.done;
   exitproc := oldexitproc;                                      
end;



procedure noise(color,variance,amount,x1,x2,y1,y2: integer);
var x,y   : Integer;
    dummy : Integer;
    nosx,nosy       : Integer;

begin
     for dummy:=1 to amount do begin
         nosx:=random(x2-x1)+x1;
         nosy:=random(y2-y1)+y1;
         pset(nosx,nosy,color+random(variance));
     end;
end;


procedure averg(bcolor,range,x1,y1,x2,y2: integer);
{ set all pixels within range to bcolor }
var
x,y     : Integer;
p       : Integer;
pwithin : Boolean;
begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
      p:=Point(x,y,1);
      pwithin := (abs(bcolor-p)<=range) and (abs(p-bcolor)<=range);
      if pwithin=TRUE then pset(x,y,bcolor) else pset(x,y,p);
      end;
  end;
end;

procedure seperate(x1,x2,y1,y2,threshold: integer);
{ turn all pixels above threshold white, and below threshold black }
var
x,y     : Integer;
p       : Integer;
begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
      p:=Point(x,y,1);
      if p<threshold then pset(x,y,0) else pset(x,y,255);
      end;
  end;
end;

procedure remove(color :byte;x1,x2,y1,y2: integer);
{ turn to black all points of a certain color }
var
x,y     : Integer;
p       : Integer;
begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
      p:=Point(x,y,1);
      if Point(x,y,1)=color then pset(x,y,0);
      end;
  end;
end;

procedure changeclr(color,newcolor :byte;x1,x2,y1,y2: integer);
{ turn to newcolor all points of a certain color }
var
x,y     : Integer;
p       : Integer;
begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
      p:=Point(x,y,1);
      if Point(x,y,1)=color then pset(x,y,newcolor);
      end;
  end;
end;


function mostused(x1,x2,y1,y2: integer): integer;
{ return most used color in a localized area }
var
   ctr,x,y,most     : Integer;
   values           : array[1..255] of integer;
begin
     most:=0;
     for ctr:=1 to 255 do values[ctr]:=0;
     for x:=x1 to x2 do begin
         for y:=y1 to y2 do begin
         values[Point(x,y,1)]:=values[Point(x,y,1)]+1;
         end;
     end;
     for ctr:=1 to 255 do if values[ctr]>most then
         most:=values[ctr];
     mostused:=most;
end;

procedure moment(data: arraynp; n   : integer;
    var ave,adev,sdev,svar,skew,curt: real);
{ compute all kinds of cool statistics stuff for an array of data }
var j   : integer;
    s,p : real;
begin
   if n<=1 then begin
      putletter(50,40,230,'N must be at least 2');
   end;
   s:=0.0;
   for j:=0 to n do s:=s+data[j];
   ave:=s/(n+1);
   adev:=0.0;
   svar:=0.0;
   skew:=0.0;
   curt:=0.0;
   for j:=0 to n do begin
       s:=data[j]-ave;
       adev:=adev+abs(s);
       p:=s*s;
       svar:=svar+p;
       p:=p*s;
       skew:=skew+p;
       p:=p*s;
       curt:=curt+p;
   end;
   adev:=adev/(n+1);
   svar:=svar/(n+1);
   sdev:=sqrt(svar);
   if svar<>0.0 then begin
      skew:=skew/((n+1)*sdev*sdev*sdev);
      curt:=curt/((n+1)*sqr(svar))-3.0;
   end
   else begin
      putletter(50,40,230,'No skew/kurtosis when variance=0');
   end;
end;


procedure autothresh(x1,x2,y1,y2: integer);
{ automatically select a threshold by taking the minimum }
{ number of color values from the range of 1 to the max }
{ object signal }
var
   ctr,x,y             : Integer;
   values              : arraynp;
   newvalues           : arraynp;
   least,leastidx,
   most,mostidx  : integer;
   ave,adev,sdev,svar,skew,curt  : real;
begin

     least:=1000;
     for ctr:=0 to 255 do values[ctr]:=0;

     { get the histogram }
     for x:=x1 to x2 do begin
         for y:=y1 to y2 do begin
         values[Point(x,y,1)]:=values[Point(x,y,1)]+1;
         end;
     end;

     pcopy(1,2);
     { draw the bars to the screen }
     for ctr:=3 to 253 do bar(ctr+36,195,ctr+36,(195-((values[ctr]) div 2)),ctr);
        moment(newvalues,255,ave,adev,sdev,svar,skew,curt);
              putletter(200,40,230,'average ='+st(round(ave)));
              putletter(200,50,230,'ave.deviation ='+st(round(adev)));
              putletter(200,60,230,'s.deviation ='+st(round(sdev)));
              putletter(200,70,230,'s.variance ='+st(round(svar)));
              putletter(200,80,230,'skew ='+st(round(skew)));
              putletter(200,90,230,'kurtosis ='+st(round(curt)));
     {repeat getmouse(butn,dum,dum) until butn=1;}
     pcopy(2,1);

     { create a smoothed histogram }
     for ctr:=0 to 246 do
         newvalues[ctr]:=(((values[ctr])+(values[ctr+1])+(values[ctr+2])+
            (values[ctr+3])+(values[ctr+4])+(values[ctr+5])
            +(values[ctr+6])+(values[ctr+7])+(values[ctr+8])) div 9);
     { pad with zeroes }
     for ctr:=247 to 255 do newvalues[ctr]:=0;

     most:=0;
     { find most used color excluding black }
     for ctr:=255 downto 1 do if (newvalues[ctr]>most) then
     begin
         mostidx:=ctr;
         most:=newvalues[ctr];
     end;

     { find least value of color after maximum signal }
     { don't check near zero thresholds }
     for ctr:=mostidx downto 1 do if (newvalues[ctr]<least)
         then begin
            leastidx:=ctr;
            least:=newvalues[ctr];
         end;

     pcopy(1,2);
     { draw the bars to the screen }
     for ctr:=3 to 253 do bar(ctr+36,195,ctr+36,(195-((newvalues[ctr]) div 2)),ctr);
        moment(newvalues,255,ave,adev,sdev,svar,skew,curt);
              putletter(200,40,230,'average ='+st(round(ave)));
              putletter(200,50,230,'ave.deviation ='+st(round(adev)));
              putletter(200,60,230,'s.deviation ='+st(round(sdev)));
              putletter(200,70,230,'s.variance ='+st(round(svar)));
              putletter(200,80,230,'skew ='+st(round(skew)));
              putletter(200,90,230,'kurtosis ='+st(round(curt)));
     {repeat getmouse(butn,dum,dum) until butn=1;}
     pcopy(2,1);
     {repeat getmouse(butn,dum,dum) until butn=1;}

     seperate(lx1,lx2,ly1,ly2,leastidx);
     {repeat getmouse(butn,dum,dum) until butn=1;}

end;

procedure histogram(x1,x2,y1,y2,thresh,showbars: integer);
{ leaves pages two and one seperated according to threshold }
{ if showbars is 0 then they won't display and page two will be unaltered }

var
x,y               : Integer;
ctr,ctr2          : Integer;
values            : arraynp;
barvals           : array[1..50] of integer;
totalval          : Integer;
avwidth           : Integer;
ave,adev,sdev,svar,skew,curt  : real;

begin
     { tally up the numbers of pixels used }
     { checking page two }
     for ctr:=1 to 255 do values[ctr]:=0;
     for x:=x1 to x2 do begin
         for y:=y1 to y2 do begin
         values[Point(x,y,1)]:=values[Point(x,y,1)]+1;
         end;
     end;

     if showbars <>0 then begin
       pcopy(1,2);
       { draw the bars to the screen }
       for ctr:=3 to 253 do bar(ctr+36,195,ctr+36,(195-((values[ctr]) div 2)),ctr);
         moment(values,255,ave,adev,sdev,svar,skew,curt);
              putletter(200,40,230,'average ='+st(round(ave)));
              putletter(200,50,230,'ave.deviation ='+st(round(adev)));
              putletter(200,60,230,'s.deviation ='+st(round(sdev)));
              putletter(200,70,230,'s.variance ='+st(round(svar)));
              putletter(200,80,230,'skew ='+st(round(skew)));
              putletter(200,90,230,'kurtosis ='+st(round(curt)));
       {repeat getmouse(butn,dum,dum) until butn=1;}
       pcopy(2,1);
     end; { page 2 is untouched }

      setpageactive(1);
      if thresh=0 then autothresh(lx1,lx2,ly1,ly2)
         else seperate(lx1,lx2,ly1,ly2,thresh);
      {turn the values below threshold black and others white}
end;

procedure boundbox(lx1,lx2,ly1,ly2,color : integer;
                   var xmin,xmax,ymin,ymax : integer);
{ given a color label this finds the bounding box surrounding a region }
{ does not modify page }
var x,y : integer;
begin
  xmin:=500; xmax:=0;
  ymin:=500; ymax:=0;
  for x:=lx1 to lx2 do begin
    for y:=ly1 to ly2 do begin
       if point(x,y,2)=color then begin
          if x>xmax then xmax:=x;
          if x<xmin then xmin:=x;
          if y>ymax then ymax:=y;
          if y<ymin then ymin:=y;
       end;
    end;
  end;
end;

procedure regionize(x1,x2,y1,y2: integer; var regnum: integer; trn: boolean);
var x,y             : integer;
    pcolor          : integer;
    a,p,e           : integer;
    ar,pe,el        : integer;
    xmin,xmax,ymin,ymax      : integer;    { sides of a bounding box }
    cx,cy                    : integer;
begin
  pcopy(1,2);   { page 1 and 2 are the same }

  pcolor:=30;
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin
         if Point(x,y,2)=255 then begin
            if pcolor>255 then pcolor:=30;

            setpageactive(2);
            paint(x,y,pcolor);

              { seperate noise from objects }
              boundbox(lx1,lx2,ly1,ly2,pcolor,xmin,xmax,ymin,ymax);

            ar:=area(xmin,xmax,ymin,ymax,pcolor);
            pe:=perimeter(xmin,xmax,ymin,ymax,pcolor);
            el:=elongation(p,a);
            a:=ar;  p:=pe;  e:=el;

              cx:=centroid(xmin,xmax,ymin,ymax,a,2,pcolor,0);
              cy:=centroid(xmin,xmax,ymin,ymax,a,2,pcolor,1);

              getmem(balls[regnum],buffsize(xmax-xmin+1,ymax-ymin+1));
              pcopy(3,1);    { refresh the screen to original picture }

              { remove original pts that aren't in the connected region }
              { but are within the bounding box of the region on page 1 }
              removeunwant(xmin,xmax,ymin,ymax,pcolor,2,1);

              { copy object to double linked list }
              setpageactive(1);
              fget(xmin,ymin,xmax,ymax,balls[regnum]^);
              setpageactive(1);
              { display grabbed object }
              ftput(250,100,balls[regnum]^,false);
              { display the connected region }
              CopyRect(xmin,ymin,xmax,ymax,pages[2]^,pages[1]^);

              addregion(a,p,e,xmin,ymin,regnum,trn);
              regnum:=regnum+1;              { tally the number of regions }

              rectangle(xmin,ymin,xmax,ymax,pcolor);
              pcolor:=pcolor+7;              { color label for object }
              if pcolor>256 then pcolor:=20; { if many objs }
              putletter(250,40,230,'Regions ='+st(regnum));
              putletter(250,50,230,'Perim.  ='+st(pe));
              putletter(250,60,230,'Area    ='+st(ar));
              putletter(250,70,230,'Elong.  ='+st(el));
              putletter(250,80,230,'Cent.X  ='+st(cx));
              putletter(250,90,230,'Cent.Y  ='+st(cy));

         end;
      end;
  end;
end;


procedure laplacian(x1,x2,y1,y2: integer);

var
x,y,ctr          : Integer;
xindex           : Integer;
yindex           : Integer;
d1               : array[1..9] of integer;
d2               : array[1..9] of integer;
newpoint1,newpoint2            : Integer;
newpt                          : Integer;
yoverx                         : Integer;
arct2                          : Integer;
totlyx, totlyx2                : Integer;

begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin

      {* Laplacian delta *}
      d1[1]:= 0;
      d1[2]:= 1* Point(x,y-1,2);
      d1[3]:= 0;
      d1[4]:= 1* Point(x+1,y,2);
      d1[5]:= -4* Point(x,y,2);
      d1[6]:= 1* Point(x-1,y,2);
      d1[7]:= 0;
      d1[8]:= 1* Point(x,y+1,2);
      d1[9]:= 0;

      { add up the values in from the delta array }
      newpoint1:=0;
      for ctr:=1 to 9 do newpoint1:=newpoint1+d1[ctr];

      newpoint1:=newpoint1 div lapE;
      { copy the output of the operator to the screen }
      setpageactive(1);
      pset(x,y,newpoint1);
      setpageactive(2);

      end;
      {if space then exit;}
  end; {for 0-319}
  {if space then exit;}
  pcopy(1,2); { copy the result to the work page }
end;



procedure roberts(x1,x2,y1,y2,ed: integer);
{ find edges using a two 2X2 roberts templates }
{ operates on graphics page one and two }

var
x,y,ctr          : Integer;
xindex           : Integer;
yindex           : Integer;
d1               : array[1..4] of integer;
d2               : array[1..4] of integer;
newpoint1,newpoint2            : Integer;
newpt                          : Integer;
yoverx                         : Integer;
arct2                          : Integer;
totlyx, totlyx2                : Integer;

begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin

      {* Roberts delta 1 *}
      d1[1]:= 0* Point(x,y,2);
      d1[2]:= 1* Point(x,y+1,2);
      d1[3]:= -1*Point(x+1,y,2);
      d1[4]:= 0* Point(x+1,y+1,2);

      {* Roberts delta 2 *}
      d2[1]:= 1* Point(x,y,2);
      d2[2]:= 0* Point(x,y+1,2);
      d2[3]:= 0* Point(x+1,y,2);
      d2[4]:= -1*Point(x+1,y+1,2);

      { add up the values in from the delta arrays }
      newpoint1:=0;
      newpoint2:=0;
      for ctr:=1 to 4 do newpoint1:=newpoint1+d1[ctr];
      for ctr:=1 to 4 do newpoint2:=newpoint2+d2[ctr];

     if ed=1 then begin
         newpt:=(newpoint1*newpoint1) + (newpoint2*newpoint2);
         if newpt<1 then newpt:=0;
         newpt:=round(sqrt(newpt));
         {scale because of pixel:=255 sqrt 2}
         newpt:=round((newpt / (sqrt(2))));
      end
      else begin
         { compose a directional image }
         newpt:=round(atan360(newpoint2,newpoint1));

         {range is 0 to 360 so change to fit in 0-255}
         newpt:=round(newpt*(255/360));
      end;

      { copy the output of the operator to the screen }
      setpageactive(1);
      pset(x,y,newpt);
      setpageactive(2);

      end;
      {if space then exit;}
  end; {for 0-319}
  {if space then exit;}
  pcopy(1,2); { copy the result to the work page }
end;

procedure sobel3x3(x1,x2,y1,y2,ed: integer);
{ find edges using a two sobel 3x3 templates }
{ operates on graphics page one and two }

var
x,y,ctr          : Integer;
xindex           : Integer;
yindex           : Integer;
d1               : array[1..9] of integer;
d2               : array[1..9] of integer;
newpoint1,newpoint2            : Integer;
newpt                          : Integer;
yoverx                         : Integer;
arct2                          : Integer;
totlyx, totlyx2                : Integer;

begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin

      {* sobel delta 1 *}
      d1[1]:= -1* Point(x-1,y-1,2);
      d1[2]:= 0;
      d1[3]:= 1*Point(x-1,y+1,2);
      d1[4]:= -2* Point(x,y-1,2);
      d1[5]:= 0;
      d1[6]:= 2* Point(x,y+1,2);
      d1[7]:= -1* Point(x+1,y-1,2);
      d1[8]:= 0;
      d1[9]:= 1* Point(x+1,y+1,2);

      {* sobel delta 2 *}
      d2[1]:= 1* Point(x-1,y-1,2);
      d2[2]:= 2* Point(x-1,y,2);
      d2[3]:= 1* Point(x-1,y+1,2);
      d2[4]:= 0;
      d2[5]:= 0;
      d2[6]:= 0;
      d2[7]:= -1*Point(x+1,y-1,2);
      d2[8]:= -2*Point(x+1,y,2);
      d2[9]:= -1*Point(x+1,y+1,2);

      { add up the values in from the delta arrays }
      newpoint1:=0;
      newpoint2:=0;
      for ctr:=1 to 9 do newpoint1:=newpoint1+d1[ctr];
      for ctr:=1 to 9 do newpoint2:=newpoint2+d2[ctr];

     if ed=1 then begin
         newpt:=(newpoint1*newpoint1) + (newpoint2*newpoint2);
         if newpt<1 then newpt:=0;
         newpt:=round(sqrt(newpt));
         {scale because of pixel:=255 sqrt 2}
         newpt:=round((newpt / (sqrt(2))));
      end
      else begin
         { compose a directional image }
         newpt:=round(atan360(newpoint2,newpoint1));

         {range is 0 to 360 so change to fit in 0-255}
         newpt:=round(newpt*(255/360));
      end;

      { copy the output of the operator to the screen }
      setpageactive(1);
      pset(x,y,newpt);
      setpageactive(2);

      end;
      {if space then exit;}
  end; {for 0-319}
  {if space then exit;}
  pcopy(1,2); { copy the result to the work page }
end;


procedure filter(x1,x2,y1,y2,dsize,dfactor,dbias: integer;
          dval: dvaltype);

var
ctr              : Integer;
xindex           : Integer;
yindex           : Integer;
d1               : array[1..25] of integer;
d2               : array[1..25] of integer;
x,y                            : Integer;
newpoint1,newpoint2            : Integer;
newpt                          : Integer;

                               
begin
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin

      {**** filter delta 1 ****}
      d1[1]:= dval[1]*Point(x-2,y-2,1);
      d1[2]:= dval[2]*Point(x-2,y-1,1);
      d1[3]:= dval[3]*Point(x-2,y,1);
      d1[4]:= dval[4]*Point(x-2,y+1,1);
      d1[5]:= dval[5]*Point(x-2,y+2,1);

      d1[6]:= dval[6]*Point(x-1,y-2,1);
      d1[7]:= dval[7]*Point(x-1,y-1,1);
      d1[8]:= dval[8]*Point(x-1,y,1);
      d1[9]:= dval[9]*Point(x-1,y+1,1);
      d1[10]:=dval[10]*Point(x-1,y+2,1);

      d1[11]:= dval[11]*Point(x,y-2,1);
      d1[12]:= dval[12]*Point(x,y-1,1);
      d1[13]:= dval[13]*Point(x,y,1);;
      d1[14]:= dval[14]*Point(x,y+1,1);
      d1[15]:= dval[15]*Point(x,y+2,1);

      d1[16]:= dval[16]*Point(x+1,y-2,1);
      d1[17]:= dval[17]*Point(x+1,y-1,1);
      d1[18]:= dval[18]*Point(x+1,y,1);
      d1[19]:= dval[19]*Point(x+1,y+1,1);
      d1[20]:= dval[20]*Point(x+1,y+2,1);

      d1[21]:= dval[21]*Point(x+2,y-2,1);
      d1[22]:= dval[22]*Point(x+2,y-1,1);
      d1[23]:= dval[23]*Point(x+2,y,1);
      d1[24]:= dval[24]*Point(x+2,y+1,1);
      d1[25]:= dval[25]*Point(x+2,y+2,1);

      { add up the values in from the delta arrays }
      newpoint1:=0;
      newpt:=0;
      for ctr:=1 to 25 do newpoint1:=newpoint1+d1[ctr];

      newpoint1:=newpoint1*dfactor;
      newpoint1:=newpoint1+dbias;

         if newpoint1<0 then newpoint1:=0;
         if newpoint1>255 then newpoint1:=255;

      { copy the output of the operator to the screen }
      setpageactive(2);
      pset(x,y,newpoint1);
      setpageactive(1);

      end; {for y}
      {if space then exit;}
  end; {for x}

  {if esc then exit;}
  pcopy(2,1); {so user can see}
end;

procedure expand(color,x1,x2,y1,y2: integer);
var  x,y                 : Integer;

begin
  setpageactive(3);
  cls(0);  {clear page three}
  setpageactive(2);
  for x:=x1 to x2 do begin
      for y:=y1 to y2 do begin

      { for each white point expand }
      if (Point(x,y,1)=color) then
      begin
         setpageactive(3);
         pset(x,y,color);

         pset(x+1,y,color);
         pset(x-1,y,color);
         pset(x,y+1,color);
         pset(x,y-1,color);

         pset(x+1,y+1,color);
         pset(x-1,y+1,color);
         pset(x+1,y-1,color);
         pset(x-1,y-1,color);

      end; {if}
      end; {for}
  end; {for}
  pcopy(3,1);   {copy to screen}
  pcopy(3,2);   {copy to work page}
end;


procedure thin(color,x1,x2,y1,y2: integer);
var N,S,E,W,NE,NW,SE,SW : Byte;
    a,b,c,neighbors     : Integer;
    x,y                 : Integer;
    dir                 : Byte;
    thintimes           : Byte;
    removedpts          : Integer;

begin
  setpageactive(3);
  cls(0);          {clear page 3 to color 0}
  setpageactive(2);
  pcopy(1,2);

  for thintimes:=1 to 20 do begin {don't make more than 20 passes}
  removedpts:=0;                  {give a way out if thinning done}
    for dir:=1 to 4 do begin      { N, S, E, W }
      for x:=x1 to x2 do begin
        for y:=y1 to y2 do begin

      if point(x,y,1)=color then begin
         N:=ord(Point(x,y-1,1)=color);
         S:=ord(Point(x,y+1,1)=color);
         E:=ord(Point(x+1,y,1)=color);
         W:=ord(Point(x-1,y,1)=color);
         NE:=ord(Point(x+1,y-1,1)=color);
         NW:=ord(Point(x-1,y-1,1)=color);
         SE:=ord(Point(x+1,y+1,1)=color);
         SW:=ord(Point(x-1,y+1,1)=color);

         neighbors:=N+S+E+W+NE+NW+SE+SW;
         a:= ord(neighbors < 2);
         b:= ord(       (neighbors > 1) and
                     ( ((N=0) and (E=1) and (S=0) and (W=1)) or
                       ((N=1) and (E=0) and (S=1) and (W=0)) or
                       ((W=0) and (SW=1) and (S=0)) or
                       ((N=0) and (NE=1) and (E=0)) or
                       ((E=0) and (SE=1) and (S=0)) or
                       ((NW=1) and (N=0) and (W=0)) )     );
         {North}
         if dir=1 then begin
            c:= ord(N=1);
            if not((a=1) or (b=1) or (c=1)) then begin
              pset(x,y,0);
              removedpts:=removedpts+1;
            end;
         end;

         {East}
         if dir=3 then begin
            c:= ord(E=1);
            if not((a=1) or (b=1) or (c=1)) then begin
              pset(x,y,0);
              removedpts:=removedpts+1;
            end;
         end;

         {South}
         if dir=2 then begin
            c:= ord(S=1);
            if not((a=1) or (b=1) or (c=1)) then begin
              pset(x,y,0);
              removedpts:=removedpts+1;
            end;
         end;

         end; {if}
        end;   {y}
      end; {x}
  pcopy(2,1);  {so user can see each pass}

       if dir=4 then begin
         {West}
         {Check westward to prevent removing}
         {more than one point at a time when thinning}
         if point(x,y,1)=color then begin
         for x:=x2 downto x1 do begin
           for y:=y2 downto y1 do begin

           N:=ord(Point(x,y-1,1)=color);
           S:=ord(Point(x,y+1,1)=color);
           E:=ord(Point(x+1,y,1)=color);
           W:=ord(Point(x-1,y,1)=color);
           NE:=ord(Point(x+1,y-1,1)=color);
           NW:=ord(Point(x-1,y-1,1)=color);
           SE:=ord(Point(x+1,y+1,1)=color);
           SW:=ord(Point(x-1,y+1,1)=color);

           neighbors:=N+S+E+W+NE+NW+SE+SW;
           a:= ord(neighbors < 2);
           b:= ord(       (neighbors > 1) and
                     ( ((N=0) and (E=1) and (S=0) and (W=1)) or
                       ((N=1) and (E=0) and (S=1) and (W=0)) or
                       ((W=0) and (SW=1) and (S=0)) or
                       ((N=0) and (NE=1) and (E=0)) or
                       ((E=0) and (SE=1) and (S=0)) or
                       ((NW=1) and (N=0) and (W=0)) )     );
            c:= ord(W=1);
            if not((a=1) or (b=1) or (c=1)) then begin
               pset(x,y,0);
               removedpts:=removedpts+1;
            end; {if not West}
            end; {if point=color}
            end; {y}
         end;   {x}
      pcopy(2,1);  {so user can see each pass}
      end; {if dir=4}

   end; {dir}
   {if ((space) or (removedpts=0)) then exit;}
  end; {thintimes}
end;


procedure cleanup3d;far;
begin
  clean_plist(pbeg,pend);
  closemode;
  exitproc := oldexit;
end;

procedure newpal;
begin
  if pl <> '' then begin
    loadcolors(pl,pal,256);
    fsetcolors(pal);  { palette }
  end;
end;

procedure setup3d;
begin
  oldexit := exitproc; exitproc := @cleanup3d;
end;

procedure twodimto3d(lx1,lx2,ly1,ly2,page: integer);
var x,y,pcolor,
    extrude,
    xx,yy,zz                           : integer;
    p                                  : plist;
begin

   setpageactive(2);
   { grey scale image to derive depth }
   loadpcx(bf);   { load pcx file on page }

   { color image to derive color }
   setpageactive(3);
   loadpcx(cf);

   newpal;

   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
       if (x mod spacing =0) and (y mod spacing=0) then begin    { take every eigth point }
         extrude:=point(x,y,2);
         pcolor:=point(x,y,3);
         if pcolor > 5 then begin
           new(p);
           p^.item := new(ppoint,init(x-(lx2 div 2),-(extrude div 8),y-(ly2 div 2),extrude));
           p^.item^.powner := p;
           addp(p2beg,p2end,p);
         end;
       end;
      end;
   end;
   setpageactive(3);
   cls(0);
end;


procedure setlevel;
begin
end;

procedure drawlist;
var
  nx,ny,nz,
  ox,oy,oz : integer;
  p        : plist;
  dumx,dumy  :integer;

begin
  p := p2beg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        nx := x; ny := y; nz := z;
        rotate256xyz(nx,ny,nz,0,0,r);
        if p<>p2beg
          then
            begin
            { draw converted point }
              setpoints((nx),(ny),(nz+m),dumx,dumy);
              if (recx1-sw<dumx) and (dumx<recx2+sw)
                and (recy1-sw<dumy) and (dumy<recy2+sw)
                then bar(abs(dumx-spacing),abs(dumy-spacing),(dumx+spacing),
                                   (dumy+spacing),
                                   (color));
            end;
        ox := nx; oy := ny; oz := nz;
        p := p^.next;
      end;
end;


procedure getmouse3d;
begin

  getmouse(butn,mx,my);

  if (butn=0) and (mx<107)
    then r := (r+1)mod 256
    else
     if (butn=0) and (mx>214)
       then r := (r+255)mod 256;

  {left or right}
  if (mx<107) and (xv>-300)
    then begin
      dir:=4;
    end
    else
      if (mx>214) and (xv<300)
        then begin
          dir:=2;
        end

  {up or down}
  else if (my<65) and (yv>-300)
    then begin
      dir:=3;
    end
    else
      if (my>130) and (yv<300)
        then begin
        dir:=1;
      end
  else dir:=0;

  {in or out}
  if (butn=0) and (my<65) and (m>-200)
    then dec(m,5)
    else
      if (butn=0) and (my>130) and (m<135)
        then inc(m,5);

  { jump is amount to move sprites }
  if dir=1 then inc(yv,yjump)
     else if dir=2 then inc(xv,xjump)
     else if dir=3 then dec(yv,yjump)
     else if dir=4 then dec(xv,xjump);
end;


procedure drawall(draw:boolean);
begin
  CopyRect(recx1,recy1,recx2,recy2,pages[3]^,pages[2]^);
  setpageactive(2);
  drawlist;
end;


procedure Animate3d;
begin
  twodimto3d(1,240,1,200,2);
  zv := 300; m := 0; r := 0;
  repeat
    getmouse3d;
    drawall(true);
    CopyRect(recx1,recy1,recx2,recy2,pages[2]^,pages[1]^);
    getmouse(butn,mx,my);
  until butn=1;
end;



(**) { tpoint methods }

constructor tpoint.init(nx,ny,nz,c:integer);
begin
  {inherited init;}
  x := nx; y := ny; z := nz; color:=c;
end;

procedure threed;
begin
  setup3d;
  Animate3d;
end;




{** main **}
begin
  irun:=false;  { initialize to not }
  first:=true;  { do some stuff only once }
  setup;
  if irun then begin
     initgui;
     rungui;
  end;
     if (not quit) and (first) then drawpage;  { draw selected pcx file }
     if irun and (not quit) then begin
     first:=false;
       repeat
        { do an edge operator }
        if no=1 then noise(45,10,5,lx1,lx2,ly1,ly2);
        if ro=1 then roberts(lx1,lx2,ly1,ly2,ed);
        {if so=1 then sobel(lx1,lx2,ly1,ly2,ed);}
        if so3=1 then sobel3x3(lx1,lx2,ly1,ly2,ed);

        { display the # pixels per value }
        if au=1 then autothresh(lx1,lx2,ly1,ly2);
        if hi=1 then histogram(lx1,lx2,ly1,ly2,60,1);
        if me=1 then histogram(lx1,lx2,ly1,ly2,30,1);
        if lo=1 then histogram(lx1,lx2,ly1,ly2,1,1);
        if ex=1 then expand(255,lx1,lx2,ly1,ly2);         { expand if specified by user }
        if th=1 then thin(255,lx1,lx2,ly1,ly2);              { make sure edges are 1 pixel thick }
        if la=1 then laplacian(lx1,lx2,ly1,ly2);
        if td=1 then begin
          threed;
        end;
        if re=1 then
        begin
           if (ro=1) or (so=1) then begin
              { this will turn edges black so we can seperate regions }
              { pages two and one have been histogrammed }
              pcopy(1,2);   { move original to page 2 }
              pcopy(3,1);   { move the found edges to a safe place }              { seperate without modifying page 2 }
              if au=1 then autothresh(lx1,lx2,ly1,ly2);
              if hi=1 then histogram(lx1,lx2,ly1,ly2,60,0);
              if me=1 then histogram(lx1,lx2,ly1,ly2,30,0);
              if lo=1 then histogram(lx1,lx2,ly1,ly2,3,0);

              { if not black, its an edge. Make edges black }
              { 3 is label source, 1 is target page }
              removeunwant(lx1,lx2,ly1,ly2,0,2,1);
              pcopy(1,2); { copy edge seperated binary objects to page two }

           end;
           if tr=1 then begin  { break train set into regions }
              regionize(lx1,lx2,ly1,ly2,regnum,true);
              tr:=0;
           end
           else regionize(lx1,lx2,ly1,ly2,regnum,false);

           setpageactive(1);
           { show user objects selected }
           cls(0);
           drawitems;
           computeitems;
        end;

        repeat getmouse(butn,dum,dum) until butn=1;

        pcopy(1,2);
        initgui;
        zerooptions;
        rungui;
        pcopy(2,1);
       until quit;
     end;
     repeat until quit;
     fadeout(50,zdc);
     oldexitproc := exitproc;
     exitproc := @cleanup;           { clean up everything }
end.