/* REND386 video driver main module */
/* this module: 320x200, standard 256 color */


/* Copyright 1993 by Dave Stampe */

// see F3DKITD.H for routine descriptions

//*********** DEFINES FROM ASSEMBLY MODULES


extern void far load_color(int color);
extern void far xprintc(int c);
extern void far xrprintc(int c);

extern void far vsync();                /* pause till vert. retrace */

extern void far set_vmode(int mode);    /* set video mode */
extern void far set_vpage(int page);    /* set video page */

void far set_clip_rect(int l, int t, int r, int b);  /* only affects lines */

#define PUT 0		/* defines of VGA write modes */
#define AND 1           /* for use with setup_hdwe()  */
#define OR  2
#define XOR 3

extern void far setup_hdwe(int mode);  /* setup VGA for bunch of line */
				       /* or poly draws: once per set */

extern void far reset_hdwe();  /* reset VGA to BIOS state after drawing */

			 /* clear video page to solid color: 10 mS */
			 /* returns -1 if bad page #		 */
extern int far clr_page(int page, int color);

			/* copy one page to another for use as */
			/* background: 21 mS per call          */
			/* returns -1 if bad page #            */
extern int far copy_page(int source, int dest);

			/* fast VGA line draw: about 15600 24-pixel */
			/* vectors/sec (horizontal much faster)     */
extern void far vgaline(int x1, int y1, int x2, int y2, int color);

			/* does C-S clipping and draws line   */
extern void far clipline(int x1, int y1, int x2, int y2, int color);

void far set_gmode();              /* enters 320x200x16 mode, clears screen */
void far exit_gmode();             /* exits to text mode */

int far set_drawpage(int page);		/* set page for drawing on (0-7)   */

			 /* set displayed page: uses BIOS   */
			 /* call, so DON'T use in interrupt */
			 /* routines! If WAIT is 1, will    */
			 /* sync with vert. retrace (pause) */
int far set_vidpage(int page, int wait);

void far rest_8x8(int buffer, int address);
int  far save_8x8(int x, int y, int buffer);

			/* print text in foreground only-- */
			/* reversed = 1 for right-to-left  */
			/* with x now right side of text   */
void far printxyr(int x, int y, int color, char far *pstring, int reversed);

			/* draw "+" cursor on screen      */
			/* save s screen under cursor 	  */
void far draw_cursor(int x, int y, int color, int savebuff);

				 /* restores 8x8 area saved when   */
void far erase_cursor(int savebuff); /* cursor was drawn               */

			/* copy any byte-aligned rectangle  */
			/* this is evey 4 pixels for Y mode */
			/* but every 8 for 16-color mode    */
			/* x coords (left) are truncated to */
			/* left byte boundary: x size is    */
			/* bumped up to next full byte count */
extern int far copy_block(int spage, int sx, int sy,  /* source */
		      int dpage, int dx, int dy,  /* dest   */
		      int xs, int ys);            /* # lines, pixels */

			/* clear any byte-aligned block       */
			/* 15-30% slower than full page clear */
			/* left edge rounded down, right edge */
			/* rounded up to nearest byte boundary */
extern int far clear_block(int left, int top, int right, int bottom,
		       int page, int color);

unsigned int dpaddr = 0;        /* video write base */

unsigned long l_hold, r_hold;   /* used to hold old x data for edge */

int x1clipl, x2clipl, y1clipl, y2clipl;

int xcpline = 0;                  /* line 0 to 199     */
int xcpcol = 0;                   /* column 0 to 39 (char width) */

int l_clip = 0;     	  /* clipping rectangle for polys and lines */
int r_clip = 319;         /* max. 0,319,0,199			  */
int t_clip = 0;
int b_clip = 199;

struct Screeninfo {
	int xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
	long aspect;
	char id[80];
	};

struct Screeninfo scrdat = {
	0, 0, 319, 200, 160, 100, 256, 4, 0,
	65536L/1.25,
	"REND386 320x200 Y-mode Driver, by Dave Stampe"
						 };

struct Screeninfo far * far screen_data();


/************* GRAPHICS MODE CONTROL SUPPORT **************/

struct Screeninfo far * far screen_data()
{
 return (struct Screeninfo far *)&scrdat;
}

void far set_gmode()		/* enters 320x200x256 mode, clears screen */
{                               /* may take arg in ext. VGA modes */
 set_vmode(0x14);
}

void far exit_gmode()		/* exits to text mode */
{
 set_vmode(0x03);
}


extern int far set_drawpage(int page);      /* set page for drawing */


int far set_vidpage(int page, int wait)  /* set visible page, wait for vsync */
{
 if(page>3) return(-1);
 set_vpage(page);
 if(wait) vsync();
}



/******************* LINE DRAWING SUPPORT ***************/

void far set_clip_rect(int l, int t, int r, int b)
{
 l_clip = l;
 r_clip = r;
 t_clip = t;
 b_clip = b;
}


void far clipline(int x1, int y1, int x2, int y2, int color)
{
 x1clipl = x1;
 x2clipl = x2;
 y1clipl = y1;
 y2clipl = y2;

 if (clipper()==-1) return;
 vgaline(x1, y1, x2, y2, color);
 return;
}


/********************* g-MODE TEXT PRINT SUPPORT ***************/

void fxprints(char far *pstring)
{
 int i,c;

 c = 1;
 i = 0;

 while(c != 0)
  {
   c = pstring[i];
   i++;
   switch (c)
    {
     case 0: break;

     case '\n' :
      {
       if(xcpline<192) xcpline++;
	xcpcol = 0;
       if(xcpline>192) xcpline = 192;
      }

     case '\r':
      {
       xcpcol = 0;
       break;
      }

     case '\t':
      {
       if((xcpcol&56)==0)
	{
	 fxprints("        ");
	}
       while((xcpcol&56)!=0)
	{
	 fxprints(" ");
	}
       break;
      }

     default:
      {
       xprintc(c);
       xcpcol+=8;
       if(xcpcol>312) fxprints("\n");
       break;
      }
    }
   if(xcpcol>312) fxprints("\n");
  }
}

/***************** MIRROR TEXT PRINT SUPPORT ***************/

void rxprints(char far *pstring)
{
 int i,c;

 c = 1;
 i = 0;

 while(c != 0)
  {
   c = pstring[i];
   i++;
   switch (c)
    {
     case 0: break;

     case '\n' :
      {
       if(xcpline<192) xcpline++;
	xcpcol = 319;
       if(xcpline>192) xcpline = 192;
      }

     case '\r':
      {
       xcpcol = 319;
       break;
      }

     case '\t':
      {
       if((xcpcol&56)==0)
	{
	 rxprints("        ");
	}
       while((xcpcol&56)!=0)
	{
	 rxprints(" ");
	}
       break;
      }

     default:
      {
       xrprintc(c);
       xcpcol-=8;
       if(xcpcol<7) rxprints("\n");
       break;
      }
    }
   if(xcpcol<7) rxprints("\n");
  }
}



void far printxyr(int x, int y, int color, char far *pstring, int reversed)
{
 setup_hdwe(0);
 xcpline = y;
 xcpcol = x;
 load_color(color);
 if(reversed) rxprints(pstring); else fxprints(pstring);
 reset_hdwe();
}


/*************** CURSOR STUFF ************/

int savadr[8];

void far draw_cursor(int x, int y, int color, int savebuff)
{
 int xx = x-3;
 int yy = y-3;

 if(xx<0)xx = 0;
 if(yy<0)yy = 0;

 setup_hdwe(0);
 savadr[savebuff] = save_8x8(xx,yy,savebuff);
 if(color<0)
  {
   vgaline(xx,yy,x+3,y+3,-color);
   vgaline(xx,y+3,x+3,yy,-color);
   color = 0;
  }
 vgaline(xx,y,x+3,y,color);
 vgaline(x,yy,x,y+3,color);
 reset_hdwe(0);
}


void far erase_cursor(int savebuff)
{
 setup_hdwe(0);
 rest_8x8(savebuff, savadr[savebuff]);
 reset_hdwe();
}


char default_palette[768] =
												{
0, 0, 0, 0, 0, 42, 0, 42, 0, 0, 42, 42,
42, 0, 0, 42, 0, 42, 42, 21, 0, 42, 42, 42,
21, 21, 21, 21, 21, 63, 21, 63, 21, 21, 63, 63,
63, 21, 21, 63, 21, 63, 63, 63, 21, 63, 63, 63,
5, 0, 0, 8, 0, 0, 10, 0, 0, 12, 0, 0,
15, 0, 0, 17, 0, 0, 20, 0, 0, 23, 0, 0,
26, 0, 0, 30, 0, 0, 34, 0, 0, 38, 0, 0,
43, 0, 0, 49, 0, 0, 56, 0, 0, 63, 0, 0,
5, 2, 0, 8, 4, 0, 10, 4, 0, 12, 6, 0,
15, 7, 0, 17, 8, 0, 20, 10, 0, 23, 11, 0,
26, 13, 0, 30, 14, 0, 34, 16, 0, 38, 18, 0,
43, 21, 0, 49, 24, 0, 56, 27, 0, 63, 31, 0,
5, 2, 2, 8, 4, 4, 10, 4, 4, 12, 6, 6,
15, 7, 7, 17, 8, 8, 20, 10, 10, 23, 11, 11,
26, 13, 13, 30, 14, 14, 34, 16, 16, 38, 18, 18,
43, 21, 21, 49, 24, 24, 56, 27, 27, 63, 31, 31,
5, 3, 2, 8, 6, 4, 10, 7, 4, 12, 9, 6,
15, 11, 7, 17, 13, 8, 20, 15, 10, 23, 17, 11,
26, 19, 13, 30, 22, 14, 34, 25, 16, 38, 28, 18,
43, 32, 21, 49, 37, 24, 56, 41, 27, 63, 47, 31,
5, 5, 2, 8, 8, 4, 10, 10, 4, 12, 12, 6,
15, 15, 7, 17, 17, 8, 20, 20, 10, 23, 23, 11,
26, 26, 13, 30, 30, 14, 34, 34, 16, 38, 38, 18,
43, 43, 21, 49, 49, 24, 56, 56, 27, 63, 63, 31,
5, 5, 0, 8, 8, 0, 10, 10, 0, 12, 12, 0,
15, 15, 0, 17, 17, 0, 20, 20, 0, 23, 23, 0,
26, 26, 0, 30, 30, 0, 34, 34, 0, 38, 38, 0,
43, 43, 0, 49, 49, 0, 56, 56, 0, 63, 63, 0,
0, 5, 2, 0, 8, 4, 0, 10, 4, 0, 12, 6,
0, 15, 7, 0, 17, 8, 0, 20, 10, 0, 23, 11,
0, 26, 13, 0, 30, 14, 0, 34, 16, 0, 38, 18,
0, 43, 21, 0, 49, 24, 0, 56, 27, 0, 63, 31,
0, 5, 0, 0, 8, 0, 0, 10, 0, 0, 12, 0,
0, 15, 0, 0, 17, 0, 0, 20, 0, 0, 23, 0,
0, 26, 0, 0, 30, 0, 0, 34, 0, 0, 38, 0,
0, 43, 0, 0, 49, 0, 0, 56, 0, 0, 63, 0, 
0, 5, 3, 0, 8, 6, 0, 10, 7, 0, 12, 9, 
0, 15, 11, 0, 17, 13, 0, 20, 15, 0, 23, 17, 
0, 26, 19, 0, 30, 22, 0, 34, 25, 0, 38, 28, 
0, 43, 32, 0, 49, 37, 0, 56, 41, 0, 63, 47,
0, 3, 5, 0, 6, 8, 0, 7, 10, 0, 9, 12, 
0, 11, 15, 0, 13, 17, 0, 15, 20, 0, 17, 23, 
0, 19, 26, 0, 22, 30, 0, 25, 34, 0, 28, 38, 
0, 32, 43, 0, 37, 49, 0, 41, 56, 0, 47, 63, 
0, 0, 5, 0, 0, 8, 0, 0, 10, 0, 0, 12, 
0, 0, 15, 0, 0, 17, 0, 0, 20, 0, 0, 23,
0, 0, 26, 0, 0, 30, 0, 0, 34, 0, 0, 38, 
0, 0, 43, 0, 0, 49, 0, 0, 56, 0, 0, 63, 
5, 0, 5, 8, 0, 8, 10, 0, 10, 12, 0, 12, 
15, 0, 15, 17, 0, 17, 20, 0, 20, 23, 0, 23, 
26, 0, 26, 30, 0, 30, 34, 0, 34, 38, 0, 38,
43, 0, 43, 49, 0, 49, 56, 0, 56, 63, 0, 63, 
5, 0, 3, 8, 0, 6, 10, 0, 7, 12, 0, 9, 
15, 0, 11, 17, 0, 13, 20, 0, 15, 23, 0, 17,
26, 0, 19, 30, 0, 22, 34, 0, 25, 38, 0, 28,
43, 0, 32, 49, 0, 37, 56, 0, 41, 63, 0, 47, 
2, 2, 2, 4, 4, 4, 5, 5, 5, 6, 6, 6, 
7, 7, 7, 8, 8, 8, 10, 10, 10, 11, 11, 11,
13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 
22, 22, 22, 25, 25, 25, 28, 28, 28, 32, 32, 32, 
5, 5, 5, 8, 8, 8, 10, 10, 10, 12, 12, 12,
15, 15, 15, 17, 17, 17, 20, 20, 20, 23, 23, 23, 
26, 26, 26, 30, 30, 30, 34, 34, 34, 38, 38, 38,
43, 43, 43, 49, 49, 49, 56, 56, 56, 63, 63, 63
								 };


void far load_DAC(char far *pal, int n, int first);
void far load_DAC_colors( char far *pal, int n, int bw, int first)
{
 int i;

 if(pal==0)
  {
   pal = &default_palette[0];
   first = 0;
   n = 256;
  }
 if(bw)
  {
   for(i=0;i<n;i++)
   pal[i+i+i] = pal[i+i+i+1] = pal[i+i+i+2] =
	   ((pal[i+i+i]*3)+(pal[i+i+i+1]*8)+(pal[i+i+i+2]*5))/16;
  }
 load_DAC(pal, n, first);
}


void far read_DAC(char far *pal, int n, int first);
void far read_DAC_colors( char far *pal, int n, int first)
{
 int i;

 if(n>scrdat.colors) n = scrdat.colors;
 read_DAC(pal, n, first);
}


VGA_select() {}  // STUB


extern void far get_line(char far *buff, int line, int count);

unsigned far read_video_line(char far *buff, int line)
{
  reset_hdwe();
  if(buff!=0)
	get_line(buff, line, scrdat.xmax-scrdat.xmin+1);
  reset_hdwe();
  return scrdat.xmax-scrdat.xmin+1;
}


extern void far put_line(char far *buff, int line, int count);

unsigned far write_video_line(char far *buff, int line)
{
  reset_hdwe();
  if(buff!=0)
	put_line(buff, line, scrdat.xmax-scrdat.xmin+1);
  reset_hdwe();
  return scrdat.xmax-scrdat.xmin+1;
}

