	TITLE   GSPPT256 - video support for all xmode drivers


	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc	; sets memory model

		.CODE vdriver
		.386


include videfs.inc      ; defines constants, tables


 ;
 ; void set_video_segment(unsigned seg); // sets video segment
 ;

	PUBLIC _set_video_segment

_set_video_segment proc far

	push	bp
	mov	bp,sp

	mov	ax,[bp+6]
	mov 	videoseg,ax

	pop     bp
	ret

_set_video_segment  endp




 ;
 ; unsigned read_video_line(char *buff, unsigned line);
 ;
 ; if buff is NULL, returns number of bytes required
 ; else, it will fill the buffer with the line contents
 ; this is the assembler part-- rest is C
 ;
 ; void get_line(char far *buff, unsigned line, unsigned pixels);

	PUBLIC _get_line

buff	equ	DWORD PTR [bp+6]
line	equ	WORD PTR [bp+10]
pixels	equ	WORD PTR [bp+12]

_get_line proc far

	push	bp
	mov	bp,sp

	push	cx
	push	dx
	push	si
	push	di
	push	ds

	mov 	ax,videoseg     ; set up pointers:
	mov	es,ax		; es:si for video, ds:di for buffer
	lds	di,buff
	mov	ax,line
	imul	ax,bypitch
	add	ax,_dpaddr	; page to use
	mov	si,ax

	mov	cx,pixels	; number of pixels to read

	mov	dx,03ceh	; graphics controller
loopnr:
	mov	ax,0304h	; plane to read bit from
looppr:
	xor	ah,3
	out	dx,ax		; set to read correct plane
	xor	ah,3
	mov	bh,es:[si]	; get byte
	mov	ds:[di],bh      ; write pixel to buffer
	inc	di
	dec	cx
	je	doneread        ; next pixel
	dec	ah
	jge	looppr
	inc	si
	jmp	loopnr

doneread:
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx

	pop     bp
	ret

_get_line  endp



 ;
 ; unsigned write_video_line(char *buff, unsigned line);
 ;
 ; if buff is NULL, returns number of bytes required
 ; else, it will fill the buffer with the line contents
 ; this is the assembler part-- rest is C
 ;
 ; void put_line(char far *buff, unsigned line, unsigned pixels);

	PUBLIC _put_line

buff	equ	DWORD PTR [bp+6]
line	equ	WORD PTR [bp+10]
pixels	equ	WORD PTR [bp+12]

_put_line proc far

	push	bp
	mov	bp,sp

	push	cx
	push	dx
	push	si
	push	di
	push	ds

	mov 	ax,videoseg     ; set up pointers:
	mov	es,ax		; es:si for video, ds:di for buffer
	lds	di,buff
	mov	ax,line
	imul	ax,bypitch
	add	ax,_dpaddr	; page to use
	mov	si,ax

	mov	cx,pixels	; number of pixels to read

	mov	dx,03c4h	; graphics controller
loopnw:
	mov	ax,0102h	; plane to write pixel to
looppw:
	out	dx,ax		; set to read correct plane
	mov	bh,ds:[di]	; get byte
	mov	es:[si],bh      ; write pixel to buffer
	inc	di
	dec	cx
	je	donewrte        ; next pixel
	shl	ah,1
	and	ah,15
	jne	looppw
	inc	si
	jmp	loopnw

donewrte:
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx

	pop     bp
	ret

_put_line  endp




 ;
 ; void vsync();                /* waits for vert. sync pulse */
 ;
		PUBLIC  _vsync

_vsync  proc    far

	push    bp
	push    dx
	pushf
	mov     bp,sp
	mov     dx,03DAh
	cli
	in      al,dx           ; test if 0
	test    al,8
	je      short @11@218
@11@122:
	popf
	pushf
	cli
	in      al,dx
	nop
	test    al,8            ; wait for 0
	jne     short @11@122
@11@218:
	popf
	pushf
	cli
	in      al,dx
	nop
	test    al,8            ; wait for 1
	je      short @11@218
	popf
	pop     dx
	pop     bp
	ret

_vsync  endp

 ;
 ; void setup_hdwe(int mode);   /* sets up VGA for line, poly draw */
 ;                              /* modes are: 0=PUT, 1=OR,         */
 ;                              /*            2=AND, 3=XOR         */
 ;                              /* only PUT for X-mode             */

		PUBLIC  _setup_hdwe

_setup_hdwe     proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,00008h               ; all display copy bits
	out     dx,ax

	mov     dx,03c4h                ; prepare plane mask reg. for access
	mov     ax,0f02h
	out     dx,ax
	pop     dx
	pop     bp
	ret

_setup_hdwe     endp

 ;
 ; void reset_hdwe()
 ;

		PUBLIC  _reset_hdwe

_reset_hdwe     proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,0FF08h               ; all CPU data bits
	out     dx,ax

	mov     dx,03c4h                ; prepare plane mask reg. for access
	mov     ax,0f02h
	out     dx,al
	pop     dx
	pop     bp
	ret

_reset_hdwe     endp

 ;
 ; int clr_page(int page, int color);   /* clear page to color */
 ;
 ;  /* returns 0 if OK, 1 if bad page */

		PUBLIC  _clr_page

_clr_page       proc    far

	push    bp
	mov     bp,sp
	sub     sp,10
	push    di
	push    cx
	push    dx
	cld
	mov     cx,word ptr [bp+6]
	cmp     cx,npages                      ; check for valid page
	jl      gdpage
	mov     ax,-1
	jmp     abbort
gdpage:
	call    far ptr _setup_hdwe     ; reset to default VGA mode
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     bx,colortable
	add     bx,WORD PTR [bp+8]
	mov     al,es:[bx]              ; read entry into latches

	mov     bx,word ptr [bp+6]
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgwords

	rep     stosw

	call    far ptr _reset_hdwe
	xor     ax,ax
abbort:
	pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret

_clr_page       endp

   ;
   ;    int copy_page(int source, int dest)
   ;
   ;    /* returns 0 if OK, 1 if bad page */

		PUBLIC  _copy_page

_copy_page      proc    far

	push    bp
	mov     bp,sp
	sub     sp,4
	push    si
	push    di
	push    cx
	push    dx
	mov     ax,word ptr [bp+6]
	cmp     ax,npages
	jge     short @15@74            ; check for valid page #'s
	mov     ax,word ptr [bp+8]
	cmp     ax,npages
	jl      short @15@98
@15@74:
	mov     ax,-1
	jmp     short @15@506
@15@98:
	call    far ptr _setup_hdwe       ; write VGA state
	push    ds
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax
	mov     bx,word ptr [bp+6]      ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,word ptr [bp+8]      ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgbytes

	rep     movsb

	call    far ptr _reset_hdwe
	pop     ds
	xor     ax,ax
@15@506:
	pop     dx
	pop     cx
	pop     di
	pop     si
	mov     sp,bp
	pop     bp
	ret

_copy_page      endp


 ;
 ; void vga_reg(int reg)        /* integer: lsby=reg(0=color), msby=value */
 ;

		PUBLIC  _vga_reg

_vga_reg        proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,WORD PTR [bp+6]
	out     dx,ax
	pop     dx
	pop     bp
	ret

_vga_reg        endp



 ;
 ; void load_color(int color)    /* integer: loads latches with color */
 ;

		PUBLIC  _load_color

_load_color     proc    far

	push    bp
	mov     bp,sp
	mov     ax,videoseg
	mov     es,ax
	mov     bx,colortable
	mov     bl,BYTE PTR [bp+6]      ; figure what entry to read
	mov     al,es:[bx]      ; read entry into latches
	pop     bp
	ret

_load_color     endp


				; bit reversal (plane mask) lookup table

 ;
 ; int save_8x8(int h, int y, int buffer, int address); /* save 8x8 at x,y */
 ;                                                      /* returns address */
		PUBLIC  _save_8x8

xcoord equ [bp+6]
ycoord equ [bp+8]
buffer equ [bp+10]

_save_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx
	push    dx

	mov     ax,ycoord
	imul    ax,bypitch
	mov     si,xcoord
	shr     si,2
	add     si,ax
	add     si,WORD PTR _dpaddr
	push    si        ; will be returned

	mov     bx,buffer
	add     bx,bx
	mov     di,cursoff[bx]
	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxsl:   mov     al,es:[si]      ; move 12 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	mov     al,es:[si+2]
	mov     BYTE PTR es:[di+2],0
	add     si,bypitch
	add     di,3
	loop    nxsl

	pop     ax      ; returns address
	pop     dx
	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_save_8x8       endp

 ;
 ; void rest_8x8(int buffer, int address);      /* restore 8x8 at x,y */
 ;
		PUBLIC  _rest_8x8

buffer  equ [bp+6]
address equ [bp+8]

_rest_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx
	push    dx

	mov     bx,buffer
	add     bx,bx
	mov     si,cursoff[bx]

	mov     di,address

	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxrl:   mov     al,es:[si]      ; move 12 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	mov     al,es:[si+2]
	mov     BYTE PTR es:[di+2],0
	add     si,3
	add     di,bypitch
	loop    nxrl

	pop     dx
	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_rest_8x8       endp


 ;
 ; int clr_block(int l, int t, int r, int b, int page, int color);
 ;  /* 8-pixel granularity  (next biggest) */
 ;  /* returns 0 if OK, 1 if bad page      */

cbl     equ WORD PTR [bp+6]
cbt     equ WORD PTR [bp+8]
cbr     equ WORD PTR [bp+10]
cbb     equ WORD PTR [bp+12]
cbpage  equ WORD PTR [bp+14]
cbcolor equ WORD PTR [bp+16]

bbyte   equ     [bp-2]          ; video base addr. of line
abyte   equ     [bp-4]          ; number of lines to fill
l_incr  equ     [bp-6]

		PUBLIC  _clr_block

_clr_block      proc    far

	push    bp
	mov     bp,sp
	sub     sp,10
	push    di
	push    cx
	push    dx

	cld
	call    far ptr _setup_hdwe     ; reset to default VGA mode
	mov     ax,videoseg
	mov     es,ax
	mov     bx,cbcolor
	add     bh,0ffh                 ; figure what entry to read
	mov     al,es:[bx]              ; read entry into latches

	mov     bx,cbpage
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,cbb
	sub     bx,cbt                  ; bx = line count
	jb      badcb

	mov     ax,cbt
	imul    ax,bypitch
	add     di,ax
	mov     ax,cbl
	shr     ax,3
	shl     ax,1
	add     di,ax                   ; start address

	mov     cx,cbl
	and     cx,0FFFCh
	sub     cx,cbr
	neg     cx
	js      badcb
	shr     cx,3
	inc     cx
	mov     ax,cx                   ; count per line
	shl     cx,1
	sub     cx,bypitch
	jg      badcb
	neg     cx
	mov     dx,cx                   ; fixup factor

cbloop: mov     cx,ax
	rep     stosw
	add     di,dx
	dec     bx
	jge     cbloop

	call    far ptr _reset_hdwe
	xor     ax,ax
	jmp     cbexit

badcb:  mov     ax,-1

cbexit: pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret


_clr_block      endp

   ;
   ;    int copy_block(int spage, int sx, int sy,
   ;                   int dpage, int dx, int dy,
   ;                   int xsize, int vsize )
   ;
   ;    /* returns 0 if OK, 1 if bad page */

copsp    equ WORD PTR [bp+6]
copsx    equ WORD PTR [bp+8]
copsy    equ WORD PTR [bp+10]
copdp    equ WORD PTR [bp+12]
copdx    equ WORD PTR [bp+14]
copdy    equ WORD PTR [bp+16]
copxs    equ WORD PTR [bp+18]
copys    equ WORD PTR [bp+20]

		PUBLIC  _copy_block

_copy_block     proc    far

	push    bp
	mov     bp,sp
	sub     sp,4
	push    si
	push    di
	push    cx
	push    dx

	call    far ptr _setup_hdwe       ; write VGA state
	push    ds
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax

	mov     bx,copsp                ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,copdp                ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,copys                ; bx = line count

	mov     ax,copsy
	imul    ax,bypitch
	add     si,ax
	mov     ax,copsx
	shr     ax,1
	shr     ax,1
	add     si,ax                   ; start address

	mov     ax,copdy
	imul    ax,bypitch
	add     di,ax
	mov     ax,copdx
	shr     ax,1
	shr     ax,1
	add     di,ax                   ; start address

	mov     cx,copxs
	add     cx,3
	shr     cx,1
	shr     cx,1
	inc     cx
	mov     ax,cx                   ; count per line
	sub     cx,bypitch
	neg     cx
	mov     dx,cx                   ; fixup factor

coplop: mov     cx,ax
	rep     movsb
	add     si,dx
	add     di,dx
	dec     bx
	jg      coplop

	call    far ptr _reset_hdwe
	pop     ds
	xor     ax,ax

	pop     dx
	pop     cx
	pop     di
	pop     si
	mov     sp,bp
	pop     bp
	ret

_copy_block     endp


 ;
 ; void load_DAC(char far *data, int count);
 ;                      /* loads DAC             */


 start   equ [bp+12]
 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _load_DAC

_load_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx

	les     bx,DWORD PTR dacdata
	mov     ax,start
	mov     dx,03C8h
	out     dx,al
	mov     cx,WORD PTR count
	mov     dx,03C9h

mvp:    mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	loop    mvp

	pop     cx
	pop     dx
	pop     bp
	ret

_load_DAC       endp

 ;
 ; void read_DAC(char far *data, int count);
 ;                      /* reads DAC             */


 start   equ [bp+12]
 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _read_DAC

_read_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx

	les     bx,DWORD PTR dacdata
	mov     ax,start
	mov     dx,03C7h
	out     dx,al
	mov     cx,WORD PTR count
	mov     dx,03C9h

mvpr:
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	loop    mvpr

	pop     cx
	pop     dx
	pop     bp
	ret

_read_DAC       endp


		end

