//
// Povray test file to display a FracTree generated tree.
// Tree file to display : TreeLeaf.Inc, a more simple tree, with the DMFWood4
//                        texture for the branches. It also has a 'user
//                        defined leaf', a large sphere with a smiley texture
//                        ;)
// G.Bissell 1995
//


#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


camera {
  location  <0, 2/2.5, -3/2.5>
  direction <0, 0, 1>
  up        <0, 1, 0>
  right     <4/3, 0, 0>
  look_at   <0, 0.5, 0>
}


light_source {<-4.0, 4.0, -4.0> color White }


// Define a large sphere with a 'smiley' picture wrap for the leaf
#declare MyLeaf =
object {
  sphere { < 0, 0, 0 >, 10 }
  pigment {
    image_map {
      gif "smiley.gif"
      map_type 1
    }
  }
  rotate < 0, -90, 0 >
  rotate < 10, 0, 0 >
}


// Include FracTree tree file
#include "treeleaf.inc"

// Place tree in scene
object {Tree1}

// Add a checkered floor
plane {
  <0, 1, 0>, 0
  pigment {
    checker
      color White
      color SkyBlue
    scale 0.5
  }
}
