// gdc.h
// Global 3D Controller Defines and Function Prototypes
// Created by: Jerry Isdale, i.e. Isdale Engineering
  
#ifndef GLOBAL_DEVICES_CONTROLLER
#define GLOBAL_DEVICES_CONTROLLER
  
// Modes
#define GDC_MODE_POLLED 0x35
#define GDC_MODE_BYTE3  0x3A
#define GDC_MODE_BYTE1  0x3E
  
// Global 3D Controller linear codes
#define GDC_MOVE_DN 0x20
#define GDC_MOVE_UP 0x10
#define GDC_MOVE_LF 0x08
#define GDC_MOVE_RT 0x04
#define GDC_MOVE_BK 0x02
#define GDC_MOVE_FW 0x01
  
// Global 3D Controller rotation codes
#define GDC_ROLL_CC 0x20
#define GDC_ROLL_CW 0x10
#define GDC_PITCH_D 0x08
#define GDC_PITCH_U 0x04
#define GDC_YAW_LEF 0x02
#define GDC_YAW_RIT 0x01
  
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
  
//--------------------------------------
unsigned char gdc_init( int port );
// set_mode works only on later devices
unsigned char gdc_set_mode ( unsigned char mode );
void gdc_read (unsigned *linear, unsigned *rotation, unsigned *button);
void gdc_tactile ( unsigned char intensity, int length );
void gdc_tactile_pulse ( unsigned char time );
void gdc_remove(void);
  
// for REND386 Only
void gdc_UpdatePos(void);
//--------------------------------------
extern int use_gdc; // global devices controller ball used in REND386
             // set value to id of com port to be used
//--------------------------------------
#endif // GLOBAL_DEVICES_CONTROLLER
  
