/**********************************************************************
     VARMINT's POV ANIMATOR

     Written by:  Eric Jorgensen (1994)

     This is the main program file for Varmint's POV animator.  
     This was gennerated ad compiled with Turbo C++.
     
     Enjoy.

***********************************************************************/


#include <time.h>
#include "animate.h"
#include "parse.h"
                              /* globals */
int frame = 0,frames_per_sec = 30;
int start_frame = 0,end_frame = 30,frame;
double start_time = -222;
double secs_per_frame;
double current_time = 0.0;
char scene_file[16] = {""};
char config_file[16] = {"animate.cfg"};
char arguments[127] = {""};
char povpath[127] = {""};
char defpath[127] = {""};
char picseed[8] = {"pic"};
char picdir[127] = {""};
char parseid[32] = {"//*"};
int debug = FALSE;
int keypause = 0;


void main(int argc, char *argv[])
{
  FILE *inscene,*outscene;
  char string[256],*parseme,tagstring[8],targ[256];
  TOKEN tok;
  int parseerror,line_number = 1,f,error;
  long int elapsed;
  int hours,minutes,seconds;

  tok.data = (char *)malloc(256);

  clrscr();

  if(argc < 2) syntax();                    // Must have a POV scene file
  strcpy(scene_file,argv[1]);               // 1st arg = name of scene file

  if(*argv[1] == '-') syntax();             // POV scene file suppposed to be first

  if(argc > 2 && *argv[2] != '-') {         // config file specified?
    strcpy(config_file,argv[2]);
  }

  readconfigs(config_file);                 // Read config file stuff

  parsecommandline(argc,argv);              // Process rest of the command line

                                            // Prepare for animation loop

  secs_per_frame = 1.0/frames_per_sec;
  if(start_time == -222) start_time = start_frame*secs_per_frame;
  current_time = start_time;

  elapsed = time(NULL);
  for(frame = start_frame; frame <= end_frame; frame++) {
    textcolor(GREEN);
    cprintf("\r\n======= FRAME %d [Core left: %u] =======\r\n\n",frame,coreleft());

                                           // create anim.pov
    inscene = fopen(scene_file,"r");       // open input file
    if(!inscene) {
      textcolor(RED);
      cprintf("ERROR:  Cannot open \"%s\"\r\n",scene_file);
      exit(1);
    }
    outscene = fopen("anim.pov","w");      // open output file
    if(!outscene) {
      textcolor(RED);
      cprintf("ERROR:  Cannot write to \"anim.pov\"\r\n");
      exit(1);
    }


    line_number = 1;
    while(fgets(string,255,inscene)) {     // Create parsed scene file
      parseme = checkstring(string);       // check for parseable string
      if(parseme) {
        *(parseme-strlen(parseid)) = 0;    // terminate old part of token
        fprintf(outscene,"%s",string);     //  print what we've got so far
        parseerror = povparse(parseme,&tok);// parse it
        if(parseerror) {                   // any problems?
          textcolor(LIGHTRED);
          cprintf("PARSE ERROR in line #%d: %s\r\n",
            line_number,parseerr[parseerror]);
          exit(1);
        }
        fprintf(outscene,"%s\n",tok.data);  // insert parsed line

        if(debug) {                         // debugging ON?
          textcolor(LIGHTBLUE);
          cprintf("%d] %s\r\n",line_number,tok.data);
        }
      }
      else fprintf(outscene,"%s",string);

      line_number++;
    }
    fcloseall();

                                            // create arguments

    f = frame;                              // output picture file name
    tagstring[0] = (int)(f/1000)+'0';       // create frame number tag
    f -= ((int)(f/1000))*1000;
    tagstring[1] = (int)(f/100)+'0';
    f -= ((int)(f/100))*100;
    tagstring[2] = (int)(f/10)+'0';
    f -= ((int)(f/10))*10;
    tagstring[3] = (int)(f/1)+'0';
    tagstring[4] = 0;
    sprintf(targ,"-o%s\\%s%s.tga",picdir,picseed,tagstring); // create filename from tag and seed


                                            // render
    if(!debug) {                            // render only when not debugging
      error = spawnl(P_WAIT,povpath,povpath,defpath,"-ianim.pov",targ,arguments,NULL);
      _fpreset();
      //error = spawnl(P_WAIT,povpath,povpath,defpath,"-ianim.pov",targ,arguments);
      //printf("%s %s %s %s\n",povpath,defpath,"-ianim.pov",targ);
    }

                                            // make incremements
    current_time += secs_per_frame;
    if(keypause) {
      textcolor(LIGHTMAGENTA);
      cprintf("Press any key to continue\r\n");
      getch();
    }

  }

                                            // Wrap it up

  elapsed = time(NULL) - elapsed;

  hours = elapsed/3600;
  elapsed -= hours*3600;
  minutes = elapsed/60;
  elapsed -= minutes*60;
  seconds = elapsed;

  textcolor(YELLOW);
  cprintf("Time elapsed: %d hours, %d minutes, %d seconds\r\n",
           hours,minutes,seconds);
  elapsed = hours*3600 + minutes*60+ seconds;

  elapsed /= (end_frame - start_frame);
  hours = elapsed/3600;
  elapsed -= hours*3600;
  minutes = elapsed/60;
  elapsed -= minutes*60;
  seconds = elapsed;
  cprintf("Ave. time per frame: %d hours, %d minutes, %d seconds\r\n",
           hours,minutes,seconds);
}



/**************************************************************************
  char *checkstring(char *string)

  DESCTRIPTION:  CHecks the string to see if it is parseable, then returns
                 A pointer to the parseable section.

**************************************************************************/
char *checkstring(char string[])
{
  int i,j,match;

  for(i = 0; i < strlen(string); i++) {     // check whole string
    if(string[i] == parseid[0]) {           // candidate?
      match = 1;
      for(j = 0; j < strlen(parseid); j++){ // compare
        if(string[i+j] != parseid[j]) match = 0;
      }
      if(match) return(string + i + strlen(parseid));
    }
  }
  return(0);
}


/**************************************************************************
  void parsecommandline(int argc, char *argv[])

  DESCTRIPTION: Parses command line arguments.  These arguments take
                Pecedence over config file arguments.

  VALID ARGUMENTS:

    -POV  [text]      pathname of POV executable
    -DEF  [text]      pathname of .def file
    -SEED [text]       Seed name for output pics
    -PDIR [text]       Picture Output directory
    -PID  [text]      Id string for parsable lines
    -SF   [number]    Number of starting frame
    -EF   [Number]    Number of last frame to be rendered
    -FPS  [number]    Frames per second
    -ST   [number]    Time index (in seconds) of start frame
    -ARGS ["text"]    Arguments for the POV command line
    -H, -X            Help
    -DEBUG            Set debug mode ON

**************************************************************************/
void parsecommandline(int argc, char *argv[])
{
  int arg = 2,ignored = 0,i;
  char r;

  if(*(argv[arg]) != '-') arg++;          // Skip over connfig file argument

  while(arg < argc) {                     // loop through arguments
    for(i=0; i < strlen(argv[arg]); i++) { // Convert to upper case
      *(argv[arg]+i) = toupper(*(argv[arg]+i));
    }

    if(!strcmp(argv[arg],"-POV")) {        // pov pathname
      strcpy(povpath,argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-ARGS")) {  // pov arguments
      strcpy(arguments,argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-DEF")) {  // definition file pathname
      strcpy(defpath,argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-SEED")) { // picture name seed
      arg++;
      if(strlen(argv[arg]) > 4) {
        *(argv[arg]+4) = 0;               // Make sure it's truncated
      }
      strcpy(picseed,argv[arg]);
    }
    else if(!strcmp(argv[arg],"-PDIR")) { // output directory for pictures
      strcpy(picdir,argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-PID")) {  // String id for parseable lines
      strcpy(parseid,argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-SF"))  {    // Number of start frame
      start_frame = atoi(argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-EF")) {   // number of last frame
      end_frame = atoi(argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-FPS")) {  // Fames per second
      frames_per_sec = atoi(argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-ST")) {    // Time index (in secs) of first frame
      start_time = atof(argv[++arg]);
    }
    else if(!strcmp(argv[arg],"-H")) {    // Help
      syntax();
    }
    else if(!strcmp(argv[arg],"-X")) {    // Help
      syntax();
    }
    else if(!strcmp(argv[arg],"-DEBUG")) {// Set debug mode ON
      debug = TRUE;
    }
    else if(!strcmp(argv[arg],"-PAUSE")) {// Set debug mode ON
      keypause = TRUE;
    }
    else {
      textcolor(RED);
      cprintf("Don't know what to do with \"%s\" -  ignoring....\r\n",argv[arg]);
      ignored++;
    }
    arg++;
  }
  if(ignored) {
    textcolor(YELLOW+BROWN*16+80 + BLINK);
    cprintf("Some command line parameters have been ignored.\r\n");
    printf("Do you wish to continue?  (Y/N)\n");
    r = ' ';
    while(r != 'Y' && r != 'N') r = toupper(getch());
    if(r == 'N') syntax();
  }
}


/**************************************************************************
  void readconfigs(char *filename)

  DESCTRIPTION:  Reads in the configuration file

  VALID ARGS IN THE CONFIG FILE:

    /,!,#                  Comment line identifiers
    POV       [text]       pathname of POV executable
    POVARGS   [text]      Arguments for the POV command line
    DEF        [text]      pathname of .def file
    PICSEED   [text]       Seed name for output pics
    PICDIR     [text]       Picture Output directory
    PARSEID   [text]      Id string for parsable lines
    STARTFRAME [number]   Number of starting frame
    ENDFRAME  [Number]    Number of last frame to be rendered
    FPS        [number]    Frames per second
    STARTTIME [number]    Time index (in seconds) of start frame

**************************************************************************/
void readconfigs(char *filename)
{
  int flag = 1,error,i;
  FILE *input;
  char string[256],id[256],*arg;

  input = fopen(filename,"r");        // open cofig file and bail on error
  if(!input) {
    printf("ERROR:  Cannot find configuration file: %s\n\n",filename);
    exit(1);
  }

  while(flag) {                        // parse loop
    error = fscanf(input,"%s",id);    // Grab first word in line and convert
                                      // it to upper case;
    for(i = 0; i < strlen(id); i++) *(id+i) = toupper(*(id+i));

    if(error == EOF) {                // exit on EOF
      flag = 0;
      continue;
    }
    fgets(string,256,input);          // get the rest of the line
    arg = string;                     // Start argument line with real data
    while(*arg == ' ' || *arg == '\t') arg++;
    arg[strlen(arg)-1] = 0;           // strip newline ('\n') character

                                      // Process the line

    if(*id == '/' ||                  // Comment identifiers
       *id == '!' ||
       *id == '#') {
      continue;
    }
    else if(!strcmp(id,"POV")) {      // pov pathname
      strcpy(povpath,arg);
    }
    else if(!strcmp(id,"POVARGS")) {  // pov arguments
      strcpy(arguments,arg);
    }
    else if(!strcmp(id,"DEF")) {      // definition file pathname
      strcpy(defpath,arg);
    }
    else if(!strcmp(id,"PICSEED")) {  // picture name seed
      *(arg+4) = 0;                   // Make sure it's truncated
      strcpy(picseed,arg);
    }
    else if(!strcmp(id,"PICDIR")) {    // output directory for pictures
      strcpy(picdir,arg);
    }
    else if(!strcmp(id,"PARSEID")) {  // String id for parseable lines
      strcpy(parseid,arg);
    }
    else if(!strcmp(id,"STARTFRAME")) {// Number of start frame
      start_frame = atoi(arg);
    }
    else if(!strcmp(id,"ENDFRAME")) { // number of last frame
      end_frame = atoi(arg);
    }
    else if(!strcmp(id,"FPS")) {      // Fames per second
      frames_per_sec = atoi(arg);
    }
    else if(!strcmp(id,"STARTTIME")) {// Time index (in secs) of first frame
      start_time = atof(arg);
    }
    else {
      textcolor(LIGHTMAGENTA);
      cprintf("UNKOWN CONFIG SPECIFIER:  [%s] -  ignoring....\r\n",id);
    }

  }

  fclose(input);                      // Wrap it up

}


/**************************************************************************
  void syntax()

  DESCTRIPTION: Displays usage information.

**************************************************************************/
void syntax()
{
  textcolor(YELLOW);
  cprintf("USAGE:  ");
  textcolor(WHITE);
  cprintf("animate ");
  textcolor(LIGHTGRAY);
  cprintf("pov_scene_file");
  textcolor(WHITE);
  cprintf(" [");
  textcolor(LIGHTGRAY);
  cprintf("config_file");
  textcolor(WHITE);
  cprintf("] [");
  textcolor(LIGHTGRAY);
  cprintf("arguments");
  textcolor(WHITE);
  cprintf("]\r\n\n");

  textcolor(LIGHTRED);
  cprintf("Valid arguments:\r\n");
  cprintf("  -pov  [text]     pathname of POV executable\r\n");
  cprintf("  -def  [text]     pathname of .def file\r\n");
  cprintf("  -seed [text]     Seed name for output pics\r\n");
  cprintf("  -pdir [text]     Picture Output directory\r\n");
  cprintf("  -pid  [text]     Id string for parsable lines\r\n");
  cprintf("  -sf   [number]   Number of starting frame\r\n");
  cprintf("  -ef   [Number]   Number of last frame to be rendered\r\n");
  cprintf("  -fps  [number]   Frames per second\r\n");
  cprintf("  -st   [number]   Time index (in seconds) of start frame\r\n");
  cprintf("  -args [\"text\"]   Arguments for the POV command line\r\n");
  cprintf("  -h, -x           Help\r\n");
  cprintf("  -debug           Set debug mode ON\r\n");
  cprintf("  -pause           Request keystroke after every frame\r\n");
  exit(0);

}

