/***************************************************************************
BOUNCING BALL AND ROTATING GLASS CUBE.


This is an example pov file for Varmint's POV animator.

Assembled by Eric Jorgensen (1994)

This is intended for a 60 frame animation.

****************************************************************************/

#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"
#include "stones.inc"


camera {
  location  <20, 3, -55> 
  direction <0, 0, 4>
  sky       <0, 1, 0> 
  up        <0, 1, 0>
  right     <1, 0, 0>
  look_at   <0, 0, 0> 
}


sphere {
	<0,0,0>, 3
	texture {
		pigment {rgb <1,1,.6>}
		finish {specular 0.9 roughness 0.003 metallic reflection 1 ambient 0.0 diffuse 0.0}
	}
		//* @set(scaleout,1)
		//* @set(scaleup,1)
		//* @set(height,(@ABS(@sin((FRAME / 20) * PI)) * 2))   
		//* @if((height < 0.5),(@set(scaleout,(1 + ((0.5 - height) * 0.1)))),(" ")) 
		//* @if((height < 0.5),(@set(scaleup ,(1 - ((0.5 - height) * 0.1)))),(" "))
	scale < //* "" + scaleout + ","
		   //* "" + scaleup + ","
		   //* "" + scaleout + ">"

	translate <3,
		//* "" + (-1.05 + height) + ","
		3>
	
}

box {
   <-2,-2,-2>,<2,2,2>
   texture {
	pigment { White filter 0.9 }
	finish { specular 0.9 reflection .4 diffuse .2 refraction 1 ior 1.5 }
   }
   rotate x*22
   rotate y*12
   rotate z*65
   //* "rotate x*" + (FRAME * 6)
   rotate y*30

   translate <-1.5,.5,-5>

}

plane {
	<0,1,0>,-4
	texture {
		pigment {checker color Yellow color Magenta}
		finish {reflection 0 ambient .2 diffuse .7}
		scale <10,10,10>
	}
}

difference {
	sphere {<0,0,0>,50000
		scale <1,.2,1>
	}
	sphere {<0,0,0>,49990
		scale <1,.2,1>
		texture { Apocalypse 
			translate < //* "" + (FRAME * .03) + "," 
					  //* "" + (FRAME) + "," 
					  0>
			scale <1000,1000,1000>

		}
	}
}

light_source { <-40, 70, -30> color White }


 
