
;
;   GUSHCODE.ASM
;
;   (Simon Hern, 1994)
;
;   Assembler routine for executing the gush code of a planet
;
;   The 'gush' is a large chunk of code which, when executed, draws a planet
;   It is split into four 'slices' to work with the 'planes' in Mode X
;   The first byte of the gush is the radius of the planet (not needed here)
;   This is followed by four jump instructions, vectors into the four slices
;   A slice is called with ds:si pointing to the 'xion' surface data
;                      and es:di pointing to the destination in video memory
;   Each slice ends with a 'far' return
;   This routine is an interface to the gush code
;   It matches the gush slices to the Mode X planes
;
;   Uses 320x240 Mode X (as supported by XLib06)
;
;   Called from PLANETS.C
;


    public _display_gush            ; Exported routine

    extrn _HiddenPageOffs:word      ; Offset of destination video page
                                    ; (variable provided by XLib)


SEQU_ADDR   EQU 003c4h      ; Base port of the Sequencer (ModeX plane select)
VID_SEG     EQU 0a000h      ; Segment of video memory
SCR_WIDTH   EQU 320         ; Screen width (Mode X)
SCR_HEIGHT  EQU 240         ; Screen height (Mode X)


_Text   SEGMENT BYTE PUBLIC 'Code'


Slice1: dd 0    ; Pointers to vectors to the four gush slices
Slice2: dd 0    ;  ie, addresses to bounce off to get to gush code
Slice3: dd 0    ;  (I couldn't figure out a simpler way to get this to work)
Slice4: dd 0


; void display_gush(int x, int y, int rot, char far * gu, char far * xi);
;   x, y : coordinates (across, down) of top-left 'corner' of planet image
;   rot : amount by which planet is rotated
;   gu : address of start of gush data
;   xi : address of start of xion data

; (nb. I'm sort of working under the assumption that the C compiler is
;   considerate enough to allocate 'far' and 'huge' arrays on paragraph
;   boundaries, so that the pointers to them come out as WXYZ:0000.
;    The manual isn't too lucid on the subject, but, well, nothing's gone
;   wrong yet.)

_display_gush:
    push ax
    push bx
    push cx
    push dx
    push di
    push si
    push bp
    push ds
    push es

    mov bp,sp
    mov bx,w[bp+20]             ; bx = int x
    mov cx,w[bp+22]             ; cx = int y
    mov dx,w[bp+24]             ; dx = int rot

    mov ax,w[bp+26]             ; ax = gush offset
    inc ax
    mov cs:w[Slice1],ax
    add ax,3
    mov cs:w[Slice2],ax
    add ax,3
    mov cs:w[Slice3],ax
    add ax,3
    mov cs:w[Slice4],ax
    mov ax,w[bp+28]             ; ax = gush segment
    mov cs:w[Slice1+2],ax
    mov cs:w[Slice2+2],ax
    mov cs:w[Slice3+2],ax
    mov cs:w[Slice4+2],ax       ; set up pointers to vectors to gush slices (!)

    push VID_SEG
    pop es
    mov di,bx
    shr di,1
    shr di,1
    add di,_HiddenPageOffs      ; WARNING! ds has got to be valid here
    mov ax,cx                   ;    (a bug just waiting to happen)
    mov cl,SCR_WIDTH/4
    mul cl
    add di,ax                   ; es:di points to top left of image

    mov ax,w[bp+32]
    mov ds,ax
    mov si,w[bp+30]             ; (Possible bug - this value always zero?)
    add si,dx                   ; ds:si points to start of rotated xion

    cld
    mov dx,SEQU_ADDR
    and bl,3                    ; choose how to align slices based on
    jnz dis05                   ;  two lowest order bits of x coordinate
    jmp dis00
dis05:
    dec bl
    jz dis01
    dec bl
    jz dis02

dis03:                          ; align image to plane 3
    mov bx,di
    mov ax,00802h
    out dx,ax
    call cs:d[Slice1]

    inc bx
    mov di,bx
    mov ax,00102h
    out dx,ax
    call cs:d[Slice2]

    mov di,bx
    mov ax,00202h
    out dx,ax
    call cs:d[Slice3]

    mov di,bx
    mov ax,00402h
    out dx,ax
    call cs:d[Slice4]
    jmp dis04

dis02:                          ; align image to plane 2
    mov bx,di
    mov ax,00402h
    out dx,ax
    call cs:d[Slice1]

    mov di,bx
    mov ax,00802h
    out dx,ax
    call cs:d[Slice2]

    inc bx
    mov di,bx
    mov ax,00102h
    out dx,ax
    call cs:d[Slice3]

    mov di,bx
    mov ax,00202h
    out dx,ax
    call cs:d[Slice4]
    jmp dis04

dis01:                          ; align image to plane 1
    mov bx,di
    mov ax,00202h
    out dx,ax
    call cs:d[Slice1]

    mov di,bx
    mov ax,00402h
    out dx,ax
    call cs:d[Slice2]

    mov di,bx
    mov ax,00802h
    out dx,ax
    call cs:d[Slice3]

    inc bx
    mov di,bx
    mov ax,00102h
    out dx,ax
    call cs:d[Slice4]
    jmp dis04

dis00:                          ; align image to plane 0
    mov bx,di
    mov ax,00102h
    out dx,ax
    call cs:d[Slice1]

    mov di,bx
    mov ax,00202h
    out dx,ax
    call cs:d[Slice2]

    mov di,bx
    mov ax,00402h
    out dx,ax
    call cs:d[Slice3]

    mov di,bx
    mov ax,00802h
    out dx,ax
    call cs:d[Slice4]

dis04:                          ; and finish
    pop es
    pop ds
    pop bp
    pop si
    pop di
    pop dx
    pop cx
    pop bx
    pop ax
    ret


_Text ENDS

