/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 26                        
                                                                            
 Demonstrates use of wgtprintf command.                                     
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 You must have LITTLE.WFN in your executable directory.                     
                                                                            
ͼ
*/

#include <conio.h>
#include <wgt45.h>


void main (void)
{
wgtfont little;		/* Pointer to font data */
float f;                /* Temporary variable */
int i;			/* Loop counter */
int oldmode;		/* Stores initial video mode */

  printf ("WGT Example #26\n\n");
  printf ("A graphics version of the printf command is demonstrated.\n");
  printf ("The WGTPRINTF command supports custom fonts. Press a key to end the program\n");
  printf ("at any time.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();	/* Gets the current mode */
  vga256 ();  			/* Initialize graphics mode */
  little = wloadfont ("little.wfn");

  wtextcolor (15);		/* Set text to white */
  wtextbackground (0);		/* Background is black */
  wtexttransparent (2);		/* We want to display both the foreground
				   and background */
  i = 0;
  do {
    f = (float)i / 100;		/* Create some bogus float value */
    wgtprintf (5, 50, little, "COUNT: %5i   FLOAT: %5.2f ",i,f);
    i++;
  } while (!kbhit ());
  getch ();
  wsetmode (oldmode);		/* Restores intial video mode */
}