/*
The programs contained herein are adapted from 
Artificial Intelligence Using C by
Herbert Schildt published by Osborne/McGraw-Hill, Copyright
1987, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/


listing 4-1
/* structure of the word database */
struct word {
  char word[20];
  char type;  
};

struct word wdb[MAX];  /* array of db structures */






listing 4-2

/* return one token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*t_pos==' ') t_pos++;
 
  if(*t_pos=='.') {
    *p++='.';
    *p='\0';
    return;
  }
  
  /* read word until a space or period */
  while(*t_pos!=' ' && *t_pos!='.')  {
    *p=*t_pos++;
                p++;
  }
  *p='\0';
}






listing 4-3


/* state machine parser */
parse()
{
  char type;

  do {
    get_token();
    /* transition to new state */
    if(!(state=is_legal(token,state))) {
      printf("Error in sentence.\n");
      return 0;
    }
  } while (*token!='.');
  return 1;
}






listing 4-4
  
/* check for valid state transitions */
is_legal(word,state)
char *word;
int state;
{
  int type;

  type=find_type(word);
  if(type==DET) return state;  /* skip */
  if(type==TERM) return TERM; /* end of sentence */

  switch(state) {
    case STARTUP: if(type!=DET) return type;
      else return STARTUP;

    case NOUN:
      if(type==VERB) return VERB;
      if(type==PREP) return PREP;
      break;
    case VERB:
      if(type==PREP) return PREP;
      if(type==NOUN) return NOUN;
      if(type==ADV) return ADV;
      if(type==ADJ) return ADJ;
      break;
    case ADV:
      if(type==NOUN) return NOUN;
      if(type==PREP) return PREP;
      break;
    case ADJ:
      if(type==NOUN) return NOUN;
      break;
    case PREP:
      if(type==ADJ) return ADJ;
      if(type==NOUN) return NOUN;
      break;
  }
  return 0;
}






listing 4-5
/* state-machine NLP example */
#include "stdio.h"

#define MAX 100

#define NOUN 1
#define VERB 2
#define ADJ 3
#define ADV 4
#define DET 5
#define PREP 6
#define TERM 7
#define STARTUP -1

/* structure of the word database */
struct word {
  char word[20];
  char type;  
};

struct word wdb[MAX];  /* array of db structures */

int db_pos=0; /* number of entries in wdb */

char state=STARTUP;  /* holds the current state of the machine */

char s[80];    /* holds the sentence */
char *t_pos=0;   /* points into the sentence */
char token[80];  /* contains the word */

main()
{

  setup();

  printf("Enter Sentence: ");
  gets(s);
  t_pos=s;
  if(parse()) printf("Sentence OK\n");

}

setup()
{
  assert_wdb("door",NOUN);
  assert_wdb("window",NOUN);
  assert_wdb("house",NOUN);
  assert_wdb("child",NOUN);
  assert_wdb("has",VERB);
  assert_wdb("runs",VERB);
  assert_wdb("plays",VERB);
  assert_wdb("large",ADJ);
  assert_wdb("quickly",ADV);
  assert_wdb("the",DET);
  assert_wdb("a",DET);
  assert_wdb("to",PREP);
  assert_wdb(".",TERM);
}

/* place facts into database */
assert_wdb(word,type)
char *word;
int type;
{

  if(db_pos<MAX) {
    strcpy(wdb[db_pos].word,word);
    wdb[db_pos].type=type;
    db_pos++;
  }
  else printf("Word database full.\n");
}

/* state machine parser */
parse()
{
  char type;

  do {
    get_token();
    /* transition to new state */
    if(!(state=is_legal(token,state))) {
      printf("Error in sentence.\n");
      return 0;
    }
  } while (*token!='.');
  return 1;
}
  
/* check for valid state transitions */
is_legal(word,state)
char *word;
int state;
{
  int type;

  type=find_type(word);
  if(type==DET) return state;  /* skip */
  if(type==TERM) return TERM; /* end of sentence */

  switch(state) {
    case STARTUP: if(type!=DET) return type;
      else return STARTUP;
    case NOUN:
      if(type==VERB) return VERB;
      if(type==PREP) return PREP;
      break;
    case VERB:
      if(type==PREP) return PREP;
      if(type==NOUN) return NOUN;
      if(type==ADV) return ADV;
      if(type==ADJ) return ADJ;
      break;
    case ADV:
      if(type==NOUN) return NOUN;
      if(type==PREP) return PREP;
      break;
    case ADJ:
      if(type==NOUN) return NOUN;
      break;
    case PREP:
      if(type==ADJ) return ADJ;
      if(type==NOUN) return NOUN;
      break;
  }
  return 0;
}
        
/* find the type given the word */
find_type(word)
char *word;
{
  int t;

  for(t=0; t<db_pos; t++)
    if(!strcmp(word,wdb[t].word))
      return wdb[t].type;
  return 0;
}

/* return one token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*t_pos==' ') t_pos++;
 
        if(*t_pos=='.') {
    *p++='.';
    *p='\0';
    return;
  }
  
  /* read word until a space or period */
  while(*t_pos!=' ' && *t_pos!='.')  {
    *p=*t_pos++;
                p++;
  }
  *p='\0';
}
  





listing 4-6

/* Context-free recursive descent NLP parser */
parse()
{

  if(!nounphrase()) return 0;
  if(!verbphrase()) return 0;
  if(!terminator()) return 0;
  return 1;
  
}
  
/* read a noun phrase from the input stream */
nounphrase()
{
  char type;

  get_token();

  type=find_type(token);
  switch(type) {
    case DET:
      get_token();
      type=find_type(token);
      if(type==NOUN) return 1;
      else if(type==ADJ) {
        get_token();
        type=find_type(token);
        if(type==NOUN) return 1;
      }
      break;
    case PREP:
      return nounphrase();
  }
  return 0;
}

/* read a verb phrase */
verbphrase()
{
  char type,*pos;

  get_token();

  type=find_type(token);
  if(type!=VERB) return 0;  /* must start with a verb */
  pos=t_pos; /* save current position for backtracking */  
  
  /* verb + adverb + NP */
  if(verb_adv_np()) return 1;

  /* verb +NP */
  t_pos=pos;  /* back up */
  if(verb_np()) return 1;

  /* verb+adverb -- no NP */
  t_pos=pos;
  if(verb_adv()) return 1;

  /* just verb */
  return 1;  /* error in verb phrase */
}

verb_np()
{
  /* verb + NP */
  return nounphrase();
}

verb_adv_np()
{
  char type;

  get_token();
  type=find_type(token);

  if(type==ADV && nounphrase()) return 1;
  return 0;
}

verb_adv()
{
  char type;

  get_token();
  type=find_type(token);

  return (type==ADV);
}
        
terminator()
{
  get_token();
  return(find_type(token)==TERM);
}






listing 4-7
/* Recursive descent NLP Example */
#include "stdio.h"

#define MAX 100

#define NOUN 1
#define VERB 2
#define ADJ 3
#define ADV 4
#define DET 5
#define PREP 6
#define TERM 7

/* structure of the word database */
struct word {
  char word[20];
  char type;  
};

struct word wdb[MAX];  /* array of db structures */

int db_pos=0; /* number of entries in wdb */

char s[80];    /* holds the sentence */
char *t_pos=0;   /* points into the sentence */
char token[80];  /* contains the word */

main()
{

  setup();

  printf("Enter Sentence: ");
  gets(s);
  t_pos=s;
  if(parse()) printf("Sentence OK\n");
  else printf("Error in sentence\n");
}

setup()
{
  assert_wdb("door",NOUN);
  assert_wdb("window",NOUN);
  assert_wdb("house",NOUN);
  assert_wdb("child",NOUN);
  assert_wdb("has",VERB);
  assert_wdb("runs",VERB);
  assert_wdb("plays",VERB);
  assert_wdb("large",ADJ);
  assert_wdb("quickly",ADV);
  assert_wdb("the",DET);
  assert_wdb("a",DET);
  assert_wdb("to",PREP);
  assert_wdb(".",TERM);
}

/* place facts into database */
assert_wdb(word,type)
char *word;
int type;
{

  if(db_pos<MAX) {
    strcpy(wdb[db_pos].word,word);
    wdb[db_pos].type=type;
    db_pos++;
  }
  else printf("Word database full.\n");
}

/* Context-free recursive descent NLP parser */
parse()
{

  if(!nounphrase()) return 0;
  if(!verbphrase()) return 0;
  if(!terminator()) return 0;
  return 1;
  
}
  
/* read a noun phrase from the input stream */
nounphrase()
{
  char type;

  get_token();

  type=find_type(token);
  switch(type) {
    case DET:
      get_token();
      type=find_type(token);
      if(type==NOUN) return 1;
      else if(type==ADJ) {
        get_token();
        type=find_type(token);
        if(type==NOUN) return 1;
      }
      break;
    case PREP:
      return nounphrase();
  }
  return 0;
}

/* read a verb phrase */
verbphrase()
{
  char type,*pos;

  get_token();

  type=find_type(token);
  if(type!=VERB) return 0;  /* must start with a verb */
  pos=t_pos; /* save current position for backtracking */  
  
  /* verb + adverb + NP */
  if(verb_adv_np()) return 1;

  /* verb +NP */
  t_pos=pos;  /* back up */
  if(verb_np()) return 1;

  /* verb+adverb -- no NP */
  t_pos=pos;
  if(verb_adv()) return 1;

  /* just verb */
  return 1;  /* error in verb phrase */
}

verb_np()
{
  /* verb + NP */
  return nounphrase();
}

verb_adv_np()
{
  char type;

  get_token();
  type=find_type(token);

  if(type==ADV && nounphrase()) return 1;
  return 0;
}

verb_adv()
{
  char type;

  get_token();
  type=find_type(token);

  return (type==ADV);
}
        
terminator()
{
  get_token();
  return(find_type(token)==TERM);
}

/* find the type given the word */
find_type(word)
char *word;
{
  int t;

  for(t=0; t<db_pos; t++)
    if(!strcmp(word,wdb[t].word))
      return wdb[t].type;
  return 0;
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*t_pos==' ') t_pos++;
 
        if(*t_pos=='.') {
    *p++='.';
    *p='\0';
    return;
  }
  
  /* read word until a space or period */
  while(*t_pos!=' ' && *t_pos!='.')  {
    *p=*t_pos++;
                p++;
  }
  *p='\0';
}





listing 4-8

/* Context-free recursive descent NLP parser 
   that displays phrases  */
parse()
{
  char noun[80], verb[80];

  noun[0]='\0'; verb[0]='\0';
  if(!nounphrase(noun)) return 0;
  if(!verbphrase(verb)) return 0;
  if(!terminator()) return 0;
  printf("noun phrase: %s\n",noun);
  printf("verb phrase: %s\n",verb);
  return 1;
  
}
  
/* read a noun phrase from the input stream */
nounphrase(s)
char *s;
{
  char type;

  get_token();

  type=find_type(token);
  switch(type) {
    case DET:
      strcat(s,token);
      strcat(s," ");
      get_token();
      type=find_type(token);
      strcat(s,token);
      strcat(s," ");
      if(type==NOUN) return 1;
      else if(type==ADJ) {
        get_token();
        strcat(s,token);
        strcat(s," ");
        type=find_type(token);
        if(type==NOUN) return 1;
      }
      break;
    case PREP:
      strcat(s,token);
      strcat(s," ");
      return nounphrase(s);
  }
  return 0;
}

/* read a verb phrase */
verbphrase(s)
char *s;
{
  char type,*pos, temp[80];

  get_token();

  type=find_type(token);
  if(type!=VERB) return 0;  /* must start with a verb */
  strcat(s,token);
  strcat(s," ");
  strcpy(temp,s);  /* save for backtracking */
  pos=t_pos; /* save current position for backtracking */  
  
  /* verb + adverb + NP */
  if(verb_adv_np(s)) return 1;

  /* verb +NP */
  t_pos=pos;  /* back up */
  strcpy(s,temp);
  if(verb_np(s)) return 1;

  /* verb+adverb -- no NP */
  t_pos=pos;
  strcpy(s,temp);
  if(verb_adv(s)) return 1;

  /* just verb */
  return 1;  /* error in verb phrase */
}

verb_np(s)
char *s;
{
  /* verb + NP */
  return nounphrase(s);
}

verb_adv_np(s)
char *s;
{
  char type, temp[80];

  get_token();
  type=find_type(token);
  strcat(s,token);
  strcat(s," ");
  temp[0]='\0';
  
  if(type==ADV && nounphrase(temp)) {
    strcat(s,temp);
    return 1;
  }
  return 0;
}

verb_adv(s)
char *s;
{
  char type;

  get_token();
  type=find_type(token);
  strcat(s,token);
  strcat(s," ");

  return (type==ADV);
}
        
terminator()
{
  get_token();
  return(find_type(token)==TERM);
}






listing 4-9
/* Recursive descent NLP Example that reports the phrases */
#include "stdio.h"

#define MAX 100

#define NOUN 1
#define VERB 2
#define ADJ 3
#define ADV 4
#define DET 5
#define PREP 6
#define TERM 7

/* structure of the word database */
struct word {
  char word[20];
  char type;  
};

struct word wdb[MAX];  /* array of db structures */

int db_pos=0; /* number of entries in wdb */

char s[80];    /* holds the sentence */
char *t_pos=0;   /* points into the sentence */
char token[80];  /* contains the word */

main()
{

  setup();

  printf("Enter Sentence: ");
  gets(s);
  t_pos=s;
  if(parse()) printf("Sentence OK\n");
  else printf("Error in sentence\n");
}

setup()
{
  assert_wdb("door",NOUN);
  assert_wdb("window",NOUN);
  assert_wdb("house",NOUN);
  assert_wdb("child",NOUN);
  assert_wdb("has",VERB);
  assert_wdb("runs",VERB);
  assert_wdb("plays",VERB);
  assert_wdb("large",ADJ);
  assert_wdb("quickly",ADV);
  assert_wdb("the",DET);
  assert_wdb("a",DET);
  assert_wdb("to",PREP);
  assert_wdb(".",TERM);
}

/* place facts into database */
assert_wdb(word,type)
char *word;
int type;
{

  if(db_pos<MAX) {
    strcpy(wdb[db_pos].word,word);
    wdb[db_pos].type=type;
    db_pos++;
  }
  else printf("Word database full.\n");
}

/* Context-free recursive descent NLP parser 
   that displays phrases  */
parse()
{
  char noun[80], verb[80];

  noun[0]='\0'; verb[0]='\0';
  if(!nounphrase(noun)) return 0;
  if(!verbphrase(verb)) return 0;
  if(!terminator()) return 0;
  printf("noun phrase: %s\n",noun);
  printf("verb phrase: %s\n",verb);
  return 1;
  
}
  
/* read a noun phrase from the input stream */
nounphrase(s)
char *s;
{
  char type;

  get_token();

  type=find_type(token);
  switch(type) {
    case DET:
      strcat(s,token);
      strcat(s," ");
      get_token();
      type=find_type(token);
      strcat(s,token);
      strcat(s," ");
      if(type==NOUN) return 1;
      else if(type==ADJ) {
        get_token();
        strcat(s,token);
        strcat(s," ");
        type=find_type(token);
        if(type==NOUN) return 1;
      }
      break;
    case PREP:
      strcat(s,token);
      strcat(s," ");
      return nounphrase(s);
  }
  return 0;
}

/* read a verb phrase */
verbphrase(s)
char *s;
{
  char type,*pos, temp[80];

  get_token();

  type=find_type(token);
  if(type!=VERB) return 0;  /* must start with a verb */
  strcat(s,token);
  strcat(s," ");
  strcpy(temp,s);  /* save for backtracking */
  pos=t_pos; /* save current position for backtracking */  
  
  /* verb + adverb + NP */
  if(verb_adv_np(s)) return 1;

  /* verb +NP */
  t_pos=pos;  /* back up */
  strcpy(s,temp);
  if(verb_np(s)) return 1;

  /* verb+adverb -- no NP */
  t_pos=pos;
  strcpy(s,temp);
  if(verb_adv(s)) return 1;

  /* just verb */
  return 1;  /* error in verb phrase */
}

verb_np(s)
char *s;
{
  /* verb + NP */
  return nounphrase(s);
}

verb_adv_np(s)
char *s;
{
  char type, temp[80];

  get_token();
  type=find_type(token);
  strcat(s,token);
  strcat(s," ");
  temp[0]='\0';
  
  if(type==ADV && nounphrase(temp)) {
    strcat(s,temp);
    return 1;
  }
  return 0;
}

verb_adv(s)
char *s;
{
  char type;

  get_token();
  type=find_type(token);
  strcat(s,token);
  strcat(s," ");

  return (type==ADV);
}
        
terminator()
{
  get_token();
  return(find_type(token)==TERM);
}

/* find the type given the word */
find_type(word)
char *word;
{
  int t;

  for(t=0; t<db_pos; t++)
    if(!strcmp(word,wdb[t].word))
      return wdb[t].type;
  return 0;
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*t_pos==' ') t_pos++;
 
        if(*t_pos=='.') {
    *p++='.';
    *p='\0';
    return;
  }
  
  /* read word until a space or period */
  while(*t_pos!=' ' && *t_pos!='.')  {
    *p=*t_pos++;
                p++;
  }
  *p='\0';
}






listing 4-10
/* structure of the stock db */
struct companies {
  char name[20];
  float price;  
};

struct companies stock[MAX];  /* array of db structures */






listing 4-11
/* Noise Disposal NLP parser */
parse()
{
  char com[80], mod[80], name[80], op;
  float quant;

  if(!get_com(com)) return 0;
  get_mod(mod);
  get_name(name);
  op=get_op();
  quant=get_quant();
  perform(com,mod,name,op,quant);
  return 1;
}






listing 4-12
    
/* get the command */
get_com(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=COMMAND) {
    strcpy(s,"");
    return 0;
  }
  strcpy(s,token);
  return 1;
}

/* get a modifier or default to "all" */
get_mod(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=MODIFIER) {
    strcpy(s,"all");
    put_back();
    return;
  }
  strcpy(s,token);
}

/* get the command */
get_name(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=NAME) {
    strcpy(s,"");
    put_back();
    return;
  }
  strcpy(s,token);
}

/* get an operator */
get_op()
{
  get_noise();
  get_token();
  if(find_type(token)==OPERATOR)
    return *token;
  else return 0;
}

/* get a number */
float get_quant()
{
  float t;
  get_token();
  if(*token!='.')
    sscanf(token,"%f",&t);
  return t;
}

/* check for noise */
get_noise()
{
  do {
    get_token();
  } while(!find_type(token));
  put_back(); /* return a valid token to stream */
}






listing 4-13

/* Noise-disposal NLP database query example. */
#include "stdio.h"

#define MAX 100

#define NOISE 0
#define COMMAND 1
#define NAME 2
#define MODIFIER 3
#define OPERATOR 4
#define TERM 5

/* structure of the word database */
struct word {
  char word[20];
  char type;  
};

struct word wdb[MAX];  /* array of db structures */

/* structure of the stock db */
struct companies {
  char name[20];
  float price;  
};

struct companies stock[MAX];  /* array of db structures */

int db_pos=0; /* number of entries in wdb */
int stock_pos=0; /* number of entries in stock db */

char s[80];    /* holds the sentence */
char *t_pos=0;   /* points into the sentence */
char token[80];  /* contains the word */

float get_quant(), find_price(), find_name();

main()
{

  setup();

  printf("Enter query: ");
  gets(s);
  printf("\n");
  t_pos=s;
  if(!parse()) printf("Query not understood.\n");
}

setup()
{
  assert_wdb("xyz",NAME);
  assert_wdb("ucl",NAME);
  assert_wdb("abc",NAME);
  assert_wdb("show",COMMAND);
  assert_wdb("is",COMMAND);
  assert_wdb("all",MODIFIER);
  assert_wdb("one",MODIFIER);
  assert_wdb(">",OPERATOR);
  assert_wdb("<",OPERATOR);
  assert_wdb("=",OPERATOR);
  assert_wdb(".",TERM);
  assert_wdb("?",TERM);

  assert_stock("ucl",123.00);
  assert_stock("abc",35.75);
  assert_stock("xyz",100.0);
}

/* place words into database */
assert_wdb(word,type)
char *word;
int type;
{

  if(db_pos<MAX) {
    strcpy(wdb[db_pos].word,word);
    wdb[db_pos].type=type;
    db_pos++;
  }
  else printf("Word database full.\n");
}

/* place companies into database */
assert_stock(name,price)
char *name;
float price;
{

  if(stock_pos<MAX) {
    strcpy(stock[stock_pos].name,name);
    stock[stock_pos].price=price;
    stock_pos++;
  }
  else printf("Stock database full.\n");
}

/* Noise Disposal NLP parser */
parse()
{
  char com[80], mod[80], name[80], op;
  float quant;

  if(!get_com(com)) return 0;
  get_mod(mod);
  get_name(name);
  op=get_op();
  quant=get_quant();
  perform(com,mod,name,op,quant);
  return 1;
}

/* get the command */
get_com(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=COMMAND) {
    strcpy(s,"");
    return 0;
  }
  strcpy(s,token);
  return 1;
}

/* get a modifier or default to "all" */
get_mod(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=MODIFIER) {
    strcpy(s,"all");
    put_back();
    return;
  }
  strcpy(s,token);
}

/* get the command */
get_name(s)
char *s;
{
  get_noise();
  get_token();
  if(find_type(token)!=NAME) {
    strcpy(s,"");
    put_back();
    return;
  }
  strcpy(s,token);
}

get_op()
{
  get_noise();
  get_token();
  if(find_type(token)==OPERATOR)
    return *token;
  else return 0;
}

float get_quant()
{
  float t;
  get_token();
  if(*token!='.')
    sscanf(token,"%f",&t);
  return t;
}

get_noise()
{
  do {
    get_token();
  } while(!find_type(token));
  put_back(); /* return a valid token to stream */
}

perform(com,mod,name,op,quant)
char *com,*mod,*name,op;
float quant;
{

  if(!strcmp("show",com)) {
    if(*name) printf("%f\n",find_price(name));
    else search(mod,op,quant);
  }
  else { /* is */
    switch(op) {
      case '=': 
        if(quant==find_price(name))
          printf(" yes\n");
        else printf(" no\n");
        break;
      case '<':
        if(find_price(name)<quant)
          printf(" yes\n");
        else printf(" no\n");
        break;
      case '>':
        if(find_price(name)>quant)
          printf(" yes\n");
        else printf(" no\n");
        break;
    }
  }
}

search(mod,op,quant)
char *mod,op;
float quant;
{
  char name[80];
  float price;

  find_name("",quant,op,1); /* restart */
  if(!strcmp(mod,"all")) {
    while((price=find_name(name,quant,op,0))!=0) {
      printf("%s",name);
      printf(" %f\n",price);
    }
  }
  else {
    price=find_name(name,quant,op,0);
    printf("%s",name);
    printf(" %f\n",price);
  }
}


/* return the last token to the input stream */
put_back()  
{
  int t;

  for(t=0;t<strlen(token);t++) t_pos--;
}

terminator()
{
  get_token();
  return(find_type(token)==TERM);
}

/* given name find price */
float find_price(name)
char *name;
{
  int t;

  for(t=0; t<stock_pos; t++) {
    if(!strcmp(name,stock[t].name))
      return stock[t].price;
  }
  return -1.0;
}

/* given price and op find name */
float find_name(name,price,op,restart)
char *name,op,restart;
float price;
{
  static int t;
  
  if(restart) {
    t=0;
    return;
  }
  do {
     switch(op) {
      case '=':
        if(stock[t].price==price) {
          strcpy(name,stock[t].name);
          t++;
          return stock[t-1].price;
        }
        break;
      case '<':
        if(stock[t].price<price) {
          strcpy(name,stock[t].name);
          t++;
          return stock[t-1].price;
        }
        break;
      case '>':
        if(stock[t].price>price) {
          strcpy(name,stock[t].name);
          t++;
          return stock[t-1].price;
        }
        break;
      case '\0':
        strcpy(name,stock[t].name);
        t++;
        return stock[t-1].price;
    }
    t++;
  } while(t<=stock_pos);
  return 0;
}


/* find the type given the word */
find_type(word)
char *word;
{
  int t;

  for(t=0; t<db_pos; t++)
    if(!strcmp(word,wdb[t].word))
      return wdb[t].type;
  return 0;
}

get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*t_pos==' ') t_pos++;
 
        if(*t_pos=='.') {
    *p++='.';
    *p='\0';
    return;
  }
  
  /* read word until a space or period */
  while(*t_pos!=' ' && *t_pos!='.')  {
    *p=*t_pos++;
                p++;
  }
  *p='\0';
}



