/*
The programs contained herein are adapted from 
Artificial Intelligence Using C by
Herbert Schildt published by Osborne/McGraw-Hill, Copyright
1987, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/


listing 5-1

/* checks to see if the point is an '*'
   using BIOS int 10h, #8 */
check_point(a,b)
int a,b;
{
  union REGS regs;

  gotoxy(a,b); 
  regs.h.ah=8;
  regs.h.bh=0;
  int86(16,&regs, &regs);
  if(regs.h.al=='*') return 1;
  return 0;
}

/* put cursor at x,y */
gotoxy(x,y)
int x,y;
{
  union REGS regs;

  regs.h.ah=2;
  regs.h.dh=y;
  regs.h.dl=x;
  regs.h.bh=0;
  int86(16,&regs, &regs);
}

/* clear the screen */
cls()
{
  union REGS regs;

  regs.h.ah=6;
  regs.h.al=0;
  regs.h.ch=0;
  regs.h.cl=0;
  regs.h.dh=24;
  regs.h.dl=79;
  regs.h.bh=7;
  int86(16,&regs, &regs);
}






listing 5-2
/* draw a triangle at x,y */
make_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x-t,y+t);
    printf("*");
  }

  for(t=0;t<5;t++) {
    gotoxy(x+t,y+t);
    printf("*");
  }
  
  gotoxy(x-5,y+5);
  printf("***********");
}

/* draw a square at x,y */
make_square(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x,y+t);
    printf("*");
  }


  for(t=0;t<5;t++) {
    gotoxy(x+10,y+t);
    printf("*");
  }

  gotoxy(x,y);
  printf("***********");
  gotoxy(x,y+5);
  printf("***********");
}






listing 5-3

/* returns the cursor loc of an `*` with the
   search beginning with startx and starty */
find_point(startx,starty,x,y)
int startx,starty,*x,*y;
{
  int a,b;
  
  a=startx; b=starty;
  do {
    do {
      if(check_point(a,b)) {
        *x=a;
        *y=b;
        return 1;
      }
      a++;
    } while (a<79);
    a=0;
    b++;
  } while(b<24);
  return 0;
}





listing 5-4
/* check for a triangle */
istriangle(x,y)
int x,y;
{
  if(check_point(x+1,y+1) && check_point(x-1,y+1))
    return 1;

  return 0;
}


/* check for a square */
issquare(x,y)
int x,y;
{
  if(check_point(x+1,y) && check_point(x,y+1))
    return 1;

  return 0;
}







listing 5-5

/* search for a triangle and a square */
recognize()
{
  int x,y;

  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(istriangle(x,y)) {
      gotoxy(0,0);
      printf("triangle at %d %d",x,y);    
      break;
    }
    x++;
  }
  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(issquare(x,y)) {
      gotoxy(0,1);
      printf("square at %d %d",x,y);    
      break;
    }
    x++;
  }
}





listing 5-6

#include "dos.h"

/* Recognition by angles */
main()
{
  position();
  recognize();
  getche();
}

/*  read the positions for the objects */
position()
{
  int x,y,a,b;

  do {
    printf("x y position of triangle: ");
    scanf("%d%d",&x,&y); 
  } while(outrange(x,y));
  
  do {
    printf("\nx y position of square: ");
    scanf("%d%d",&a,&b);
  } while(outrange(x,y));

  cls();

  make_triangle(x,y);
  make_square(a,b);
}

/* return true if out of range coordinates */
outrange(x,y)
int x,y;
{
  if(x<0 || x>79) return 1;
  if(y<0 || y>24) return 1;
  return 0;
}

/* draw a triangle at x,y */
make_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x-t,y+t);
    printf("*");
  }

  for(t=0;t<5;t++) {
    gotoxy(x+t,y+t);
    printf("*");
  }
  
  gotoxy(x-5,y+5);
  printf("***********");
}

/* draw a square at x,y */
make_square(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x,y+t);
    printf("*");
  }


  for(t=0;t<5;t++) {
    gotoxy(x+10,y+t);
    printf("*");
  }

  gotoxy(x,y);
  printf("***********");
  gotoxy(x,y+5);
  printf("***********");
}

/* search for a triangle and a square */
recognize()
{
  int x,y;

  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(istriangle(x,y)) {
      gotoxy(0,0);
      printf("triangle at %d %d",x,y);    
      break;
    }
    x++;
  }
  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(issquare(x,y)) {
      gotoxy(0,1);
      printf("square at %d %d",x,y);    
      break;
    }
    x++;
  }
}

/* check for a triangle */
istriangle(x,y)
int x,y;
{
  if(check_point(x+1,y+1) && check_point(x-1,y+1))
    return 1;

  return 0;
}

/* check for a square */
issquare(x,y)
int x,y;
{
  if(check_point(x+1,y) && check_point(x,y+1))
    return 1;

  return 0;
}

/* returns the cursor loc of an `*` with the
   search beginning with startx and starty */
find_point(startx,starty,x,y)
int startx,starty,*x,*y;
{
  int a,b;
  
  a=startx; b=starty;
  do {
    do {
      if(check_point(a,b)) {
        *x=a;
        *y=b;
        return 1;
      }
      a++;
    } while (a<79);
    a=0;
    b++;
  } while(b<24);
  return 0;
}

/* checks to see if the point is an '*' */
check_point(a,b)
int a,b;
{
  union REGS regs;

  gotoxy(a,b); 
  regs.h.ah=8;
  regs.h.bh=0;
  int86(16,&regs, &regs);
  if(regs.h.al=='*') return 1;
  return 0;
}

/* put cursor at x,y */
gotoxy(x,y)
int x,y;
{
  union REGS regs;

  regs.h.ah=2;
  regs.h.dh=y;
  regs.h.dl=x;
  regs.h.bh=0;
  int86(16,&regs, &regs);
}

/* clear the screen */
cls()
{
  union REGS regs;

  regs.h.ah=6;
  regs.h.al=0;
  regs.h.ch=0;
  regs.h.cl=0;
  regs.h.dh=24;
  regs.h.dl=79;
  regs.h.bh=7;
  int86(16,&regs, &regs);
}
    





listing for this recognizer program.)

One way to identify objects that always have the same size
is to examine only a few key points.  The key locations are
chosen because one and only one object will satisfy the
conditions.  Figure 5-10 shows the three objects that our
recognizer must identify as well as their key points.





listing 5-7
/* check for an isoceles triangle by key points */
istriangle(x,y)
int x,y;
{
  if(check_point(x+5,y+5))
    return 1;

  return 0;
}

/* check for a right triangle by key points */
isright(x,y)
int x,y;
{
  if(check_point(x+9,y) && check_point(x,y+9))
    return 1;

  return 0;
}

/* check for a square by key points */
issquare(x,y)
int x,y;
{
  if(check_point(x+10,y) && check_point(x,y+5) &&
     !check_point(x,y+6)) return 1;

  return 0;
}







listing 5-8

#include "dos.h"

/* Recognition by key points */
main()
{
  position();
  recognize();
  getche();
}

/*  read the positions for the objects */
position()
{
  int x,y,a,b,i,j;

  do {
    printf("x y position of isosceles triangle: ");
    scanf("%d%d",&x,&y); 
  } while(outrange(x,y));
  
  do {
    printf("x y position of right triangle: ");
    scanf("%d%d",&i,&j); 
  } while(outrange(i,j));
  
  do {
    printf("\nx y position of square: ");
    scanf("%d%d",&a,&b);
  } while(outrange(a,b));

  cls();

  make_triangle(x,y);
  make_square(a,b);
  make_right_triangle(i,j);
}

/* return true if out of range coordinates */
outrange(x,y)
int x,y;
{
  if(x<0 || x>79) return 1;
  if(y<0 || y>24) return 1;
  return 0;
}

/* draw an isosceles triangle at x,y */
make_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x-t,y+t);
    printf("*");
  }

  for(t=0;t<5;t++) {
    gotoxy(x+t,y+t);
    printf("*");
  }
  
  gotoxy(x-5,y+5);
  printf("***********");
}

/* draw a right triangle at x,y */
make_right_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<10;t++) {
    gotoxy(x,y+t);
    printf("*");
  }

  for(t=0;t<9;t++) {
    gotoxy(x-t+9,y+t);
    printf("*");
  }
  
  gotoxy(x,y);
  printf("**********");
}

/* draw a square at x,y */
make_square(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x,y+t);
    printf("*");
  }


  for(t=0;t<5;t++) {
    gotoxy(x+10,y+t);
    printf("*");
  }

  gotoxy(x,y);
  printf("***********");
  gotoxy(x,y+5);
  printf("***********");
}

/* search for a triangle and a square */
recognize()
{
  int x,y;
  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(istriangle(x,y)) {
      gotoxy(0,0);
      printf("isosceles triangle at %d %d",x,y);    
      break;
    }
    x++;
  }
  
  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(isright(x,y)) {
      gotoxy(40,0);
      printf("right triangle at %d %d",x,y);    
      break;
    }
    x++;
  }

  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(issquare(x,y)) {
      gotoxy(0,1);
      printf("square at %d %d",x,y);    
      break;
    }
    x++;
  }
}

/* check for an isoceles triangle by key points */
istriangle(x,y)
int x,y;
{
  if(check_point(x+5,y+5))
    return 1;

  return 0;
}

/* check for a right triangle by key points */
isright(x,y)
int x,y;
{
  if(check_point(x+9,y) && check_point(x,y+9))
    return 1;

  return 0;
}

/* check for a square by key points */
issquare(x,y)
int x,y;
{
  if(check_point(x+10,y) && check_point(x,y+5) &&
     !check_point(x,y+6)) return 1;

  return 0;
}

/* returns the cursor loc of an `*` with the
   search beginning with startx and starty */
find_point(startx,starty,x,y)
int startx,starty,*x,*y;
{
  int a,b;
  
  a=startx; b=starty;
  do {
    do {
      if(check_point(a,b)) {
        *x=a;
        *y=b;
        return 1;
      }
      a++;
    } while (a<79);
    a=0;
    b++;
  } while(b<24);
  return 0;
}

/* checks to see if the point is an '*' */
check_point(a,b)
int a,b;
{
  union REGS regs;

  gotoxy(a,b); 
  regs.h.ah=8;
  regs.h.bh=0;
  int86(16,&regs, &regs);
  if(regs.h.al=='*') return 1;
  return 0;
}

/* put cursor at x,y */
gotoxy(x,y)
int x,y;
{
  union REGS regs;

  regs.h.ah=2;
  regs.h.dh=y;
  regs.h.dl=x;
  regs.h.bh=0;
  int86(16,&regs, &regs);
}

/* clear the screen */
cls()
{
  union REGS regs;

  regs.h.ah=6;
  regs.h.al=0;
  regs.h.ch=0;
  regs.h.cl=0;
  regs.h.dh=24;
  regs.h.dl=79;
  regs.h.bh=7;
  int86(16,&regs, &regs);
}







listing 5-9
#define MAX 200

struct oldpoints {
  int x,y;
} oldp[MAX];

int pos=0;  /* high water mark in oldp database */

assert_oldp(x,y)
int x,y;
{

  if(pos==MAX) {
    printf("point database full\n");
    return;
  }
  if(find(x,y)) return; /*already in db */
  oldp[pos].x=x;
  oldp[pos].y=y;
  pos++;
}

find(x,y)
int x,y;
{
  register int t;

  for(t=0;t<pos;t++)  
    if(oldp[t].x==x && oldp[t].y==y) return 1;

  return 0;
}






listing 5-10
/* follow a shape and return number of turns */
follow(x,y)
int x,y;
{
  int incx,incy,startx,starty,count;
  
  startx=x; starty=y;
  count=0;

  assert_oldp(x,y);
  if(!find_direction(x,y,&incx,&incy)) return 0;
  do {
    while(check_point(x+incx,y+incy)) {
      x=incx+x;
      y=incy+y;
      assert_oldp(x,y);
    }
    if(x==startx && y==starty) return count;
    count++;
    if(!find_direction(x,y,&incx,&incy)) return 0;
  } while(1);
}

/* find a new line to follow */
find_direction(x,y,incx,incy)
int x,y,*incx,*incy;
{
  register int a,b;

  for(a=-1; a<2; a++)
    for(b=-1;b<2;b++)
      if(check_point(x+a,y+b) && !find(x+a,y+b)) {
        *incx=a;
        *incy=b;
        return 1;
      }
    return 0;
}






listing 5-11

/* check for a triangle by key points */
istriangle(x,y)
int x,y;
{
  if(follow(x,y)==2) return 1;

  return 0;
}

/* check for a square by key points */
issquare(x,y)
int x,y;
{
  if(follow(x,y)==3) return 1;
  return 0;
}







listing 5-12
#include "dos.h"

#define MAX 200

struct oldpoints {
  int x,y;
} oldp[MAX];

int pos=0;  /* high water mark in oldp database */

/* Delta-D Recognizer */
main()
{
  clear_db(); /* init the point database */
  position();
  recognize();
  getche();
}

/*  read the positions for the objects */
position()
{
  int x,y,a,b,i,j;

  do {
    printf("x y position of isosceles triangle: ");
    scanf("%d%d",&x,&y); 
  } while(outrange(x,y));
  
  do {
    printf("x y position of right triangle: ");
    scanf("%d%d",&i,&j); 
  } while(outrange(i,j));
  
  do {
    printf("\nx y position of square: ");
    scanf("%d%d",&a,&b);
  } while(outrange(a,b));

  cls();

  make_triangle(x,y);
  make_square(a,b);
  make_right_triangle(i,j);
}

/* return true if out of range coordinates */
outrange(x,y)
int x,y;
{
  if(x<0 || x>79) return 1;
  if(y<0 || y>24) return 1;
  return 0;
}

/* draw an isosceles triangle at x,y */
make_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x-t,y+t);
    printf("*");
  }

  for(t=0;t<5;t++) {
    gotoxy(x+t,y+t);
    printf("*");
  }
  
  gotoxy(x-5,y+5);
  printf("***********");
}

/* draw a right triangle at x,y */
make_right_triangle(x,y)
int x,y;
{
  int t;

  for(t=0;t<10;t++) {
    gotoxy(x,y+t);
    printf("*");
  }

  for(t=0;t<9;t++) {
    gotoxy(x-t+9,y+t);
    printf("*");
  }
  
  gotoxy(x,y);
  printf("**********");
}

/* draw a square at x,y */
make_square(x,y)
int x,y;
{
  int t;

  for(t=0;t<5;t++) {
    gotoxy(x,y+t);
    printf("*");
  }


  for(t=0;t<5;t++) {
    gotoxy(x+10,y+t);
    printf("*");
  }

  gotoxy(x,y);
  printf("***********");
  gotoxy(x,y+5);
  printf("***********");
}

/* search for a triangle and a square */
recognize()
{
  int x,y,t;
  
  t=0;
  x=y=0;

  while(find_point(x,y,&x,&y)) {
    if(istriangle(x,y)) {
      gotoxy(t*40,0); t++;
      printf("triangle at %d %d   ",x,y);    
    }
    x++;
  }
  clear_db();

  x=y=0;
  while(find_point(x,y,&x,&y)) {
    if(issquare(x,y)) {
      gotoxy(0,1);
      printf("square at %d %d",x,y);    
      break;
    }
    x++;
  }
}

/* check for a triangle by key points */
istriangle(x,y)
int x,y;
{
  if(follow(x,y)==2) return 1;

  return 0;
}

/* check for a square by key points */
issquare(x,y)
int x,y;
{
  if(follow(x,y)==3) return 1;
  return 0;
}

/* follow a shape and return number of turns */
follow(x,y)
int x,y;
{
  int incx,incy,startx,starty,count;
  
  startx=x; starty=y;
  count=0;

  assert_oldp(x,y);
  if(!find_direction(x,y,&incx,&incy)) return 0;
  do {
    while(check_point(x+incx,y+incy)) {
      x=incx+x;
      y=incy+y;
      assert_oldp(x,y);
    }
    if(x==startx && y==starty) return count;
    count++;
    if(!find_direction(x,y,&incx,&incy)) return 0;
  } while(1);
}

/* find a new line to follow */
find_direction(x,y,incx,incy)
int x,y,*incx,*incy;
{
  register int a,b;

  for(a=-1; a<2; a++)
    for(b=-1;b<2;b++)
      if(check_point(x+a,y+b) && !find(x+a,y+b)) {
        *incx=a;
        *incy=b;
        return 1;
      }
    return 0;
}

assert_oldp(x,y)
int x,y;
{

  if(pos==MAX) {
    printf("point database full\n");
    return;
  }
  if(find(x,y)) return; /*already in db */
  oldp[pos].x=x;
  oldp[pos].y=y;
  pos++;
}

find(x,y)
int x,y;
{
  register int t;

  for(t=0;t<pos;t++)  
    if(oldp[t].x==x && oldp[t].y==y) return 1;
  
  return 0;
}

/* returns the cursor loc of an `*` with the
   search beginning with startx and starty */
find_point(startx,starty,x,y)
int startx,starty,*x,*y;
{
  int a,b;
  
  a=startx; b=starty;
  do {
    do {
      if(check_point(a,b)) {
        *x=a;
        *y=b;
        return 1;
      }
      a++;
    } while (a<79);
    a=0;
    b++;
  } while(b<24);
  return 0;
}

/* checks to see if the point is an '*' */
check_point(a,b)
int a,b;
{
  union REGS regs;

  gotoxy(a,b); 
  regs.h.ah=8;
  regs.h.bh=0;
  int86(16,&regs, &regs);
  if(regs.h.al=='*') return 1;
  return 0;
}

/* put cursor at x,y */
gotoxy(x,y)
int x,y;
{
  union REGS regs;

  regs.h.ah=2;
  regs.h.dh=y;
  regs.h.dl=x;
  regs.h.bh=0;
  int86(16,&regs, &regs);
}

/* clear the screen */
cls()
{
  union REGS regs;

  regs.h.ah=6;
  regs.h.al=0;
  regs.h.ch=0;
  regs.h.cl=0;
  regs.h.dh=24;
  regs.h.dl=79;
  regs.h.bh=7;
  int86(16,&regs, &regs);
}

clear_db()
{
  register int t;

  for(t=0;t<MAX;t++) oldp[t].x=oldp[t].y=0;
}



