/*
The programs contained herein are adapted from 
Artificial Intelligence Using C by
Herbert Schildt published by Osborne/McGraw-Hill, Copyright
1987, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/



listing 7-
struct attribute {
  char subject[80];
  char verb[80];
  char object[80];
  char active;
};






listing 7-
/* learn a class description for an object */
learn()
{
  char sub[80], verb[80], obj[80];
  char msub[80], mverb[80], mobj[80];

  for(;;) {
    printf("Enter an example.\n");
    if(!get_example(sub,verb,obj)) {
      return;
    }
    if(find_may(sub,verb,obj)==-1) {
      assert_may(sub,verb,obj);
      generalize(sub,verb,obj); 
    }
    printf("Enter a near-miss (CR to skip).\n");
    get_example(msub,mverb,mobj);
    restrict(msub,mverb,mobj);
  }
}

/* restrict the description of an object -
   i.e., remove from may_have list and place
   in must_have list.
*/
restrict(ms,mv,mo)
char *ms,*mv,*mo;
{
  register int t;
  char temp[4];
 
  for(t=0;t<3;t++) temp[t]=tolower(mv[t]);
  temp[3]='\0';
  if(strcmp(temp,"not")) return;

  for(t=0;t<may_pos;t++) {
    if(!strcmp(&mv[4],may[t].verb) && 
       !strcmp(may[t].subject,ms) && 
          !strcmp(may[t].object,mo) && may[t].active) {
      assert_must(may[t].subject,may[t].verb,may[t].object);
      may[t].active=0; /* remove from list */
      return;
    }
  }
}
        
/* generalize new examples */
generalize(n,v,o)
char *n,*v,*o;
{
  register int t,i;
  /* check may have list */

  for(t=0;t<may_pos;t++) {
    if(strcmp(may[t].subject,n) &&  /* not same subject */
      !strcmp(may[t].verb,v) && 
         !strcmp(may[t].object,o) && may[t].active) {
         strcat(may[t].subject," or ");
         strcat(may[t].subject,n);
       }
  }
  for(t=0;t<may_pos;t++) {
    if(!strcmp(may[t].subject,n) &&  
      !strcmp(may[t].verb,v) && 
         strcmp(may[t].object,o) /* not same object */
           && may[t].active) {
         strcat(may[t].object," or ");
         strcat(may[t].object,o);
       }
  }
  /* check must have list */
  for(t=0;t<must_pos;t++) {
    if(strcmp(must[t].subject,n) &&  /* not same subject */
      !strcmp(must[t].verb,v) && !strcmp(must[t].object,o)) {
         strcat(must[t].subject," or ");
         strcat(must[t].subject,n);
         i=find_may(n,v,o);
         may[i].active=0; /* remove from may have list */
      }
  }
  for(t=0;t<must_pos;t++) {
    if(!strcmp(must[t].subject,n) && 
      !strcmp(must[t].verb,v) && 
         strcmp(must[t].object,o)) { /* not same object */
         strcat(must[t].object," or ");
         strcat(must[t].object,o);
         i=find_may(n,v,o);
         may[i].active=0; /* remove from may have list */
      }
  }
}






listing 7-3
/* Learning class descriptions using the
   "hit and near-miss" method */


#define MAX 100

struct attribute {
  char subject[80];
  char verb[80];
  char object[80];
  char active;
};

struct attribute may[MAX];   /* may-have database */
struct attribute must[MAX];  /* must-have database */

int may_pos=0; /* index into may-have database */
int must_pos=0; /* index into must-have database */

main()
{
  for(;;) {
    printf("(L)earn, (D)isplay, or (Q)uit?\n");
    switch(tolower(getch())) {
      case 'l': learn();
           break;
      case 'd': display();
           break;
      case 'q': exit();
    }
    printf("\n");
  }
}

/* learn a class description for an object */
learn()
{
  char sub[80], verb[80], obj[80];
  char msub[80], mverb[80], mobj[80];

  for(;;) {
    printf("Enter an example.\n");
    if(!get_example(sub,verb,obj)) {
      return;
    }
    if(find_may(sub,verb,obj)==-1) {
      assert_may(sub,verb,obj);
      generalize(sub,verb,obj); 
    }
    printf("Enter a near-miss (CR to skip).\n");
    get_example(msub,mverb,mobj);
    restrict(msub,mverb,mobj);
  }
}

/* place an entry into the may database */
assert_may(n,v,o)
char *n,*v,*o;
{
  if(may_pos<MAX) {
    strcpy(may[may_pos].subject,n);
    strcpy(may[may_pos].verb,v);
    strcpy(may[may_pos].object,o);
    may[may_pos].active=1;
    may_pos++;
  }
  else printf("out of memory\n");
}

/* place an entry into the must database */
assert_must(n,v,o)
char *n,*v,*o;
{
  if(must_pos<MAX) {
    strcpy(must[must_pos].subject,n);
    strcpy(must[must_pos].verb,v);
    strcpy(must[must_pos].object,o);
    must_pos++;
  }
  else printf("out of memory\n");
}

/* find an entry in the may database */
find_may(n,v,o)
char *n,*v,*o;
{
  register int t;

  for(t=0;t<may_pos;t++)
    if(!strcmp(may[t].subject,n) &&
      !strcmp(may[t].verb,v) && !strcmp(may[t].object,o) &&
        may[t].active)
         return t;

   return -1;
}

/* restrict the description of an object -
   i.e., remove from may_have list and place
   in must_have list.
*/
restrict(ms,mv,mo)
char *ms,*mv,*mo;
{
  register int t;
  char temp[4];
 
  for(t=0;t<3;t++) temp[t]=tolower(mv[t]);
  temp[3]='\0';
  if(strcmp(temp,"not")) return;

  for(t=0;t<may_pos;t++) {
    if(!strcmp(&mv[4],may[t].verb) && 
       !strcmp(may[t].subject,ms) && 
          !strcmp(may[t].object,mo) && may[t].active) {
      assert_must(may[t].subject,may[t].verb,may[t].object);
      may[t].active=0; /* remove from list */
      return;
    }
  }
}

/* generalize new examples */
generalize(n,v,o)
char *n,*v,*o;
{
  register int t,i;
  /* check may have list */

  for(t=0;t<may_pos;t++) {
    if(strcmp(may[t].subject,n) &&  /* not same subject */
      !strcmp(may[t].verb,v) && 
         !strcmp(may[t].object,o) && may[t].active) {
         strcat(may[t].subject," or ");
         strcat(may[t].subject,n);
       }
  }
  for(t=0;t<may_pos;t++) {
    if(!strcmp(may[t].subject,n) &&  
      !strcmp(may[t].verb,v) && 
         strcmp(may[t].object,o) /* not same object */
           && may[t].active) {
         strcat(may[t].object," or ");
         strcat(may[t].object,o);
       }
  }
  /* check must have list */
  for(t=0;t<must_pos;t++) {
    if(strcmp(must[t].subject,n) &&  /* not same subject */
      !strcmp(must[t].verb,v) && !strcmp(must[t].object,o)) {
         strcat(must[t].subject," or ");
         strcat(must[t].subject,n);
         i=find_may(n,v,o);
         may[i].active=0; /* remove from may have list */
      }
  }
  for(t=0;t<must_pos;t++) {
    if(!strcmp(must[t].subject,n) && 
      !strcmp(must[t].verb,v) && 
         strcmp(must[t].object,o)) { /* not same object */
         strcat(must[t].object," or ");
         strcat(must[t].object,o);
         i=find_may(n,v,o);
         may[i].active=0; /* remove from may have list */
      }
  }
}
        
/* input description */
get_example(n,v,o)
char *n,*v,*o;
{
  printf("\nsubject: ");
  gets(n);
  if(!*n) return 0;
  printf("verb: ");
  gets(v);
  printf("object: ");
  gets(o);
  return 1;
}

display()
{
  int t;

  printf("\nmay have:\n");
  for(t=0;t<may_pos;t++) {
    if(may[t].active)
      printf("  %s %s %s\n",may[t].subject, 
              may[t].verb, may[t].object);
  }
  printf("must have:\n");
  for(t=0;t<must_pos;t++) {
    printf("  %s %s %s\n",must[t].subject, 
            must[t].verb, must[t].object);
  }
}




