/*
The programs contained herein are adapted from 
Artificial Intelligence Using C by
Herbert Schildt published by Osborne/McGraw-Hill, Copyright
1987, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/


listing 9-1

/* Doctor #1 */

char *response[] = {
  "How are you?",
  "Did you have a happy childhood?",
  "Did you hate your father?",
  ""
};

char *trans[] = {
  "i","you",
  "you","I",
  "your","my",
  "my","your",
  "am","are",
  ""
};

char token[80];
char *p_pos;
int res=0; /* index into response array */

main()
{
  char s[80];

  printf("%s\n",response[res++]);

  do {
    printf(": ");
    p_pos=s;
    gets(s);
    if(!strcmp(s,"yes")) 
      printf("Ah...tell me more.\n");
    else if(!strcmp(s,"no")) 
      printf("Tell me more.\n");
    else if(!strcmp(s,"I hate you")) 
      printf("Why do you hate me?\n");
    else if(!*s) {
      if (!*response[res]) res=0; /* start over again */
      printf("%s\n",response[res++]);
    }
    else 
      respond();
  } while(strcmp(s,"by")); 
   
}

/* create the doctor's responses */
respond()
{
  char t[80];

  do {
    get_token();
    if(translate(token,t)) printf("%s ",t);
    else printf("%s ",token);
  } while(*token);
  printf("?\n");
}

/* translate context from the patient to the doctor */
translate(token,tr)
char *token,*tr;
{
  int t;

  t=0;
  while(*trans[t]) {
    if(!strcmp(trans[t],token)) {
      strcpy(tr,trans[t+1]);
      return 1;
    }
    t+=2;
  }

  return 0;
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*p_pos==' ') p_pos++;
 
  if(*p_pos=='\0') {  /* is end of input */
    *p++='\0';
    return;
  }
  if(is_in(*p_pos,",.!?")) {
    *p=*p_pos;
    p++, p_pos++;
    *p='\0';
    return;
  }

  /* read word until */
  while(*p_pos!=' ' && !is_in(*p_pos,".,;?!") && *p_pos)  {
    *p=tolower(*p_pos++);
    p++;
  }
  *p='\0';
}

is_in(c,s)
char c,*s;
{
  while(*s) {
    if(c==*s) return 1;
    s++;
  }
  return 0;
}





listing 9-2

#define MAX 100
#define SHORT 10
#define VERYSHORT 3

char *response[] = {
  "How are you?",
  "Did you have a happy childhood?",
  "Did you hate your father?",
  "I'm not sure I understand.",
  ""
};

char *trans[] = {
  "you","Let's not talk about me.",
  "think","Why do you think that?",
  "hate","So you hate something - tell me more.",
  "what","Why to you ask?",
  "want","Why do you want that?",
  "need","We all need many things - is this special?",
  "why","Remember, therapy is good for you.",
  "know","How do you know that?",
  "bye","Your bill will be mailed to you.",
  ""
};

char topics[MAX][80]; /* holds old topics */

char token[80];
char *p_pos;
int res=0; /* index into response array */
int head=0; /* head of topics queue */
int tail=0; /* tail of topics queue */






listing 9-3
/* create the doctor's responses */
respond(s)
char *s;
{
  char t[80];
  int loc;

  if(strlen(s)<VERYSHORT && strcmp(s,"by")) {
    if(find_topic(t)) {
      printf("You just said: ");
      printf("%s \n",t);
      printf("tell me more.\n");
    }
    else {
      if (!*response[res]) res=0; /* start over again */
      printf("%s\n",response[res++]);
    }
    return ;
  }

  if(strlen(s)>SHORT) assert_topic(s);

  do {
    get_token();
    loc=lookup(token);
    if(loc!=-1) {
      printf("%s\n",trans[loc+1]);
      return;
    }
  } while(*token);
  /* comment of last resort */
  printf("Tell me more...\n");
}






listing 9-4

/* Doctor #2  - includes key word lookup and
   previous topics queue.
*/

#define MAX 100
#define SHORT 10
#define VERYSHORT 3

char *response[] = {
  "How are you?",
  "Did you have a happy childhood?",
  "Did you hate your father?",
  "I not sure I understand.",
  ""
};

char *trans[] = {
  "you","Let's not talk about me.",
  "think","Why do you think that?",
  "hate","So you hate something - tell me more.",
  "what","Why to you ask?",
  "want","Why do you want that?",
  "need","We all need many things - is this special?",
  "why","Remember, therapy is good for you.",
  "know","How do you know that?",
  "bye","Your bill will be mailed to you.",
  ""
};

char topics[MAX][80]; /* holds old topics */

char token[80];
char *p_pos;
int res=0; /* index into response array */
int head=0; /* head of topics queue */
int tail=0; /* tail of topics queue */

main()
{
  char s[80];

  printf("%s\n",response[res++]);

  do {
    printf(": ");
    p_pos=s;
    gets(s);
    respond(s);
  } while(strcmp(s,"bye")); 
   
}

/* create the doctor's responses */
respond(s)
char *s;
{
  char t[80];
  int loc;

  if(strlen(s)<VERYSHORT && strcmp(s,"by")) {
    if(find_topic(t)) {
      printf("You just said: ");
      printf("%s \n",t);
      printf("Tell me more.\n");
    }
    else {
      if (!*response[res]) res=0; /* start over again */
      printf("%s\n",response[res++]);
    }
    return ;
  }

  if(strlen(s)>SHORT) assert_topic(s);

  do {
    get_token();
    loc=lookup(token);
    if(loc!=-1) {
      printf("%s\n",trans[loc+1]);
      return;
    }
  } while(*token);
  /* comment of last resort */
  printf("Tell me more...\n");
}

/* Lookup a key word in translation table */
lookup(token)
char *token;
{
  int t;

  t=0;
  while(*trans[t]) {
    if(!strcmp(trans[t],token)) return t;
    t+=2;
  }
  return -1;
}

/* place a topic into the topics database */
assert_topic(t)
char *t;
{
  if(head==MAX) head=0; /* wrap around */
  strcpy(topics[head],t);
  head++;
}

/* retrieve a topic */
find_topic(t)
char *t;
{
  if(tail!=head) {
    strcpy(t,topics[tail]);
    tail++;
    /* wrap around if necessary */
    if(tail==MAX) tail=0;
    return 1;
  }
  return 0;
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*p_pos==' ') p_pos++;
 
  if(*p_pos=='\0') {  /* is end of input */
    *p++='\0';
    return;
  }
  if(is_in(*p_pos,".!?")) {
    *p=*p_pos;
    p++, p_pos++;
    *p='\0';
    return;
  }

  /* read word until */
  while(*p_pos!=' ' && !is_in(*p_pos,".,;?!") && *p_pos)  {
    *p=tolower(*p_pos++);
    p++;
  }
  *p='\0';
}

is_in(c,s)
char c,*s;
{
  while(*s) {
    if(c==*s) return 1;
    s++;
  }
  return 0;
}





listing 9-5

char *trans[] = {
  "you","Let's not talk about me.",
  "think","Why do you think that?",
  "hate","So you hate something - tell me more.",
  "what","Why to you ask?",
  "want","Why do you want that?",
  "need","We all need many things - is this special?",
  "why","Remember, therapy is good for you.",
  "know","How do you know that?",
  "bye","Your bill will be mailed to you.",
  "murder","I don't like killing.",
  "kill","It is wrong to kill.",
  "jerk","Don't ever call me a jerk!",
  "can't","Don't be negative - be positive.",
  "failure","Strive for success.",
  "never","Don't be negative - be positive",
  "unhappy","Why are you unhappy?",
  ""
};






listing 9-6

  if(in_topics(s)) {
    printf("Stop repeating yourself!\n");
    return;
  }






listing 9-7

/* create the doctor's responses */
respond(s)
char *s;
{
  char t[80];
  int loc;

  if(strlen(s)<VERYSHORT && strcmp(s,"bye")) {
    if(find_topic(t)) {
      printf("You just said: ");
      printf("%s \n",t);
      printf("tell me more.\n");
    }
    else {
      if (!*response[res]) res=0; /* start over again */
      printf("%s\n",response[res++]);
    }
    return ;
  }

  if(in_topics(s)) {
    printf("Stop repeating yourself!\n");
    return;
  }

  if(strlen(s)>SHORT) assert_topic(s);

  do {
    get_token();
    loc=lookup(token);
    if(loc!=-1) {
      printf("%s\n",trans[loc+1]);
      return;
    }
  } while(*token);
  /* comment of last resort */
  printf("Tell me more...\n");
}

/* see if in topics queue */
in_topics(s)
char *s;
{
  int t;
 
  for(t=0;t<MAX;t++)
    if(!strcmp(s,topics[t])) return 1;

  return 0;
}






listing 9-8
/* Doctor #3 - optimistic and easily annoyed. */

#define MAX 100
#define SHORT 10
#define VERYSHORT 3

char *response[] = {
  "How are you this beautiful day?",
  "Did you have a happy childhood?",
  "Did you hate your father?",
  "I not sure I understand.",
  ""
};

char *trans[] = {
  "you","Let's not talk about me.",
  "think","Why do you think that?",
  "hate","So you hate something - tell me more.",
  "what","Why to you ask?",
  "want","Why do you want that?",
  "need","We all need many things - is this special?",
  "why","Remember, therapy is good for you.",
  "know","How do you know that?",
  "bye","Your bill will be mailed to you.",
  "murder","I don't like killing.",
  "kill","It is wrong to kill.",
  "jerk","Don't ever call me a jerk!",
  "can't","Don't be negative - be positive.",
  "failure","Strive for success.",
  "never","Don't be negative - be positive",
  "unhappy","Why are you unhappy?",
  ""
};

char topics[MAX][80]; /* holds old topics */

char token[80];
char *p_pos;
int res=0; /* index into response array */
int head=0; /* head of topics queue */
int tail=0; /* tail of topics queue */

main()
{
  char s[80];

  printf("%s\n",response[res++]);

  do {
    printf(": ");
    p_pos=s;
    gets(s);
    respond(s);
  } while(strcmp(s,"bye")); 
   
}

/* create the doctor's responses */
respond(s)
char *s;
{
  char t[80];
  int loc;

  if(strlen(s)<VERYSHORT && strcmp(s,"bye")) {
    if(find_topic(t)) {
      printf("You just said: ");
      printf("%s \n",t);
      printf("tell me more.\n");
    }
    else {
      if (!*response[res]) res=0; /* start over again */
      printf("%s\n",response[res++]);
    }
    return ;
  }

  if(in_topics(s)) {
    printf("Stop repeating yourself!\n");
    return;
  }

  if(strlen(s)>SHORT) assert_topic(s);

  do {
    get_token();
    loc=lookup(token);
    if(loc!=-1) {
      printf("%s\n",trans[loc+1]);
      return;
    }
  } while(*token);
  /* comment of last resort */
  printf("Tell me more...\n");
}

/* Lookup a key word in translation table */
lookup(token)
char *token;
{
  int t;

  t=0;
  while(*trans[t]) {
    if(!strcmp(trans[t],token)) return t;
    t++;
  }
  return -1;
}

/* place a topic into the topics database */
assert_topic(t)
char *t;
{
  if(head==MAX) head=0; /* wrap around */
  strcpy(topics[head],t);
  head++;
}

/* retrieve a topic */
find_topic(t)
char *t;
{
  if(tail!=head) {
    strcpy(t,topics[tail]);
    tail++;
    /* wrap around if necessary */
    if(tail==MAX) tail=0;
    return 1;
  }
  return 0;
}

/* see if in topics queue */
in_topics(s)
char *s;
{
  int t;
 
  for(t=0;t<MAX;t++)
    if(!strcmp(s,topics[t])) return 1;

  return 0;
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*p_pos==' ') p_pos++;
 
  if(*p_pos=='\0') {  /* is end of input */
    *p++='\0';
    return;
  }
  if(is_in(*p_pos,".!?")) {
    *p=*p_pos;
    p++, p_pos++;
    *p='\0';
    return;
  }

  /* read word until */
  while(*p_pos!=' ' && !is_in(*p_pos,".,;?!") && *p_pos)  {
    *p=tolower(*p_pos++);
    p++;
  }
  *p='\0';
}

is_in(c,s)
char c,*s;
{
  while(*s) {
    if(c==*s) return 1;
    s++;
  }
  return 0;
}




