/* Disk handling module for networks				*/
/* TC 2.0	E.FARHI		SAVERES.C			*/

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	*/
/*			VERSION 0.2				*/
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
version		0.1	01/92	first version
		0.2	05/92	UNIX standard commmands */

/* ------------------------------------------------------------	*/

#include <string.h>     /* for strcpy                          */
#include <stdio.h>	/* disk commands */

#define READWRITE 0                     /* for file manip  */
#define AUTOSAVE 1			
#define NORMSAVE 0			
#define AUTOLOAD 1			
#define NORMLOAD 0			

/* ------------------------------------------------------------	*/

int   save_network(NETWORKS *,char);
NETWORKS *load_network(char);

int filename(char[]);	/* asks entire name */

/* ------------------------------------------------------------ */
/* 		File handling			 		*/
/* ------------------------------------------------------------ */

int save_network(NETWORKS *network,char flag)
{       /* if flag=1 saves directly NET00.NET */
  char fname[80];
  FILE *file;

  if (flag)
  {
    strcpy(fname,"NET00.NET");
    printf("\nSaving NET00.NET");
  }
  else                          
    filename(fname);   /* file selector */
  file=fopen(fname,"wb");
  if (file == NULL)
    {
      printf("\n\aFile opening error !");
      return(-1);
    }
  else
    {
      printf("\nWriting : %i object transfered",
		fwrite((void *)network,sizeof(NETWORKS),1,file));
      fclose(file);
    }
  return(1);
}


NETWORKS *load_network(char flag)
{
  FILE *file;
  char fname[80];       /* for file name */
  void *network;

  network=(void *)malloc(sizeof(NETWORKS));
  if (network == NULL)	/* is there any room ? */
  {
    printf("Not enough memory. Sorry NetWork too large");
    return(NULL);
  }

  if (flag)
  {
    strcpy(fname,"NET00.NET");
    printf("\nLoading file NET00.NET");
  }
  else                        
    filename(fname);   /* file selector */
  file=fopen(fname,"rb");
  if (file == NULL)
    {
      printf("\n\aFile Opening Error !");
      return(NULL);
    }
  else
    {
      printf("\nReading: %i object transfered.",
		fread((void *)network,sizeof(NETWORKS),1,file));
      fclose(file);
    }
  printf("\n <RETURN>");getchar();
  return(network);
}

/* -----------------------------------------------------------	*/

int filename(affichage)
    char affichage[];
{
  char fnam[13];

  printf("\nName of file (extension *.NET): ");
  scanf("%s",fnam);

  strcpy(affichage,fnam);
  return(1);
}