'  -- Crc16.BAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFWRD A-Z

DIM CrcTable(256) AS SHARED WORD
DIM Initialized   AS SHARED BYTE

' calculate Crc table entry

FUNCTION CalcTable(BYVAL Octet   AS WORD, _
                   BYVAL GenPoly AS WORD, _
                   BYVAL Accum   AS WORD) PRIVATE
  DIM I AS INTEGER
  DIM J AS INTEGER

  SHIFT LEFT Octet,8

  FOR J = 1 TO 8
    I = 9 - J
    IF ( (Octet XOR Accum) AND &H8000) THEN
      SHIFT LEFT Accum,1
      Accum = Accum XOR GenPoly
    ELSE
      SHIFT LEFT Accum,1
    END IF
    SHIFT LEFT Octet,1
  NEXT J
  CalcTable = Accum

END FUNCTION

' initialize Crc table

SUB InitCrc() PRIVATE

  DIM I AS INTEGER

  Initialized = 1              'only need to do this once

  FOR I = 0 to 255
    CrcTable(I) = CalcTable(I,&H1021,0)
  NEXT I

  PRINT "CRC-16 Table Built"

END SUB
                                                                           
' compute updated Crc

FUNCTION UpdateCrc16(BYVAL Octet AS BYTE, _
                     BYVAL Crc   AS WORD) PUBLIC
  DIM LeftShifted  AS WORD
  DIM RightShifted AS WORD

  IF Initialized = 0 THEN
    CALL InitCrc
  END IF

  'compute CRC-16
  LeftShifted = Crc
  SHIFT LEFT LeftShifted,8
  RightShifted = Crc
  SHIFT RIGHT RightShifted,8
  UpDateCrc16 = CrcTable(RightShifted AND 255) XOR LeftShifted XOR Octet

END FUNCTION

' compute updated CRC (2nd flavor)

FUNCTION UpdateCRC(BYVAL Octet AS BYTE, _
                   BYVAL CRC   AS WORD) PUBLIC
  DIM LeftShifted  AS WORD
  DIM RightShifted AS WORD

  IF Initialized = 0 THEN
    InitCRC
  END IF

  'compute CRC
  LeftShifted = CRC
  SHIFT LEFT LeftShifted,8
  RightShifted = CRC
  SHIFT RIGHT RightShifted,8
  UpDateCRC = LeftShifted XOR ( CRCtable( RightShifted XOR Octet) )
END FUNCTION
