/*
 *	Get/Set DASD functions
 *
 *	getdasd() returns:	00 - drive not present
 *				01 - diskette, no change line
 *				02 - diskette, change line available
 *				03 - fixed disk
 *
 *	setdasd() accepts a drive and type. The type is:
 *				00 - not used
 *				01 - 320/360 diskette in 320/360 drive
 *				02 - 320/360 diskette in 1.2M drive
 *				03 - 1.2M diskette in 1.2M drive					
 */

#include <stdio.h>
#include <dos.h>
#include "fdc.h"

int getdasd(int drive)
{

	extern int errno;
	struct REGVAL r;

	r.ax = READDASD;
	r.dx = drive;
	if(sysint(DISKINT, &r, &r) & 1) {
		errno = (int)(r.ax >> 8);
		return(-1);
	} else {
		return(r.ax & 0xff);
	}
}

int setdasd(int drive, int type)
{
	extern int errno;
	struct REGVAL r;

	r.ax = SETDASD | type;
	r.dx = drive;
	if(sysint(DISKINT, &r, &r) & 1) {
		errno = (int)(r.ax >> 8);
		return(-1);
	} else {
		return(0);
	}
}
