/* header file for fast diskcopy */

/* defines for INT 13 */

#define DISKINT  0x13

#define DISKRESET 0x0000
#define READSTATUS 0x0100
#define READSECS   0x0200
#define WRITESECS  0x0300
#define VERIFYTR   0x0400
#define FORMATTR   0x0500
#define READDASD 0x1500
#define SETDASD  0x1700

#define MAXSECT 26
#define MAXDRIVES 2

/* struct tag for get allocation type info  */

struct ati {
	char media_type;
	int sector_au;
	unsigned int au;
	int sector_size;
};

/*	defines for DISK_POINTER, the pointer to the disk parameter blocks */

#define DSK_PTR_SEG 0
#define DSK_PTR_OFF 78

/* struct tag for disk paramter block */
struct dpb {
	char first;
	char second;
	char motor_wait_off;
	char sector_type;
	char gap_length;
	char eot;
	char dtl;
	char format_gap_length;
	char fill_byte;
	char head_settle_time;
	char motor_start_time;
};


/* 
 * prototypes for functions 
 */

struct ati *getati(int drive);
int getdasd(int drive);
int setdasd(int drive, int type);
int fmtrack(int drive, int head, int track, int max_sect, int sect_type);
int rdtrack(int drive, int head, int track, int start_sect, int max_sect, 
	char *buf);
int wrtrack(int drive, int head, int track, int start_sect, int max_sect, 
	char *buf);

