/*
 *	Track format function
 *
 *	This routine formats a track on a floppy diskette
 *	The parameters are:
 *		drive: 01 = A:, 02 = B, etc.
 *		head: 0 - 1 (same as cylinder)
 *		max_sect: maximum sectors (8/9/15)
 *		sect_type: sector type
 *			00 = 128 bytes per sector
 *			01 = 256 bytes per sector
 *			02 = 512 bytes per sector
 *			03 = 1024 bytes per sector
 *
 *	Prior to the first invocation of this function on a diskette,
 *	setdasd() must be called to establish the type of diskette in
 *	the appropriate type of drive.
 *
 * If formatting a 320/360K in either a 320/360 or 1.2M drive in an AT,
 * setdpb() must be called with the format gap length set to 050H.
 * Additionally, the EOT parameter must be set to the maximum number of
 * sectors for the track (8/9).
 *
 */

#include <stdio.h>
#include <dos.h>
#include "fdc.h"

int fmtrack(int drive, int head, int track, int max_sect, int sect_type)
{

	int i;
	int times = 0;
	static char fmtparm[4 * MAXSECT];
	struct REGVAL r;
	extern int errno;
	
	for (i = 0; i < max_sect; ++i) {	/* fill format fields */
		fmtparm[i * 4] = track;
		fmtparm[i * 4 + 1] = head;
		fmtparm[i * 4 + 2] = i + 1;
		fmtparm[i * 4 + 3] = sect_type;
	}
	for (i = 0; i < 4; ++i)		  	/* end with four 0's */
		fmtparm[(max_sect  * 4) + i] = 0;

	r.ax = FORMATTR | max_sect;
	r.es = getds();
	r.bx = fmtparm;
	r.cx = (track << 8);
	r.dx = (head << 8) | drive;
	do {				/* do it a max of three times */
		if(sysint(DISKINT, &r, &r) & 1) 
			++times;
		else {
			times = 0;		
			break;
		}
	} while (times < 4);
	if (!times) 
		return(0);
	else {
		errno = (int)(r.ax >> 8);
		return(-1);
	}

}		
