/*
 *	Get ATI (allocation table information) function
 *
 * 	Accepts a disk drive number: 0 = current, 1 = A:, 2 = B, etc.
 * 	Returns a pointer to struct ati with the allocation table information.
 * 	Subsequent calls to getati() destories the static information 
 *	from the previous call.
 */

#include <stdio.h>
#include <dos.h>
#include "fdc.h"

#define GETATIFN 0x1c00

struct ati *getati(int drive)
{

	extern int errno;
	static struct ati retinfo;
	struct REGVAL r;

	r.ax = GETATIFN;
	r.dx = drive;
	sysint21(&r, &r);
	retinfo.media_type = peek(r.ds, r.bx) & 0xff;
	retinfo.sector_au =  (int)(r.ax & 0xff);
	retinfo.au = r.dx;
	retinfo.sector_size = (int)r.cx;
	return(&retinfo);

}



