/*
 *	DOS INT read/write track routine
 *
 * 	Reads/writes a floppy disk track
 *
 * 	Accepts:	drive: 0 = A:, 1 = B:
 *			head: 0 / 1
 *			start_sect: starting sector 
 *			max_sect: maximum # of sectors to read/write
 *			buf: pointer to buffer holding information
 *			start_sect and max_sect can be 1 - 8, 1 - 9, 1 - 15
 *				
 *	Returns 0 if successful, -1 on error with errno set to DOS return 
 *	code.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "fdc.h"

int rdtrack(int drive, int head, int track, int start_sect, int max_sect, 
	char *buf)
{

	struct REGVAL r;
	extern int errno;

	r.ax = READSECS | max_sect;
	r.cx = (track << 8) | start_sect;
	r.dx = (head << 8) | drive;
	r.es = getds();
	r.bx = (unsigned int)buf;
	if (sysint(DISKINT, &r, &r) & 1) {
		errno = (int)(r.ax >> 8);
		return(-1);
	} else
		return(0);
}

int wrtrack(int drive, int head, int track, int start_sect, int max_sect, 
	char *buf)
{

	struct REGVAL r;
	extern int errno;

	r.ax = WRITESECS | max_sect;
	r.cx = (track << 8) | start_sect;
	r.dx = (head << 8) | drive;
	r.es = getds();
	r.bx = (unsigned int)buf;
	if (sysint(DISKINT, &r, &r) & 1) {
		errno = (int)(r.ax >> 8);
		return(-1);
	} else
		return(0);
}


