/*	get & restore disk parameter blocks 
 *
 */

#include <stdio.h>
#include "fdc.h"

struct dpb dsk_p_blk[MAXDRIVES];		/* disk parameter block for a: & b */

static int org_dpb_offset, org_dpb_segment;

int setdbp()	/* sets DISK_POINTER to our dpbs */
{		/* return # of drives with dpbs (1 or 2) */

	int i;
	char *p;

	org_dpb_offset = peek(DSK_PTR_SEG, DSK_PTR_OFF);			/* get dpb offset */
	org_dpb_segment = peek(DSK_PTR_SEG, DSK_PTR_OFF + 2);	/* get dpb segment */

	p = dsk_p_blk;
	for(i = 0; i < (sizeof(struct dpb) * MAXDRIVES); ++org_dpb_offset)
		*p++ = peek(org_dpb_segment, org_dpb_offset);
	poke(DSK_PTR_SEG, DSK_PTR_OFF, getds());
	poke(DSK_PTR_SEG, DSK_PTR_OFF + 2, dsk_p_blk);
	return(dsk_p_blk[0].first);

}

int restoredpb()		/* restores DISK_POINTER to original dbps */
{
	poke(DSK_PTR_SEG, DSK_PTR_OFF, org_dpb_offset);
	poke(DSK_PTR_SEG, DSK_PTR_OFF + 2, org_dpb_segment);
}


	 


