/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|             'Extending File Handles' Example                 |*/
/*|          Valid ONLY with DOS version 3.3 or greater          |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <alloc.h>

                       /* you have 5 handles less than this number */
                       /* therefore this number MUST be >= 5 ! */
                       /* the limit now is the FILES= in config.sys (max=255) */
#define MAX_HANDLES 49



unsigned int _openfd[MAX_HANDLES];  /* THIS MUST BE GLOBAL!!! */

void set_up (void);

#pragma startup set_up 64  /* makes the start-up code call this function */
                           /* can also be called directly, as the first
                              thing in main. */


int main (void)
{
  unsigned fh[MAX_HANDLES];   /* this is needed only for this demo */
  int j, k;
  char name[15];
  char far *ptr;

  printf ("\n----------------------------------------------------------------\n");
  for (j=0;j<MAX_HANDLES -5; j++)
  {
    sprintf (name, "test%02d.&&&", j);  /* create unique filename */

    if (( fh[j] = open (name, O_WRONLY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == (unsigned)-1)
    {                                   /* open the file */
      perror ("\nOpen failed");
      printf ("\nFile handle number: %d\n", j);
      break;
    }
    else
      printf (" %02d ", j);
  }

  printf ("\n\nNumber of files succsessfuly opened: %d\n", j);

  printf ("----------------------------------------------------------------\n");
  if ((ptr = (char far *)farmalloc (0xF000)) == NULL)
              /* allocate a block of memory to prove that the file
                 handle's MCB is not right on our tail.
              */
  {
    perror ("Malloc failed");  /* Not enough room for the block of data.
                                  It could be the file handle's MCB, or
                                  we might just be flat out of memory.
                               */

  }
  else
  {
    printf ("Dynamic allocation successful.\n");
    farfree ((void far *)ptr); 
  }

  

  printf ("Farcoreleft: %lu\n", farcoreleft ());
                               /* display the distance from the highest
                                  allocated block to the top of the heap.
                               */
  printf ("----------------------------------------------------------------\n");
  

  for (k = 0; k < j;k++)
  {
    if (_close (fh[k]) != 0)  /* close the files */
    {
      perror ("\nClose failed");
      printf ("\nFile handle number: %d\n", k);
      break;
    }
    else
      printf (" %02d ", k);
  }

  printf ("\n\nNumber of files succsessfuly closed: %d\n", k);
          
  printf ("----------------------------------------------------------------\n");

  return 0;
}

void set_up (void)
{
/*  You must set DOS's allocation strategy to LAST_FIT before you set
    the handle count if you want to do any dynamic allocation during
    the life of your program.  Also, for other programs to behave
    properly afterwords, you should set it back to FIRST_FIT.

    We then call DOS's 'set handle count' function to set the maximum
    number of file handles.  Because this number will normally be
    greater than 20, (and the default area in the PSP can only hold 20)
    DOS allocates another MCB (memory control block) to hold the table.
    If, the strategy is set to FIRST_FIT, DOS allocates the MCB directly
    after your program's MCB.  If you call malloc to allocate something,
    it won't be able to (because malloc will try to re-size your program's
    MCB and cannot because this other MCB is right after it).  When the
    strategy is LAST_FIT, DOS allocates the file handle's MCB at the
    high end of memory, thus allowing your program's MCB to grow when
    necessary.

    The array _openfd[] is an internal table of the handles that is used
    by open, close, _open, and _close.  The first 5 must be set up to
    have the proper attributes and modes for the pre-opened files
    (stdin, stdout, stdprn, stdaux, stderr).  This is normally
    hard-coded with 20 entries in the run-time-library.  By declaring it
    globally in this program, the linker ignores the pre-defined version
    and uses ours instead.
    
*/



  int j;

  /* initialize table of handles and the first five reserved ones */

  _openfd[0] = O_RDONLY | O_DEVICE;
  _openfd[1] = O_WRONLY | O_DEVICE;
  _openfd[2] = O_WRONLY | O_DEVICE;
  _openfd[3] = O_RDWR   | O_DEVICE | O_BINARY;
  _openfd[4] = O_WRONLY | O_DEVICE | O_BINARY;

  /*------------------------------------------------------------------*/

  for (j = 5; j < MAX_HANDLES; j++)
    _openfd[j] = ~0;  /* set all the rest to 0xFF */

  /* DOS func 58h  set allocation strategy to LAST_FIT */

  /* FIRST_FIT  - 00h
     BEST_FIT   - 01h
     LAST_FIT   - 02h
  */

  _AH = 0x58;
  _AL = 1;     /* set allocation */
  _BX = 2;

  geninterrupt (0x21);   /* call DOS */

  /*------------------------------------------------------------------*/

  /* DOS func 67h  set handle count.  This is only available in DOS 3.3
     or greater.
  */

  _AH = 0x67;
  _BX = MAX_HANDLES;

  geninterrupt (0x21);  /* call DOS */

  /* DOS func 58h  set allocation strategy to FIRST_FIT */

  _AH = 0x58;
  _AL = 1;     /* set allocation */
  _BX = 0;

  geninterrupt (0x21);   /* call DOS */

}
