       /*============================================================*/
       /* AUTHOR:   Jim Rickman                                      */
       /* DATE:     January 1992                                     */
       /* PROGRAM:  year.c                                           */
       /*                                                            */
       /* PURPOSE:  Output a Fiscal Calendar for the specified year. */
       /*============================================================*/

/*---------------*/
/* Include files */
/*---------------*/
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
 
/*-------------*/
/* Definitions */
/*-------------*/
#define TITLE     "  F I S C A L   C A L E N D A R  "
#define TOP_BORDER    "Ŀ Ŀ"
#define DAY_HDR       "       M   T   W   T   F   S   S           M   T   W   T   F   S   S   "
#define MNTH_HDR      "MonthĴF  MonthĴF "
#define FRST_QTR      "            FIRST   QUARTER       W             THIRD   QUARTER       W"
#define SCND_QTR      "            SECOND  QUARTER       W             FOURTH  QUARTER       W"
#define SEP_MONTH     "Ĵ Ĵ"
#define BOTTOM_BORDER " "


/*------------------------------------------------------------------*/
/* Number of days for the months of year -- non-leap and leap years */
/*------------------------------------------------------------------*/
static int day_tab[2][13] = { { 0,31,28,31,30,31,30,31,31,30,31,30,31 },
                              { 0,31,29,31,30,31,30,31,31,30,31,30,31 } };
/*------------------------*/
/* Other Global Variables */
/*-------------------------------------------------------------------------*/
struct tm T;    /* If User does NOT specify a Year, use current year       */
time_t Timer;   /* If User does NOT specify a Year, use current year       */
int year;       /* The current or User-specified year                      */
int num_days;   /* Determined by the what_day() function                   */
int day_a;      /* Day value for January 1st                               */
int day_b;      /* Day value for July 1st                                  */
int num_a;      /* Current day value for January through June              */
int num_b;      /* Current day value for July through December             */
int tot_a;      /* Total number of days in a month (January through June)  */
int tot_b;      /* Total number of days in a month (July through December) */
int leap;       /* 0 = Non-Leap Year;  1 = Leap Year                       */
int fw_a;       /* Current Fiscal Week value (January through June)        */
int fw_b;       /* Current Fiscal Week value (July through December)       */
int mnth_a;     /* Current Month value (January through June)              */
int mnth_b;     /* Current Month value (July through December)             */
int lines;      /* Current line number                                     */
int dec_wks;    /* Number of weeks (5 or 6) in December of specified year  */
                /*---------------------------------------------------------*/


/*------------------*/
/* The MAIN Routine */
/*------------------*/
main (int argc, char *argv[])
{
    int i;      /* Loop counter                                            */
 
    /*------------------------------------------*/
    /* No year parameter given; do current year */
    /*------------------------------------------*/
    if (argc == 1)
    {
        time (&Timer);
        T = *(localtime (&Timer));
        year = T.tm_year + 1900;                   /* For the 20th Century */
    }
 
    /*---------------------------*/
    /* The user specified a year */
    /*---------------------------*/
    if (argc > 1)
    {
        year = atoi (argv[1]);
        if (year < 1753  ||  year > 3999)
        {
            syntax ();  exit (1);
        }
    }
 
    /*----------------------------------------------------------------*/
    /* Determine what day January 1st of the following year falls on. */
    /* If Jan 1st of the following year falls on a Friday, there are  */
    /* 53 Fiscal Weeks in the year and the month of December has six  */
    /* Fiscal Weeks.                                                  */
    /*----------------------------------------------------------------*/
    year++;  what_day (1);
    if (num_days == 5)
        dec_wks = 6;
    else
        dec_wks = 5;
    year--;
 
    /*---------------------*/
    /* Is it a leap year ? */
    /*---------------------*/
    leap = year % 4 == 0  &&  year % 100 != 0  ||  year % 400 == 0;
 
    /*-------------------------*/
    /* Output the header lines */
    /*-------------------------*/
    printf ("\n                %d  %s  %d\n\n", year, TITLE, year);
    printf ("%s\n%s\n%s\n%s\n%s\n", TOP_BORDER,
                                    DAY_HDR,
                                    MNTH_HDR,
                                    FRST_QTR,
                                    SEP_MONTH);
 
    /*-----------------------------------------------------------------*/
    /* Output the first weeks of January and July.  Once this is done, */
    /* we can output the rest of the year using a loop.                */
    /*-----------------------------------------------------------------*/
    lines = 8;
    /*----------------------------------------------------------*/
    /* Determine the day for January 1st of the specified year: */
    /*----------------------------------------------------------*/
    mnth_a = 1;  what_day (mnth_a);
    /*-----------------------------------------------------------*/
    /* January 1st is on a Monday -- we need to output the first */
    /* week of July locally and NOT via the out_30() function.   */
    /*-----------------------------------------------------------*/
    if (num_days == 1)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("       1   2   3   4   5   6   7 ");
        day_a = 8;   fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("       2   3   4   5   6   7   8 ");
            day_b = 9;  fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("       1   2   3   4   5   6   7 ");
            day_b = 8;  fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*-----------------------------*/
    /* January 1st is on a Tuesday */
    /*-----------------------------*/
    if (num_days == 2  &&  leap == 0)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("      31   1   2   3   4   5   6 ");
        day_a = 7;   fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("       1   2   3   4   5   6   7 ");
            day_b = 8;   fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("      30   1   2   3   4   5   6 ");
            day_b = 7;   fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*-------------------------------*/
    /* January 1st is on a Wednesday */
    /*-------------------------------*/
    if (num_days == 3)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("      29  30   1   2   3   4   5 ");
        day_a = 6;   fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("      30   1   2   3   4   5   6 ");
            day_b = 7;   fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("      29  30   1   2   3   4   5 ");
            day_b = 6;   fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*------------------------------*/
    /* January 1st is on a Thursday */
    /*------------------------------*/
    if (num_days == 4)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("      29  30  31   1   2   3   4 ");
        day_a = 5;   fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("      29  30   1   2   3   4   5 ");
            day_b = 6;   fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("      28  29  30   1   2   3   4 ");
            day_b = 5;   fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*----------------------------*/
    /* January 1st is on a Friday */
    /*----------------------------*/
    if (num_days == 5)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("       4   5   6   7   8   9  10 ");
        day_a = 11;  fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("       5   6   7   8   9  10  11 ");
            day_b = 12;   fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("       4   5   6   7   8   9  10 ");
            day_b = 11;   fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*------------------------------*/
    /* January 1st is on a Saturday */
    /*------------------------------*/
    if (num_days == 6)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("       3   4   5   6   7   8   9 ");
        day_a = 10;  fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("       4   5   6   7   8   9  10 ");
            day_b = 11;  fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap == 1)
        {
            printf ("       3   4   5   6   7   8   9 ");
            day_b = 10;   fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    /*----------------------------*/
    /* January 1st is on a Sunday */
    /*----------------------------*/
    if (num_days == 7)
    {
        /*----------------------------------*/
        /* Output the first week of January */
        /*----------------------------------*/
        printf ("       2   3   4   5   6   7   8 ");
        day_a = 9;   fw_a = 1;  printf ("%2d ", fw_a);
        /*-------------------------------*/
        /* Output the first week of July */
        /*-------------------------------*/
        if (leap == 0)
        {
            printf ("       3   4   5   6   7   8   9 ");
            day_b = 10;   fw_b = 27;  printf ("%2d", fw_b);
        }
        if (leap ==  1)
        {
            printf ("       2   3   4   5   6   7   8 ");
            day_b = 9;  fw_b = 27;  printf ("%2d", fw_b);
        }
    }
    mnth_b = 7;  next_line ();
 
    /*-------------------------------------------*/
    /* Set the variables to their correct values */
    /* before proceeding to the loop.            */
    /*-------------------------------------------*/
    num_a = day_a;  num_b = day_b;  tot_a = 31;  tot_b = 31;
 
    /*-------------------------------------------------------*/
    /* The loop that outputs the rest of the Fiscal Calendar */
    /*-------------------------------------------------------*/
    do
    {   /*-----------------------------------*/
        /* Increment the Fiscal Week numbers */
        /*-----------------------------------*/
        fw_a++;  fw_b++;
        if (fw_b == 53  &&  dec_wks == 5)
            fw_b = 1;
        if (fw_a > 52)
            fw_a = 1;
        for (i=0; i<7; i++, num_a++)
        {
            if (fw_a == 27)
                printf ("    ");
            if (num_a <= tot_a  &&  fw_a < 27)
                printf (" %2d ", num_a);
            if (num_a > tot_a  &&  fw_a < 27)
            {
                num_a = 1;  printf (" %2d ", num_a);
                mnth_a++;
                if (mnth_a == 2 && leap == 0)
                    tot_a = 28;
                if (mnth_a == 2 && leap == 1)
                    tot_a = 29;
                if (mnth_a == 3 || mnth_a  == 5)
                    tot_a = 31;
                if (mnth_a == 4 || mnth_a  == 6)
                    tot_a = 30;
            }
        }
        if (fw_a == 27)
            printf ("   ");
        if (fw_a != 27)
            printf ("%2d ", fw_a);
 
        next_half ();
        for (i=0; i<7; i++, num_b++)
        {
            if (num_b <= tot_b)
                printf (" %2d ", num_b);
            if (num_b > tot_b)
            {
                num_b = 1;  printf (" %2d ", num_b);
                mnth_b++;
                if (mnth_b == 7 || mnth_b  == 8 || mnth_b == 10 || mnth_b == 12)
                    tot_b = 31;
                if (mnth_b == 9 || mnth_b  == 11)
                    tot_b = 30;
            }
        }
        printf ("%2d", fw_b);
        next_line ();
    }
    while (lines < 42);

    /*-----------------------*/
    /* Terminate the Program */
    /*-----------------------*/
    exit (0);
}
 
 
/*-------------------------------------------*/
/* Routine to Output the YEAR command Syntax */
/*-------------------------------------------*/
syntax ()
{
    fprintf (stderr, "\nCommand Syntax:  YEAR [year]");
    fprintf (stderr, "\n                 where 'year' is between 1753 and 3999 inclusive.\n");
}
 
 
/*-----------------------------------------------------------------*/
/* Routine to Calculate the Day-Of-Year number  ( 1 -> 365 / 366 ) */
/*-----------------------------------------------------------------*/
day_of_year (int mm, int dd)
{
    int i;      /* Loop counter                                            */
 
    for (i = 1;  i < mm;  i++)
        dd += day_tab[leap][i];
 
    return (dd);
}
 
 
/*----------------------------------------------------------------------*/
/* Routine to Determine the Day Name for the 1st Day of specified Month */
/*----------------------------------------------------------------------*/
what_day (int mnth)
{
    num_days = year + ((year + 3) / 4);
    num_days -= (year - 1701) / 100;
    num_days += (year - 1601) / 400;
    num_days += day_of_year (mnth, 1);
    num_days %= 7;  num_days--;
    if (num_days <= 0)
        num_days = num_days + 7;
}
 
 
/*-----------------------------*/
/* Routine to start a NEW Line */
/*-----------------------------*/
next_line ()
{
    lines++;
    if (lines == 9)
        printf ("\n JAN ");
    if (lines == 14)
        printf ("\n FEB ");
    if (lines == 19)
        printf ("\n MAR ");
    if (lines == 27)
        printf ("\n APR ");
    if (lines == 32)
        printf ("\n MAY ");
    if (lines == 37)
        printf ("\n JUN ");
    if (lines == 11)
        printf ("\n4 wks");
    if (lines == 16)
        printf ("\n4 wks");
    if (lines == 21)
        printf ("\n5 wks");
    if (lines == 29)
        printf ("\n4 wks");
    if (lines == 34)
        printf ("\n4 wks");
    if (lines == 39)
        printf ("\n5 wks");
    if (lines == 12 || lines == 17 || lines == 30 || lines == 35)
    {
        printf ("\n%s", SEP_MONTH);  lines++;
    }
    if (lines == 23)
        lines++;
    if (lines == 24)
    {
        printf ("\n%s\n%s\n%s\n%s\n%s\n%s", BOTTOM_BORDER,
                                            TOP_BORDER,
                                            DAY_HDR,
                                            MNTH_HDR,
                                            SCND_QTR,
                                            SEP_MONTH);
        lines++;  lines++;
    }
    if (lines == 10 || lines == 13 || lines == 15 || lines == 18 ||
        lines == 20 || lines == 22 || lines == 26 || lines == 28 ||
        lines == 31 || lines == 33 || lines == 36 || lines == 38 ||
        lines == 40 || lines == 41)
        printf ("\n     ");
    if (lines == 42)
        printf ("\n%s\n", BOTTOM_BORDER);
}
 
 
/*------------------------------------------------------*/
/* Routine to start the second half of the CURRENT line */
/*------------------------------------------------------*/
next_half ()
{
    if (lines == 9)
        printf (" JUL ");
    else if (lines == 14)
        printf (" AUG ");
    else if (lines == 19)
        printf (" SEP ");
    else if (lines == 27)
        printf (" OCT ");
    else if (lines == 32)
        printf (" NOV ");
    else if (lines == 37)
        printf (" DEC ");
    else if (lines == 11)
        printf ("4 wks");
    else if (lines == 16)
        printf ("4 wks");
    else if (lines == 21)
        printf ("5 wks");
    else if (lines == 29)
        printf ("4 wks");
    else if (lines == 34)
        printf ("4 wks");
    else if (lines == 39  &&  dec_wks == 5)
        printf ("5 wks");
    else if (lines == 39  &&  dec_wks == 6)
        printf ("6 wks");
    else
        printf ("     ");
}
