#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <ctype.h>
#include <time.h>

/* hell.c
 * 
 * Print a quotation from Life in Hell.
 * Qux <Kaufman-David@Yale> March 6, 1986
 * Edited (with appropriate credit given)
 * um.cc.umich.edu July 18, 1991
 */

#define BUFSIZE  2000
#define SEP      '|'

void hell(FILE *fp);

void main(void)
{
  FILE *fp;
  char *file;
  unsigned int seed;

  /* try to find GROENING quotes filename in environment.  If not found, default to
     file called "groening" in current directory. */

  if ((file=getenv("HELL"))==NULL) file="groening";

  if ((fp = fopen(file, "r")) == NULL) {
    fprintf(stderr, "Hell!  Can't open quotes file %s\n", file);
    exit(1);
  }

  /* initialize random seed from clock */
  seed = (unsigned int) (time(NULL) - ((time(NULL) / 86400L) * 86400L));
  srand(seed);

  hell(fp);
  fclose(fp);
  exit(0);
}

void hell (FILE *fp)
{
  static long len = -1;
  long offset;
  int c, i = 0;
  char buf[BUFSIZE];

  /* Get length of file, go to a random place in it */
  if (len == -1) {
    if (fseek(fp, 0L, 2) == -1) {
      fprintf(stderr, "Hell!  fseek 1 failed");
      exit(1);
    }
    len = ftell(fp);
  }
  offset = rand();
  while(offset > len) offset -= len;
  if (fseek(fp, offset, 0) == -1) {
    fprintf(stderr, "Hell!  fseek 2 failed");
    exit(1);
  }

  /* Read until SEP, read next line, print it.
     (Note that we will never print anything before the first seperator.)
     If we hit EOF looking for the first SEP, just recurse. */
  while ((c = getc(fp)) != SEP)
    if (c == EOF) {
      hell(fp);
      return;
    }

  /* Skip leading whitespace, then read in a quotation.
     If we hit EOF before we find a non-whitespace char, recurse. */
  while (isspace(c = getc(fp)))
    ;
  if (c == EOF) {
    hell(fp);
    return;
  }
  buf[i++] = c;
  while ((c = getc(fp)) != SEP && c != EOF) {
    buf[i++] = c;

    if (i == BUFSIZE-1)
      /* Hell! Is this quotation too long yet? */
      break;
  }
  buf[i++] = 0;
  printf("%s\n", buf);
}

