#ifndef HIMKMH
#define HIMKMH 1

#ifdef AUTODOC

Include File: km.h

Description: 

Include file for HIM Keyboard Manager module

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   28 Apr 1988 18:18:48  $

$Revision:   1.1  $

$Log:   D:/C/FMLIB/KM/VCS/KM.H  $
   
      Rev 1.1   28 Apr 1988 18:18:48   james borders
   Format changes

****************************************************************/

/* Constant definitions for the Keyboard Manager package */


/* Error Codes */

#define KMMAERROR       -1      /* memory allocation error */
#define KMFOERROR       -2      /* file open error */
#define KMFCERROR       -3      /* file close error */
#define KMFRERROR       -4      /* file read error */
#define KMFWERROR       -5      /* file write error */
#define KMBADUIR        -6      /* bad UIR number */
#define KMBADUOR        -7      /* bad UOR number */
#define KMBADIR         -8      /* bad IR number */
#define KMCANTPOP       -9      /* can't pop context any more */

/* UIR function defines */

#define fuirsabort       1      /* set abort code */
#define fuirqabort       2      /* abort code pending ?? */
#define fuirchavail      3      /* character available?? */
#define fuirgetch        4      /* return a character */

/* 
    Background routine parameter.  Indicates to your background routine 
    which input source is currently active.  A positive number means one
    of your User Input Routines (UIR) is active.
*/

#define KFILE       -1
#define KKBD        -2
#define KNONE        0

/* function declarations */

/* multiplexer */
int kmminit(int (*)(),int (*)(), int);
int kmmclear(void);
int kmmkbhit(void);
int kmmgetch(void);
void kmmungetch(int c);
int kmmopen(char *filename);
int kmmclose(void);
void kmmsuspendf(void);
void kmmresumef(void);
int kmmfstat(void);
void (cdecl *kmmsbg(void (cdecl *ptr)()))();
void (cdecl *kmmgbg(void))();
void kmmdbg(void);
void kmmsuspendbg(void);
void kmmresumebg(void);
int kmmbgstat(void);
int kmmsuir(int (cdecl *ptr)());
int (cdecl *kmmguir(int unum))();
int kmmduir(int unum);
int kmmsuspenduir(int unum);
int kmmresumeuir(int unum);
int kmmuirstat(int unum);
void kmmsinput(int inum);
int kmmginput(void);
void kmmsabort(int acode);
int kmmgabort(void);
int kmmpush(int);
int kmmpop(int);
int fcharavail(void);
int kbcharavail(void);
int uircharavail(int num);
int anyaborts(void);
int getfilech(void);
int getkbch(void);
int getuirch(int num);
int ungetfilech(int c);
void ungetkbch(int c);
void ungetuirch(int num,int c);
void bumpinsource(void);
FILE *kmmopenpfile(char *);

/* filter */

int kmfinit(int (*)(),int (*)(), int);
void kmfclear(void);
int kmfsesc(int code);
int kmfgesc(void);
int kmfkbhit(void);
int kmfgetch(void);
void kmfungetch(int c);
void kmfsuspend(void);
void kmfresume(void);
int kmfstat(void);
int kmfpush(int);
int kmfpop(int);
void processchar(int c);
int escinbuf(void);

/* redirector */

int kmrinit(int (*)(),int (*)(), int);
int kmrclear(void);
int kmrkbhit(void);
int kmrgetch(void);
void kmrungetch(int c);
int kmropen(char *filename);
int kmrclose(void);
void kmrsuspendf(void);
void kmrresumef(void);
int kmrfstat(void);
int kmrsuor(void (cdecl *ptr)());
void (cdecl *kmrguor(int unum))();
int kmrduor(int unum);
int kmrsuspenduor(int unum);
int kmrresumeuor(int unum);
int kmruorstat(int unum);
int kmrpush(int);
int kmrpop(int);

/* intercept processor */

int kmpinit(int (*)(),int (*)(), int);
int kmpclear(void);
int kmpkbhit(void);
int kmpgetch(void);
void kmpungetch(int c);
int kmpsipr(int c,int (cdecl *ptr)());
int (cdecl *kmpgipr(int unum))();
int kmpdipr(int unum);
int kmpsuspendipr(int unum);
int kmpresumeipr(int unum);
int kmpiprstat(int unum);
int kmppush(int);
int kmppop(int);

/* Routine Macros */
/*
    The high level Keyboard Manager functions are really just calls to
    one or more of the individual modules as described in the documentation.
    If you have no need for the Filter module or the redirector, you could
    alter the defines below to bypass those modules.
*/

/*
    The kminit is an example.  Notice how it initializes each of the four
    modules; multiplexer, redirector, filter, and intercept processor by
    passing the previous module's kbhit and getch routines.  If you just
    wanted to use the intercept processor and the multiplexer you would:

        1. Initialize the multiplexer.  (kmminit(kbhit,getch))
        2. Initialize the intercept processor by telling it to use the
           multiplexer's input routines instead of the redirector.
           (kmpinit(kmmkbhit,kmmgetch,0)).
*/
    

#define kminit(a,b)     kmminit(a,b,kmfinit(kmmkbhit,kmmgetch,\
                                    kmrinit(kmfkbhit,kmfgetch,\
                                    kmpinit(kmrkbhit,kmrgetch,0))))
#define kmkbhit         kmpkbhit
#define kmgetch         kmpgetch
#define kmungetch(a)    kmpungetch(a)
#define kmopeni(a)      kmmopen(a)
#define kmopeno(a)      kmropen(a)
#define kmclosei()      kmmclose()
#define kmcloseo()      kmrclose()
#define kmsuspendi()    kmmsuspendf()
#define kmsuspendo()    kmrsuspendf()
#define kmresumei()     kmmresumef()
#define kmresumeo()     kmrresumef()
#define kmsbgr(a)       kmmsbg(a)
#define kmgbgr()        kmmgbg()
#define kmdbgr()        kmmdbg()
#define kmsuspendbgr()  kmmsuspendbg()
#define kmresumebgr()   kmmresumebg()
#define kmsuir(a)       kmmsuir(a)
#define kmguir(a)       kmmguir(a)
#define kmduir(a)       kmmduir(a)
#define kmsuspenduir(a) kmmsuspenduir(a)
#define kmresumeuir(a)  kmmresumeuir(a)
#define kmsuor(a)       kmrsuor(a)
#define kmguor(a)       kmrguor(a)
#define kmduor(a)       kmrduor(a)
#define kmsuspenduor(a) kmrsuspenduor(a)
#define kmresumeuor(a)  kmrresumeuor(a)
#define kmsir(a,b)      kmpsipr(a,b)
#define kmgir(a)        kmpgipr(a)
#define kmdir(a)        kmpdipr(a)
#define kmsuspendir(a)  kmpsuspendipr(a)
#define kmresumeir(a)   kmpresumeipr(a)
#define kmsesc(a)       kmfsesc(a)
#define kmgesc()        kmfgesc()
#define kmpush()        kmmpush(kmfpush(kmrpush(kmppush(0))))
#define kmpop()         kmmpop(kmfpop(kmrpop(kmppop(0))))


/* Keycode definitions */

#define KBELL           7       /* ctrl - g */
#define KBS             8       /* back space */
#define KTAB            9       /* tab */
#define KLF             10      /* line feed */
#define KFF             12      /* form feed */
#define KCR             13      /* enter */
#define KESC            27      /* escape */
#define KBTAB           315     /* shift tab */
#define KAA             330     /* alt - a   */
#define KAB             348
#define KAC             346
#define KAD             332
#define KAE             318
#define KAF             333
#define KAG             334
#define KAH             335
#define KAI             336
#define KAJ             337
#define KAK             338
#define KAL             339
#define KAM             350
#define KAN             349
#define KAO             324
#define KAP             325
#define KAQ             316
#define KAR             319
#define KAS             331
#define KAT             320
#define KAU             322
#define KAV             347
#define KAW             317
#define KAX             345
#define KAY             321
#define KAZ             344
#define KF1             359     /* Function key 1 */
#define KF2             360
#define KF3             361
#define KF4             362
#define KF5             363
#define KF6             364
#define KF7             365
#define KF8             366
#define KF9             367
#define KF10            368
#define KHOME           371     /* home */
#define KUP             372     /* up arrow */
#define KPGUP           373     /* page up */
#define KLEFT           375     /* left arrow */
#define KRIGHT          377     /* right arrow */
#define KEND            379     /* end */
#define KDOWN           380     /* down arrow */
#define KPGDN           381     /* page down */
#define KINS            382     /* Ins */
#define KDEL            383     /* Del */
#define KSF1            384     /* Shift F1 */
#define KSF2            385
#define KSF3            386
#define KSF4            387
#define KSF5            388
#define KSF6            389
#define KSF7            390
#define KSF8            391
#define KSF9            392
#define KSF10           393
#define KCF1            394     /* Ctrl - F1 */
#define KCF2            395
#define KCF3            396
#define KCF4            397
#define KCF5            398
#define KCF6            399
#define KCF7            400
#define KCF8            401
#define KCF9            402
#define KCF10           403
#define KAF1            404     /* Alt - F1 */
#define KAF2            405
#define KAF3            406
#define KAF4            407
#define KAF5            408
#define KAF6            409
#define KAF7            410
#define KAF8            411
#define KAF9            412
#define KAF10           413
#define KCPRTSC         414     /* ctrl - print screen */     
#define KCLEFT          415     /* ctrl - left arrow */
#define KCRIGHT         416     /* ctrl - right arrow */
#define KCEND           417     /* ctrl - end */
#define KCPGDN          418     /* ctrl - pgdn */
#define KCHOME          419     /* ctrl - home */
#define KA1             420     /* alt 1  (top of keyboard) */
#define KA2             421
#define KA3             422
#define KA4             423
#define KA5             424
#define KA6             425
#define KA7             426
#define KA8             427
#define KA9             428
#define KA0             429
#define KAMINUS         430     /* alt - (top of keyboard) */
#define KAEQUAL         431     /* alt = */
#define KCPGUP          432     /* ctrl - pgup */
#define KF11            433     /* Function key 11 */
#define KF12            434     
#define KSF11           435     /* Shift F11 */
#define KSF12           436
#define KCF11           437     /* ctrl - F11 */
#define KCF12           438
#define KAF11           439     /* alt - F11 */
#define KAF12           440

#endif  /* HIMKMH */

