#ifndef HIMLMH
#define HIMLMH 1

#ifdef AUTODOC

Include File: lm.h

Description: 

Header file for List Manager (lm) module of HIM (tm).

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   07 May 1988 16:29:38  $

$Revision:   1.0  $

$Log:   D:/C/FMLIB/LM/VCS/LM.H  $
   
      Rev 1.0   07 May 1988 16:29:38   james borders
   Initial revision.

****************************************************************/

/* Error Constants */

#define LMMAERROR       -1      /* memory allocation error */
#define LMBLERROR       -2      /* bad list number */
#define LMBEERROR       -3      /* bad element number */
#define LMNOEL          -4      /* no more elements */
                                                        

/* List ordering constants */

#define LMORIG           1      /* original order */
#define LMASC            2      /* ascending order */
#define LMDESC           3      /* descending order */


/* Routine defs */

int         lminit(char *(*)(),void (*)(),int);
int         lmcreate(char *,int,int);
int         lmdestroy(int);
char        *lmgheader(int);
int         lmael(int,char *,int,int);
char        *lmgel(int,int);
int         lmsel(int,int,char *,int,int);
int         lmdel(int,int);         
int         lmmarkel(int,int);      
int         lmunmarkel(int,int);    
int         lmelstat(int,int);      
int         lmreorder(int,int,int (*)());     
int         lmfindel(int,char *,int,int,int);  
int         lmgfirstel(int);          
int         lmgnextel(int);           
int         lmglastel(int);
int         lmgprevel(int);
int         lmgnumels(int);           
unsigned int lmchecksum(char *, int);

#endif  /* HIMLMH */
