/***************** Program Source Module ***********************/
#ifdef AUTOPDOC

MODULE:     mfdel.c

DESCRIPTION:

   A little file delete utility which will build a menu of
   files in the current directory and allow you to mark/unmark each file.
   When enter is pressed all marked files will be deleted.

   When the list is built, all files with a read-only attribute will show
   up on the list but will be marked read-only so the user can't do anything
   with it.

TABLE OF CONTENTS:

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   01 Dec 1988 12:17:26  $

$Revision:   1.0  $

$Log:   D:/C/FMLIB/MM/VCS/MFDEL.C  $
 * 
 *    Rev 1.0   01 Dec 1988 12:17:26   james borders
 * Initial revision.

****************************************************************/

/*** Include Files ***/

#include "stdio.h"
#ifdef MSC
#include "malloc.h"
#endif
#include "dos.h"
#ifdef TURBOC
#include "alloc.h"
#include "dir.h"
#endif
#include "lm.h"
#include "wn.h"
#include "km.h"
#include "mm.h"

/*** Typedefs ***/

/*** Constants ***/

#define  BC    WNBLUE
#define  FC    WNLCYAN
#define  BBC   WNBLUE
#define  BFC   WNCYAN
#define  HBC   WNBLACK
#define  HFC   WNCYAN
#define  RBC   WNBLUE
#define  RFC   WNDGRAY
#define  MBC   WNBLUE
#define  MFC   WNGREEN
#define  TBC   WNBLACK
#define  TFC   WNYELLOW
#define  MC    '\001'
#define  MK    ' '

#define  WIDTH   70
#define  HEIGHT  0
#define  ROW     15
#define  COL     0
#define  ABSATT  MMABSR | MMABSW

#ifdef MSC
#define  LOOKUPKEY _A_RDONLY | _A_NORMAL
#define  ROKEY     _A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_VOLID | _A_SUBDIR
#define  FILEBLOCK struct find_t
#define  getfirst(a,b,c)    _dos_findfirst((a), (b), (c))
#define  getnext(a)         _dos_findnext(a)
#define  attribfld          attrib
#define  namefld            name
#endif
#ifdef TURBOC
#define  LOOKUPKEY FA_RDONLY 
#define  ROKEY     FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_LABEL | FA_DIREC
#define  FILEBLOCK struct ffblk
#define  getfirst(a,b,c)    findfirst((a), (c), (b))
#define  getnext(a)         findnext(a)
#define  attribfld          ff_attrib
#define  namefld            ff_name
#endif
/*** Global Vars ***/

/*** Macros ***/

main(argc,argv)
/*****/             
int  argc;
char *argv[];
{
int code,mnum,mel,count;
FILEBLOCK cfile;
int kbhit(),getch();
char *cfs;
char buf[80];

lminit((char *(*)())malloc,free,0);           /* init list manager */
wninit(0,0,NULL,0,(char *(*)())malloc,free);  /* window manager using memory */
kminit(kbhit,getch);                        /* keyboard manager */
mminit(kmgetch,NULL);                       /* menu manager */

mmscparms(BC,FC,BBC,BFC,RBC,RFC,MBC,MFC,HBC,HFC,TBC,TFC,MC,MK);
mnum = mmcreate("files",MMPOPUP,ROW,COL,WIDTH,HEIGHT,ABSATT,
                "[ Files in Current Directory ]",
                "[ Space to Mark, ESC to Abort, Enter to Delete Marked ]",NULL,0,
                0,1,MMACTIONNULL,NULL);

count = 0;
if (argc > 1)
   cfs = argv[1];
else
   cfs = "*.*";
code = getfirst(cfs,LOOKUPKEY,&cfile);
while (code == 0){
   count++;
   sprintf(buf,"File [%s] is number %d",cfile.namefld,count);
   mel = mmamel(mnum,"",cfile.namefld,buf,"",1,0,MMNOCASE | cfile.namefld[0],
                MMACTIONNULL,NULL);
   if (cfile.attribfld & (ROKEY))
      mmsmelronly(mnum,mel);                    /* make read only */
   code = getnext(&cfile);
   }

if (count){
   code = mmpromenu(mnum,MMPROCESS,1);
   if (code != 0){                              /* user didn't ESCAPE */
      if (mmgmelstat(mnum,-1) > 0){                /* user marked files */
         mel = mmgfirstmel(mnum);
         while (mel > 0){
            if (mmgmelstat(mnum,mel)){
               if (unlink(mmgmelmdata(mnum,mel))){      /* delete file */
                  printf("\nError deleting file [%s].",mmgmelmdata(mnum,mel));
                  }
               }
            mel = mmgnextmel(mnum);
            }
         }
      }
   }
else{
   printf("\nNo files matching [%s]",cfs);
   }
mmdestroy(mnum); 
exit(0);
}
