#ifndef HIMMMH
#define HIMMMH 1

#ifdef AUTODOC

Include File: mm.h

Description: 

Header file for Menu Manager (mm) module of HIM.

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author$

$Date$

$Revision$

$Log$

****************************************************************/

/* Misc. Definitions */

int     _mmdeoar();             /* default escape simulation action routine */
int     _mmdear();              /* default escape only allowed keystroke */

/* Error Constants */

#define MMOK         0          /* everything ok */
#define MMMAERROR   -1          /* memory allocation error */
#define MMBADMNUM   -2          /* bad menu number */
#define MMBADMEL    -3          /* bad menu element number */
#define MMNMMELS    -4          /* no more elements */
#define MMMTBERROR  -5          /* menu or menu element too big or small */
#define MMBMTERROR  -6          /* bad menu type in mmcreate call */
#define MMPORERROR  -7          /* parameter other than mnum out of range */
#define MMBMCERROR  -8          /* mcall name in mmamel() does not exist */
#define MMDMNERROR  -9          /* duplicate menu name tried to be created */
#define MMFWERROR   -10         /* file write error, from window manager */
#define MMFRERROR   -11         /* file read error, from window manager */
#define MMMNDERROR  -12         /* menu not currently displayed */


/* menu types */

#define MMPOPUP     1           /* pop up menu */
#define MMPULLDOWN  2           /* pull down menu */
#define MMLIGHTBAR  3           /* "lotus" style light bar menu */                                                        

/* menu creation parms */

#define MMABSDEF    0x0000      /* size and location automatic */
#define MMABSR      0x0001      /* absolute row location */
#define MMABSC      0x0002      /* absolute col location */
#define MMABSW      0x0004      /* absolute width */
#define MMABSH      0x0008      /* absolute height */
#define MMABSRC     MMABSR | MMABSC
#define MMABSWH     MMABSW | MMABSH
#define MMABSRCWH   MMABSRC | MMABSWH

/* Menu or Menu element pre-defined action routines */

#define MMACTIONNULL        (int  (*)())NULL    /* no action routine */
#define MMACTIONESC         _mmdear             /* simulates escape */
#define MMACTIONESCONLY     _mmdeoar            /* only returns 0 when ESC hit */


/* mmpromenu func values */

#define MMDISPLAY   1   /* Display primary portion of menu and return. */
#define MMDESTROY   2   /* Take down any part of menu that is being displayed. */
#define MMPROCESS   3   /* Display menu and interact with user.  Use mel as start. */

/* Case insensitive hotkey compare constant */

#define MMNOCASE    0x1000

/* Routine defs */


int mminit(int (*)(),char *);
int mmcreate(char *,int,int,int,int,int,int,char *,char *,char *,int,int,int,int (*)(),char *);
int mmsmnum(int,char *,int,int,int,int,int,char *,char *,int,int (*)(),char *);
int mmamel(int,char *,char *,char *,char *,int,int,int,int (*)(),char *);
int mmdmel(int,int);
void mmgcparms(int *,int *,int *,int *,int *,int *,int *,int *,int *,int *,int *,int *,int *,int *);
void mmscparms(int,int,int,int,int,int,int,int,int,int,int,int,int,int);
int mmpromenu(int,int,int);
int mmxlate(int *,int *,int,int);
int mmgmnum(char *);
char *mmgmname(int);
int mmgmtype(int);
int mmgmrow(int);
int mmgmcol(int);
int mmgmwidth(int);
int mmgmheight(int);
char *mmgmheader(int);
int mmgcmnum(void );
char *mmgmttitle(int);
char *mmgmbtitle(int);
int mmsmelmark(int,int);
int mmsmelunmark(int,int);
int mmsmelronly(int,int);
int mmsmelnonronly(int,int);
int mmgmel(int,char *);
int mmgnummels(int);
int mmgfirstmel(int);
int mmgnextmel(int);
char *mmgmelname(int,int);
char *mmgmelmdata(int,int);
char *mmgmelmdesc(int,int);
char *mmgmelmcall(int,int);
int mmgmelhotkey(int,int);
int mmgmelronly(int,int);
int mmgmelstat(int,int);


#endif  /* HIMMMH */


