/***************** Program Source Module ***********************/
#ifdef AUTOPDOC

MODULE:     mmdemo2.c

DESCRIPTION:

HIM Menu Manager Demo (Lightbar flavor)

TABLE OF CONTENTS:

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   01 Dec 1988 12:18:12  $

$Revision:   1.0  $

$Log:   D:/C/FMLIB/MM/VCS/MMDEMO2.C  $
 * 
 *    Rev 1.0   01 Dec 1988 12:18:12   james borders
 * Initial revision.

****************************************************************/

/*** Include Files ***/

#include "stdio.h"
#include "stdlib.h"
#ifdef MSC
#include "malloc.h"
#endif
#ifdef TURBOC
#include "alloc.h"
#endif
#include "process.h"
#include "dos.h"
#include "lm.h"
#include "wn.h"
#include "km.h"
#include "mm.h"

/*** Typedefs ***/

/*** Constants ***/

/*** Global Vars ***/

int   mm;            /* main menu */
int   mmw,mmr,mmc,mmm,mmf,mmp,mmg,mmd,mms,mmq;  /* second level */
int   mmwg;                                     /* only 1 3rd level for demo*/

/*
   Use the menu variable names as the actual menu names to keep things
   consistent.
*/

/* routines called as action functions */

int nomorelevelsmsg();
int yesnojumptodos();
int yesnoquit();
int jumptodos();
int quit();
int filetoretrieve();
int noaction();

main(argc,argv)
/*****/
int  argc;
char *argv[];
{
int code,mnum,mel,count;
int kbhit(),getch();
char *cfs;
char buf[80];

lminit((char *(*)())malloc,free,0);              /* init list manager */
wninit(0,0,NULL,0,(char *(*)())malloc,free);     /* window manager using memory */
kminit(kbhit,getch);                /* keyboard manager */
mminit(kmgetch,NULL);               /* menu manager */

vpsvmode(vpgvmode());               /* clear the screen */

if (buildmenus() || explain()){
   fprintf(stderr,"\nMMDEMO2 -- Error creating menus.  Check memory.");
   }
else{
   mmpromenu(mm,MMPROCESS,1);
   }
mmdestroy(-1);
exit(0);
}

explain()
/********/
{
int wnum;

wnum = wncreate(14,0,80,10,WNBLUE,WNCYAN,WNBLUE,WNBLACK);
if (wnum < 0)
   return(-1);
wnttitle(wnum,"[ MMDEMO (2)  LIGHTBAR Version 1.0 ]");
wnprintf(wnum,"\nThe HIM Menu Manager makes it easy to include sophisticated menus in your");
wnprintf(wnum,"\nprograms.  The three available menu types are: POPUP, PULL-DOWN, and");
wnprintf(wnum,"\nLIGHTBAR (Lotus-style).  The first 2 levels of the standard Lotus 1-2-3");
wnprintf(wnum,"\nmenus are illustrated here in a LIGHTBAR (Lotus) form.");
return(0);
}


buildmenus()
/***********/
{
if (createmenus() || createelements())
   return(-1);
return(0);
}

createmenus()
/***********/
{

/* first create the top level menu */

mmscparms(WNBLACK,WNWHITE,          /* back/fore */
          WNBLACK,WNWHITE,          /* border back/fore */
          WNBLACK,WNWHITE,          /* read only back/fore */
          WNBLACK,WNWHITE,          /* mark character back/fore */
          WNCYAN,WNBLACK,           /* hightlight back/fore */
          WNBLACK,WNWHITE,          /* title colors */
          ' ','\0');                /* mark character, no mark key */

mm = mmcreate("mm",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,noaction,NULL);

/* now the second level */

mmscparms(WNBLACK, WNWHITE,         /* back/fore */
          WNBLACK, WNWHITE,         /* border back/fore */
          WNBLACK, WNWHITE,         /* read only back/fore */
          WNBLACK, WNWHITE,         /* mark character back/fore */
          WNCYAN, WNBLACK,          /* hightlight back/fore */
          WNBLACK, WNWHITE,         /* title colors */
          ' ','\0');                /* mark character, no mark key */

mmw = mmcreate("mmw",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,MMACTIONNULL,NULL);
mmr = mmcreate("mmr",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmc = mmcreate("mmc",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmm = mmcreate("mmm",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmf = mmcreate("mmf",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmp = mmcreate("mmp",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmg = mmcreate("mmg",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmd = mmcreate("mmd",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mms = mmcreate("mms",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmq = mmcreate("mmq",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);


/* now the 3rd level */

mmscparms(WNBLACK,   WNWHITE,       /* back/fore */
          WNBLACK,   WNWHITE,       /* border back/fore */
          WNBLACK,   WNWHITE,       /* read only back/fore */
          WNBLACK,   WNWHITE,       /* mark character back/fore */
          WNCYAN,    WNBLACK,       /* hightlight back/fore */
          WNBLACK,   WNWHITE,       /* title colors */
          ' ','\0');                /* mark character, no mark key */

mmwg = mmcreate("mmwg",MMLIGHTBAR,0,0,80,2,MMABSRCWH,"","",NULL,0,0,0,nomorelevelsmsg,NULL);

if ((mm|mmw|mmr|mmc|mmm|mmf|mmp|mmg|mmd|mms|mmq|mmwg) < 0)
   return(-1);

return(0);
};

createelements()
/***************/
{
int mel;
char buf[80];

/* main menu (mm) */

sprintf(buf,"~*,%d~W~*,*~orksheet",WNRED);
mmamel(mm,"",buf,"Global, Insert, Delete, Column, Erase, Titles, Window, Status, Page",
             "mmw",1,0,MMNOCASE | 'w',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~R~*,*~ange",WNRED);
mmamel(mm,"",buf,"Format, Label, Erase, Name, Justify, Protect, Unprotect, Input, Value, Transpose",
             "mmr",1,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~C~*,*~opy",WNRED);
mmamel(mm,"",buf,"Copy a cell or range of cells",
             "mmc",1,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~M~*,*~ove",WNRED);
mmamel(mm,"",buf,"Move a cell or range of cells",
             "mmm",1,0,MMNOCASE | 'm',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~F~*,*~ile",WNRED);
mmamel(mm,"",buf,"Retrieve, Save, Combine, Xtract, Erase, List, Import, Directory",
             "mmf",1,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~P~*,*~rint",WNRED);
mmamel(mm,"",buf,"Oputput a range to the printer or a print file",
             "mmp",1,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~G~*,*~raph",WNRED);
mmamel(mm,"",buf,"Create a graph",
             "mmg",1,0,MMNOCASE | 'g',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~D~*,*~ata",WNRED);
mmamel(mm,"",buf,"Fill, Table, Sort, Query, Distribution, Matrix, Regression, Parse",
             "mmd",1,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~S~*,*~ystem",WNRED);
mmamel(mm,"",buf,"Invoke the DOS Command Interpreter",
             "mms",1,0,MMNOCASE | 's',MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~Q~*,*~uit",WNRED);
mmamel(mm,"",buf,"End 1-2-3 session (Have you saved your work ?)",
             "mmq",1,0,MMNOCASE | 'q',MMACTIONNULL,NULL);


/* worksheet level 2 menu (mmw) */
/*
The first item "global" is the only one that will call a 3rd level menu.  All
other items will fall back to their menu action routine which will tell the
user that there are no more levels
*/

mmamel(mmw,"","Global","Set worksheet settings",
             "mmwg",0,0,MMNOCASE | 'g',MMACTIONNULL,NULL);
mmamel(mmw,"","Insert","Insert blank column(s) or row(s)",
             "",0,0,MMNOCASE | 'i',nomorelevelsmsg,NULL);
mmamel(mmw,"","Delete","Delete entire column(s) or row(s)",
             "",0,0,MMNOCASE | 'd',nomorelevelsmsg,NULL);
mmamel(mmw,"","Column","Set display characteristics of the current column",
             "",0,0,MMNOCASE | 'c',nomorelevelsmsg,NULL);
mmamel(mmw,"","Erase","Erase the entire worksheet",
             "",0,0,MMNOCASE | 'e',nomorelevelsmsg,NULL);
mmamel(mmw,"","Titles","Set horizontal or vertical titles",
             "",0,0,MMNOCASE | 't',nomorelevelsmsg,NULL);
mmamel(mmw,"","Window","Set split screen and synchronized scrolling",
             "",0,0,MMNOCASE | 'w',nomorelevelsmsg,NULL);
mmamel(mmw,"","Status","Display worksheet settings",
             "",0,0,MMNOCASE | 's',nomorelevelsmsg,NULL);
mmamel(mmw,"","Page","Insert a page-break above the cell pointer",
             "",0,0,MMNOCASE | 'p',nomorelevelsmsg,NULL);

/* range level 2 menu (mmr) */

mmamel(mmr,"","Format","Format a cell or range of cells",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmr,"","Label","Align a label or range of labels (Left, Right, or Center)",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmr,"","Erase","Erase a cell or range of cells",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmr,"","Name","Create, delete, or modify range names",
             "",0,0,MMNOCASE | 'n',MMACTIONNULL,NULL);
mmamel(mmr,"","Justify","Adjust width of a column of labels",
             "",0,0,MMNOCASE | 'j',MMACTIONNULL,NULL);
mmamel(mmr,"","Protect","Disallow changes to a range if protection is enabled",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmr,"","Unprotect","Allow changes to a range",
             "",0,0,MMNOCASE | 'u',MMACTIONNULL,NULL);
mmamel(mmr,"","Input","Enter data into the unprotected cells in a range",
             "",0,0,MMNOCASE | 'i',MMACTIONNULL,NULL);
mmamel(mmr,"","Value","Copy range, converting formulas to values",
             "",0,0,MMNOCASE | 'v',MMACTIONNULL,NULL);
mmamel(mmr,"","Transpose","Copy range, switching columns and rows",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);


/* copy level 2 menu (mmc) */

mmamel(mmc,"","From","Range of cells to copy from",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmc,"","To","Range of cells to copy to",
             "",0,1,MMNOCASE | 't',MMACTIONNULL,NULL);

/* move level 2 menu (mmm) */

mmamel(mmm,"","From","Range of cells to move from",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);

mmamel(mmm,"","To","Range of cells to move to",
             "",0,1,MMNOCASE | 't',MMACTIONNULL,NULL);


/* file level 2 menu (mmf) */

mmamel(mmf,"","Retrieve","Erase the current worksheet and display the selected worksheet",
             "",0,0,MMNOCASE | 'r',filetoretrieve,NULL);
mmamel(mmf,"","Save","Store the entire worksheet in a worksheet file",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmf,"","Combine","Incorporate all or part of a worksheet file into the worksheet",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmf,"","Xtract","Store a cell range in a worksheet file",
             "",0,0,MMNOCASE | 'x',MMACTIONNULL,NULL);
mmamel(mmf,"","Erase","Erase a worksheet, print, or graph file",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmf,"","List","Display names of 1-2-3 files in current directory",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmf,"","Import","Read text or numbers from a print file into the worksheet",
             "",0,0,MMNOCASE | 'i',MMACTIONNULL,NULL);
mmamel(mmf,"","Directory","Display and/or set the current directory",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);

/* print level 2 menu (mmp) */

mmamel(mmp,"","Printer","Send print output directly to printer",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmp,"","File","Send print output to file",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);

/* graph level 2 menu (mmg) */

mmamel(mmg,"","Type","Set graph type",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);
mmamel(mmg,"","X","Set X-Range",
             "",0,0,MMNOCASE | 'x',MMACTIONNULL,NULL);
mmamel(mmg,"","A","Set first data range",
             "",0,0,MMNOCASE | 'a',MMACTIONNULL,NULL);
mmamel(mmg,"","B","Set second data range",
             "",0,0,MMNOCASE | 'b',MMACTIONNULL,NULL);
mmamel(mmg,"","C","Set third data range",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmg,"","D","Set fourth data range",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
mmamel(mmg,"","E","Set fifth data range",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmg,"","F","Set sixth data range",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmg,"","Reset","Cancel graph settings",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmg,"","View","View the current graph",
             "",0,0,MMNOCASE | 'v',MMACTIONNULL,NULL);
mmamel(mmg,"","Save","Save the current graph in a file for later printing",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmg,"","Options","Legend, Format, Titles, Grid, Scale, Color, B&W, Data-Labels",
             "",0,0,MMNOCASE | 'o',MMACTIONNULL,NULL);
mmamel(mmg,"","Name","Use, Create, Delete, or Reset named graphs",
             "",0,0,MMNOCASE | 'n',MMACTIONNULL,NULL);
mmamel(mmg,"","Quit","Return to READY mode",
             "",0,0,MMNOCASE | 'q',MMACTIONNULL,NULL);


/* data level 2 menu (mmd) */

mmamel(mmd,"","Fill","Fill a range with numbers",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmd,"","Table","Create a table of values",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);
mmamel(mmd,"","Sort","Sort data records",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmd,"","Query","Find all data records satisfying given criteria",
             "",0,0,MMNOCASE | 'q',MMACTIONNULL,NULL);
mmamel(mmd,"","Distribution","Calculate frequency distribution of a range",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
mmamel(mmd,"","Matrix","Perform matrix operations",
             "",0,0,MMNOCASE | 'm',MMACTIONNULL,NULL);
mmamel(mmd,"","Regression","Calculate linear regressions",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmd,"","Parse","Parse a column of labels into a range",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);


/* system level 2 menu (mms) */

mmamel(mms,"","No","Do not jump to DOS",
             "",0,0,MMNOCASE | 'n',noaction,NULL);
mmamel(mms,"","Yes","Jump to DOS",
             "",0,0,MMNOCASE | 'y',jumptodos,NULL);


/* quit level 2 menu (mmq) */

mmamel(mmq,"","No","Do not end 1-2-3 session; return to READY mode",
             "",0,0,MMNOCASE | 'n',noaction,NULL);
mmamel(mmq,"","Yes","End 1-2-3 session (Remember to save your worksheet first)",
             "",0,0,MMNOCASE | 'y',quit,NULL);

/* worksheet-global level 3 menu (mmwg) */

mmamel(mmwg,"","Format","Set global format",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmwg,"","Label-prefix","Set global label alignment prefix (Left, Right, Center)",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmwg,"","Column-Width","Set global column width",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmwg,"","Recalculation","Natural, Columnwise, Rowwise, Automatic, Manual, Iteration",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmwg,"","Protection","Turn protection on or off",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmwg,"","Default","Define default disk and printer settings",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);

mel = mmamel(mmwg,"","Zero","turn zero suppression on or off",
             "",0,0,MMNOCASE | 'z',MMACTIONNULL,NULL);

/*
   if the last element took then all the others probably did too.
*/

if (mel < 0){
   return(-1);
   }
return(0);
};

/***** action routines *****/

nomorelevelsmsg(mnum,mel,hotkey)
/***************/
int mnum,mel,hotkey;
{
int wnum;

if (mel == -1){
   if (strcmp(mmgmname(mnum),"mm") == 0) /* at main already */
      return(-1);
   else
      return(0);
   };
wnum = wncreate(19,0,40,6,WNBLACK,WNCYAN,WNBLACK,WNCYAN);
wnprintf(wnum,"No more levels defined for this demo.");
wnprintf(wnum,"\nESCAPE backs out of a menu.");
wnprintf(wnum,"\n<Hit a key...>");
kmgetch();
wndestroy(wnum);
return(-1);
}

yesnojumptodos(mnum,mel,hotkey)
/*****************************/
int mnum,mel,hotkey;
{
if (hotkey)    /* don't ask user, just do it */
   jumptodos(mnum,mel,hotkey);
else
   mmpromenu(mms,MMPROCESS,1);
return(-1);

}

yesnoquit(mnum,mel,hotkey)
/*****************************/
int mnum,mel,hotkey;
{
if (hotkey)   /* don't ask user, just do it */
   quit(mnum,mel,hotkey);
else
   mmpromenu(mmq,MMPROCESS,1);
return(-1);
}


jumptodos(mnum,mel,hotkey)
/***************/
int mnum,mel,hotkey;
{
int wnum;
int wsave,wscroll,wcmode,ul,ur,ll,lr,vti,vbi,hli,hri,ic,vc,hc;

wngcparms(&wsave,&wscroll,&wcmode,&ul,&ur,&ll,
          &lr,&vti,&vbi,&hli,&hri,&ic,&vc,&hc);
wnscparms(wsave,wscroll,wcmode,           /* create window wo/border */
          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ');
wnum = wncreate(0,0,wngscols(),wngsrows(),WNBLACK,WNBLACK,WNBLACK,WNBLACK);
if (wnum > 0){
   spawnl(P_WAIT,getenv("COMSPEC"),NULL);
   wndestroy(wnum);
   }
wnscparms(wsave,wscroll,wcmode,ul,ur,ll,lr,vti,vbi,hli,hri,ic,vc,hc);
return(0);
}

quit(mnum,mel,hotkey)
/************/
int mnum,mel,hotkey;
{
mmdestroy(-1);    /* will NOT take down menus... */
wndestroy(-1);    /* get rid of the windows */
exit(0);
}

noaction(mnum,mel,hotkey)
/***************/
int mnum,mel,hotkey;
{
if (mel == -1){
   if (strcmp(mmgmname(mnum),"mm") == 0) /* at main already */
      return(-1);
   else
      return(0);
   };

return(0);
};

filetoretrieve(mnum,mel,hotkey)
/*****************************/
int mnum,mel,hotkey;
{
char buf[80];

mminput(mnum,"File to Retrieve? ",WNCHARSTR,buf,12,0,NULL,WNACTIONNULL);
return(0);
}
