/***************** Program Source Module ***********************/
#ifdef AUTOPDOC

MODULE:     mmdemo3.c

DESCRIPTION:

HIM Menu Manager Demo (Pulldown flavor)

TABLE OF CONTENTS:

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   01 Dec 1988 12:18:34  $

$Revision:   1.0  $

$Log:   D:/C/FMLIB/MM/VCS/MMDEMO3.C  $
 * 
 *    Rev 1.0   01 Dec 1988 12:18:34   james borders
 * Initial revision.

****************************************************************/

/*** Include Files ***/

#include "stdio.h"
#include "stdlib.h"
#ifdef MSC
#include "malloc.h"
#endif
#ifdef TURBOC
#include "alloc.h"
#endif
#include "process.h"
#include "dos.h"
#include "lm.h"
#include "wn.h"
#include "km.h"
#include "mm.h"

/*** Typedefs ***/

/*** Constants ***/

/*** Global Vars ***/

int   mm;            /* main menu */
int   mmw,mmr,mmc,mmm,mmf,mmp,mmg,mmd,mms,mmq;  /* second level */
int   mmwg;                                     /* only 1 3rd level for demo*/

/*
   Use the menu variable names as the actual menu names to keep things
   consistent.
*/

/* routines called as action functions */

int menuhandler();
int nomorelevelsmsg();
int jumptodos();
int quit();

main(argc,argv)
/*****/
int  argc;
char *argv[];
{
int code,mnum,mel,count;
int kbhit(),getch();
char *cfs;
char buf[80];

lminit((char *(*)())malloc,free,0);              /* init list manager */
wninit(0,0,NULL,0,(char *(*)())malloc,free);     /* window manager using memory */
kminit(kbhit,getch);                /* keyboard manager */
mminit(kmgetch,NULL);               /* menu manager */

vpsvmode(vpgvmode());               /* clear the screen */

if (buildmenus() ||
    buildintercepts() ||
    explain()){
   fprintf(stderr,"\nMMDEMO3 -- Error creating menus.  Check memory.");
   }
else{
   mmpromenu(mm,MMDISPLAY,1);   /* display pulldown part of menu */
   while (kmgetch() != KESC)    /* let intercept processor handle menu when */
       ;                        /* hotkey or / is typed */
   }
mmdestroy(-1);
wndestroy(-1);
exit(0);
}

buildintercepts()
/***************/
{
kmsir('/',menuhandler);         /* enter menu with last current item */
kmsir(KAW,menuhandler);         /* Worksheet */
kmsir(KAR,menuhandler);         /* Range */
kmsir(KAC,menuhandler);         /* Copy */
kmsir(KAM,menuhandler);         /* Move */
kmsir(KAF,menuhandler);         /* Files */
kmsir(KAP,menuhandler);         /* Print */
kmsir(KAG,menuhandler);         /* Graph */
kmsir(KAD,menuhandler);         /* Data */
kmsir(KAS,menuhandler);         /* System */
if (kmsir(KAQ,menuhandler) < 0) /* Quit */
    return(-1);
return(0);
}

menuhandler(keycode)
/******************/
/*
    this routine will get called by the Keyboard Manager everytime one of the
    keys in buildintercepts() is pressed by the user.
*/
int keycode;    /* supplied by Keyboard manager */
{
static int active = 0;
int startel,rval;

rval = keycode;
if (!active){
    active = 1;
    switch(keycode){
        case    '/':    startel = 0;    break;  /* use last current item */
        case    KAW:    startel = mmgmel(mm,"worksheet");   break;
        case    KAR:    startel = mmgmel(mm,"range");       break;
        case    KAC:    startel = mmgmel(mm,"copy");        break;
        case    KAM:    startel = mmgmel(mm,"move");        break;
        case    KAF:    startel = mmgmel(mm,"file");        break;
        case    KAP:    startel = mmgmel(mm,"print");       break;
        case    KAG:    startel = mmgmel(mm,"graph");       break;
        case    KAD:    startel = mmgmel(mm,"data");        break;
        case    KAS:    startel = mmgmel(mm,"system");      break;
        case    KAQ:    startel = mmgmel(mm,"quit");        break;
        }
    /*
        process the menu.  let all of the action be handled by the action
        routines defined for the menus and menu elements.
    */
    mmpromenu(mm,MMPROCESS,startel);
    active = 0;
    rval = -1;         /* pretend like key never hit.. */
    }
return(rval);
};

explain()
/********/
{
int wnum;

wnum = wncreate(14,0,80,10,WNBLUE,WNCYAN,WNBLUE,WNBLACK);
if (wnum < 0)
   return(-1);
wnttitle(wnum,"[ MMDEMO (3)  PULL-DOWN Version 1.0 ]");
wnprintf(wnum,"\nThe HIM Menu Manager makes it easy to include sophisticated menus in your");
wnprintf(wnum,"\nprograms.  The three available menu types are: POPUP, PULL-DOWN, and");
wnprintf(wnum,"\nLIGHTBAR (Lotus-style).  The first 2 levels of the standard Lotus 1-2-3");
wnprintf(wnum,"\nmenus are illustrated here in a PULL-DOWN form.");
wnprintf(wnum,"\n");
wnprintf(wnum,"\nHit '/' or Alt-(highlighted letter) to activate menu.  ESC to quit.");
return(0);
}


buildmenus()
/***********/
{
int mel;
char buf[80];

/*
   for a pull-down menu, the top level has to be created after the
   sub-menus are known..
*/

/*
    Let's do second level first so we can specify the coords of the third
    level to be just below and to the right of the second level.
*/

mmscparms(WNBLACK, WNLMAGENTA,       /* back/fore */
          WNBLACK, WNGREEN,          /* border back/fore */
          WNBLACK, WNLGREEN,         /* read only back/fore */
          WNBLACK, WNLCYAN,          /* mark character back/fore */
          WNBLACK, WNRED,            /* hightlight back/fore */
          WNBLACK, WNYELLOW,         /* title colors */
          ' ','\0');                /* mark character, no mark key */

mmw = mmcreate("mmw",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,MMACTIONNULL,NULL);
mmr = mmcreate("mmr",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmc = mmcreate("mmc",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmm = mmcreate("mmm",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmf = mmcreate("mmf",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmp = mmcreate("mmp",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmg = mmcreate("mmg",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmd = mmcreate("mmd",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mms = mmcreate("mms",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);
mmq = mmcreate("mmq",MMPOPUP,0,0,0,0,MMABSDEF,"","",NULL,0,0,0,nomorelevelsmsg,NULL);

/* worksheet level 2 menu (mmw) */
/*
The first item "global" is the only one that will call a 3rd level menu.  All
other items will fall back to their menu action routine which will tell the
user that there are no more levels
*/

mmamel(mmw,"","Global","Set worksheet settings",
             "mmwg",0,0,MMNOCASE | 'g',MMACTIONNULL,NULL);
mmamel(mmw,"","Insert","Insert blank column(s) or row(s)",
             "",0,0,MMNOCASE | 'i',nomorelevelsmsg,NULL);
mmamel(mmw,"","Delete","Delete entire column(s) or row(s)",
             "",0,0,MMNOCASE | 'd',nomorelevelsmsg,NULL);
mmamel(mmw,"","Column","Set display characteristics of the current column",
             "",0,0,MMNOCASE | 'c',nomorelevelsmsg,NULL);
mmamel(mmw,"","Erase","Erase the entire worksheet",
             "",0,0,MMNOCASE | 'e',nomorelevelsmsg,NULL);
mmamel(mmw,"","Titles","Set horizontal or vertical titles",
             "",0,0,MMNOCASE | 't',nomorelevelsmsg,NULL);
mmamel(mmw,"","Window","Set split screen and synchronized scrolling",
             "",0,0,MMNOCASE | 'w',nomorelevelsmsg,NULL);
mmamel(mmw,"","Status","Display worksheet settings",
             "",0,0,MMNOCASE | 's',nomorelevelsmsg,NULL);
mmamel(mmw,"","Page","Insert a page-break above the cell pointer",
             "",0,0,MMNOCASE | 'p',nomorelevelsmsg,NULL);

/* range level 2 menu (mmr) */

mmamel(mmr,"","Format","Format a cell or range of cells",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmr,"","Label","Align a label or range of labels (Left, Right, or Center)",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmr,"","Erase","Erase a cell or range of cells",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmr,"","Name","Create, delete, or modify range names",
             "",0,0,MMNOCASE | 'n',MMACTIONNULL,NULL);
mmamel(mmr,"","Justify","Adjust width of a column of labels",
             "",0,0,MMNOCASE | 'j',MMACTIONNULL,NULL);
mmamel(mmr,"","Protect","Disallow changes to a range if protection is enabled",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmr,"","Unprotect","Allow changes to a range",
             "",0,0,MMNOCASE | 'u',MMACTIONNULL,NULL);
mmamel(mmr,"","Input","Enter data into the unprotected cells in a range",
             "",0,0,MMNOCASE | 'i',MMACTIONNULL,NULL);
mmamel(mmr,"","Value","Copy range, converting formulas to values",
             "",0,0,MMNOCASE | 'v',MMACTIONNULL,NULL);
mmamel(mmr,"","Transpose","Copy range, switching columns and rows",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);


/* copy level 2 menu (mmc) */

mmamel(mmc,"","From","Range of cells to copy from",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmc,"","To","Range of cells to copy to",
             "",0,1,MMNOCASE | 't',MMACTIONNULL,NULL);

/* move level 2 menu (mmm) */

mmamel(mmm,"","From","Range of cells to move from",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);

mmamel(mmm,"","To","Range of cells to move to",
             "",0,1,MMNOCASE | 't',MMACTIONNULL,NULL);


/* file level 2 menu (mmf) */

mmamel(mmf,"","Retrieve","Erase the current worksheet and display the selected worksheet",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmf,"","Save","Store the entire worksheet in a worksheet file",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmf,"","Combine","Incorporate all or part of a worksheet file into the worksheet",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmf,"","Xtract","Store a cell range in a worksheet file",
             "",0,0,MMNOCASE | 'x',MMACTIONNULL,NULL);
mmamel(mmf,"","Erase","Erase a worksheet, print, or graph file",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmf,"","List","Display names of 1-2-3 files in current directory",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmf,"","Import","Read text or numbers from a print file into the worksheet",
             "",0,0,MMNOCASE | 'i',MMACTIONNULL,NULL);
mmamel(mmf,"","Directory","Display and/or set the current directory",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);

/* print level 2 menu (mmp) */

mmamel(mmp,"","Printer","Send print output directly to printer",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmp,"","File","Send print output to file",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);

/* graph level 2 menu (mmg) */

mmamel(mmg,"","Type","Set graph type",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);
mmamel(mmg,"","X","Set X-Range",
             "",0,0,MMNOCASE | 'x',MMACTIONNULL,NULL);
mmamel(mmg,"","A","Set first data range",
             "",0,0,MMNOCASE | 'a',MMACTIONNULL,NULL);
mmamel(mmg,"","B","Set second data range",
             "",0,0,MMNOCASE | 'b',MMACTIONNULL,NULL);
mmamel(mmg,"","C","Set third data range",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmg,"","D","Set fourth data range",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
mmamel(mmg,"","E","Set fifth data range",
             "",0,0,MMNOCASE | 'e',MMACTIONNULL,NULL);
mmamel(mmg,"","F","Set sixth data range",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmg,"","Reset","Cancel graph settings",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmg,"","View","View the current graph",
             "",0,0,MMNOCASE | 'v',MMACTIONNULL,NULL);
mmamel(mmg,"","Save","Save the current graph in a file for later printing",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmg,"","Options","Legend, Format, Titles, Grid, Scale, Color, B&W, Data-Labels",
             "",0,0,MMNOCASE | 'o',MMACTIONNULL,NULL);
mmamel(mmg,"","Name","Use, Create, Delete, or Reset named graphs",
             "",0,0,MMNOCASE | 'n',MMACTIONNULL,NULL);
mmamel(mmg,"","Quit","Return to READY mode",
             "",0,0,MMNOCASE | 'q',MMACTIONNULL,NULL);


/* data level 2 menu (mmd) */

mmamel(mmd,"","Fill","Fill a range with numbers",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmd,"","Table","Create a table of values",
             "",0,0,MMNOCASE | 't',MMACTIONNULL,NULL);
mmamel(mmd,"","Sort","Sort data records",
             "",0,0,MMNOCASE | 's',MMACTIONNULL,NULL);
mmamel(mmd,"","Query","Find all data records satisfying given criteria",
             "",0,0,MMNOCASE | 'q',MMACTIONNULL,NULL);
mmamel(mmd,"","Distribution","Calculate frequency distribution of a range",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
mmamel(mmd,"","Matrix","Perform matrix operations",
             "",0,0,MMNOCASE | 'm',MMACTIONNULL,NULL);
mmamel(mmd,"","Regression","Calculate linear regressions",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmd,"","Parse","Parse a column of labels into a range",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);


/* system level 2 menu (mms) */

mmamel(mms,"","No","Do not jump to DOS",
             "",0,0,MMNOCASE | 'n',MMACTIONESCONLY,NULL);
mmamel(mms,"","Yes","Jump to DOS",
             "",0,0,MMNOCASE | 'y',jumptodos,NULL);


/* quit level 2 menu (mmq) */

mmamel(mmq,"","No","Do not end 1-2-3 session; return to READY mode",
             "",0,0,MMNOCASE | 'n',MMACTIONESCONLY,NULL);
mmamel(mmq,"","Yes","End 1-2-3 session (Remember to save your worksheet first)",
             "",0,0,MMNOCASE | 'y',quit,NULL);

/*
    Now do the main menu.  After each element is added to this menu, a fixup
    to the sub-menu under it (the popup) will be performed.  It doesn't matter
    what location you picked for the subs, they will be altered to fall just
    under each of the items in this main menu.

    After this main menu is created, you will be able to set the locations of
    lower level menus based on their parents by using mmgmrow() and mmgmcol()
*/

mmscparms(WNBLUE,WNWHITE,          /* back/fore */
          WNBLACK,WNWHITE,          /* border back/fore */
          WNBLACK,WNWHITE,          /* read only back/fore */
          WNBLACK,WNWHITE,          /* mark character back/fore */
          WNCYAN,WNBLACK,           /* hightlight back/fore */
          WNBLACK,WNWHITE,          /* title colors */
          ' ','\0');                /* mark character, no mark key */

mm = mmcreate("mm",MMPULLDOWN,0,0,40,1,MMABSR | MMABSWH,"","",NULL,0,0,0,MMACTIONNULL,NULL);

/* main menu (mm) */

sprintf(buf,"~*,%d~W~*,*~orksheet",WNRED);
mmamel(mm,"worksheet",buf,"Global, Insert, Delete, Column, Erase, Titles, Window, Status, Page",
             "mmw",1,0,KAW,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~R~*,*~ange",WNRED);
mmamel(mm,"range",buf,"Format, Label, Erase, Name, Justify, Protect, Unprotect, Input, Value, Transpose",
             "mmr",1,0,KAR,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~C~*,*~opy",WNRED);
mmamel(mm,"copy",buf,"Copy a cell or range of cells",
             "mmc",1,0,KAC,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~M~*,*~ove",WNRED);
mmamel(mm,"move",buf,"Move a cell or range of cells",
             "mmm",1,0,KAM,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~F~*,*~ile",WNRED);
mmamel(mm,"file",buf,"Retrieve, Save, Combine, Xtract, Erase, List, Import, Directory",
             "mmf",1,0,KAF,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~P~*,*~rint",WNRED);
mmamel(mm,"print",buf,"Oputput a range to the printer or a print file",
             "mmp",1,0,KAP,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~G~*,*~raph",WNRED);
mmamel(mm,"graph",buf,"Create a graph",
             "mmg",1,0,KAG,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~D~*,*~ata",WNRED);
mmamel(mm,"data",buf,"Fill, Table, Sort, Query, Distribution, Matrix, Regression, Parse",
             "mmd",1,0,KAD,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~S~*,*~ystem",WNRED);
mmamel(mm,"system",buf,"Invoke the DOS Command Interpreter",
             "mms",1,0,KAS,MMACTIONNULL,NULL);
sprintf(buf,"~*,%d~Q~*,*~uit",WNRED);
mmamel(mm,"quit",buf,"End 1-2-3 session (Have you saved your work ?)",
             "mmq",1,0,KAQ,MMACTIONNULL,NULL);


/*
    Now our one and only 3rd level..
*/

mmscparms(WNRED,   WNYELLOW,         /* back/fore */
          WNRED,   WNBLACK,          /* border back/fore */
          WNRED,   WNLRED,           /* read only back/fore */
          WNBLACK, WNLCYAN,          /* mark character back/fore */
          WNBLACK, WNRED,            /* hightlight back/fore */
          WNBLACK, WNYELLOW,         /* title colors */
          ' ','\0');                /* mark character, no mark key */
/*
    Offset this menu down and to the right from the parent (mmw).. 
*/
mmwg = mmcreate("mmwg",MMPOPUP,
                mmgmrow(mmgmnum("mmw")) + 1,    /* row + 1 */
                mmgmcol(mmgmnum("mmw")) + 1,    /* col + 1 */
                0,0,MMABSRC,"[ Global ]","",NULL,0,0,0,nomorelevelsmsg,NULL);

/* worksheet-global level 3 menu (mmwg) */

mmamel(mmwg,"","Format","Set global format",
             "",0,0,MMNOCASE | 'f',MMACTIONNULL,NULL);
mmamel(mmwg,"","Label-prefix","Set global label alignment prefix (Left, Right, Center)",
             "",0,0,MMNOCASE | 'l',MMACTIONNULL,NULL);
mmamel(mmwg,"","Column-Width","Set global column width",
             "",0,0,MMNOCASE | 'c',MMACTIONNULL,NULL);
mmamel(mmwg,"","Recalculation","Natural, Columnwise, Rowwise, Automatic, Manual, Iteration",
             "",0,0,MMNOCASE | 'r',MMACTIONNULL,NULL);
mmamel(mmwg,"","Protection","Turn protection on or off",
             "",0,0,MMNOCASE | 'p',MMACTIONNULL,NULL);
mmamel(mmwg,"","Default","Define default disk and printer settings",
             "",0,0,MMNOCASE | 'd',MMACTIONNULL,NULL);
mmamel(mmwg,"","Zero","turn zero suppression on or off",
            "",0,0,MMNOCASE | 'z',MMACTIONNULL,NULL);


if ((mm|mmw|mmr|mmc|mmm|mmf|mmp|mmg|mmd|mms|mmq|mmwg) < 0)
   return(-1);

return(0);
};


/***** action routines *****/

nomorelevelsmsg(mnum,mel,hotkey)
/***************/
int mnum,mel,hotkey;
{
int wnum;

if (mel == -1)
      return(0);

wnum = wncreate(19,0,40,6,WNBLACK,WNCYAN,WNBLACK,WNCYAN);
wnprintf(wnum,"No more levels defined for this demo.");
wnprintf(wnum,"\nESCAPE backs out of a menu.");
wnprintf(wnum,"\n<Hit a key...>");
kmgetch();
wndestroy(wnum);
return(-1);
}

jumptodos(mnum,mel,hotkey)
/***************/
int mnum,mel,hotkey;
{
int wnum;
int wsave,wscroll,wcmode,ul,ur,ll,lr,vti,vbi,hli,hri,ic,vc,hc;

wngcparms(&wsave,&wscroll,&wcmode,&ul,&ur,&ll,
          &lr,&vti,&vbi,&hli,&hri,&ic,&vc,&hc);
wnscparms(wsave,wscroll,wcmode,           /* create window wo/border */
          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ');
wnum = wncreate(0,0,wngscols(),wngsrows(),WNBLACK,WNBLACK,WNBLACK,WNBLACK);
if (wnum > 0){
   spawnl(P_WAIT,getenv("COMSPEC"),NULL);
   wndestroy(wnum);
   }
wnscparms(wsave,wscroll,wcmode,ul,ur,ll,lr,vti,vbi,hli,hri,ic,vc,hc);
return(-1);
}

quit(mnum,mel,hotkey)
/************/
int mnum,mel,hotkey;
{
mmdestroy(-1);    /* will NOT take down menus... */
wndestroy(-1);    /* get rid of the windows */
exit(0);
}



