/******************************************************************************
* Iteraction library - cursor handler.					      *
*									      *
*					Written by Gershon Elber,  Oct. 1990  *
*******************************************************************************
* History:								      *
*  3 Oct 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#include <stdio.h>
#include "intr_loc.h"
#include "intr_gr.h"
#ifdef __MSDOS__
#include "mousedrv.h"
#endif /* __MSDOS__ */

#define INTR_CURSOR_STACK_SIZE 20

#ifdef DJGCC
#define MouseSetPosition(x, y)	MouseWarp(x, y)
#endif /* DJGCC */

static int StackPtr = 0;
static int CursorLastX, CursorLastY;
static IntrBType CursorVisible = FALSE;
static IntrBType UseMouseDriverCursor = FALSE;
static IntrCursorShapeStruct
    *CurrentCursor = NULL,
    CursorStack[INTR_CURSOR_STACK_SIZE];

static void IntrDrawCursor(int x, int y);

/****************************************************************************
* Routine to draw cursor shape at given location. Shape is specified by     *
* CurrentCursor variable.						    *
****************************************************************************/
void IntrUseMouseDriverCursor(IntrBType UseMouseCursor)
{
    UseMouseDriverCursor = UseMouseCursor;
}

/****************************************************************************
* Routine to draw cursor shape at given location. Shape is specified by     *
* CurrentCursor variable.						    *
****************************************************************************/
static void IntrDrawCursor(int x, int y)
{
    int GRLastColor = GRGetColor();

    GRSetWriteMode(GR_XOR_PUT);
    GRPushViewPort();
    GRSetViewPort(0, 0, GRScreenMaxX, GRScreenMaxY);

    IntrAllocColor(INTR_COLOR_WHITE, INTR_INTENSITY_VHIGH);

    switch (CurrentCursor -> CursorType) {
	case INTR_CURSOR_CROSS:
	    GRSetLineStyle(GR_DOTTED_LINE, 0, GR_NORM_WIDTH);
	    GRSLine(0, y, GRScreenMaxX, y);
	    GRSLine(x, 0, x, GRScreenMaxY);
	    break;
	case INTR_CURSOR_CROSS_LAST:
	    GRSetLineStyle(GR_DOTTED_LINE, 0, GR_NORM_WIDTH);
	    GRSLine(0, y, GRScreenMaxX, y);
	    GRSLine(x, 0, x, GRScreenMaxY);
	    if (CurrentCursor -> LastHV) {
		if (ABS(CurrentCursor -> LastX - x) <
	    	    ABS(CurrentCursor -> LastY - y))
		    GRSLine(CurrentCursor -> LastX, CurrentCursor -> LastY,
	    	            CurrentCursor -> LastX, y);
		else
		    GRSLine(CurrentCursor -> LastX, CurrentCursor -> LastY,
	    		    x, CurrentCursor -> LastY);
	    }
	    else
		GRSLine(CurrentCursor -> LastX, CurrentCursor -> LastY,
    		        x, y);
	    break;
	case INTR_CURSOR_SCROSS:
	    GRSetLineStyle(GR_SOLID_LINE, 0, GR_NORM_WIDTH);
	    GRSLine(x - 5, y - 1, x + 5, y - 1);
	    GRSLine(x - 5, y,     x + 5, y    );
	    GRSLine(x - 5, y + 1, x + 5, y + 1);
	    GRSLine(x - 1, y - 5, x - 1, y + 5);
	    GRSLine(x,     y - 5, x,     y + 5);
	    GRSLine(x + 1, y - 5, x + 1, y + 5);
	    break;
	case INTR_CURSOR_CUSTOM:
	    (CurrentCursor -> CursorRoutine)(x, y);/* Apply crnt cursor rtn. */
	    break;
	case INTR_CURSOR_BOX:
	    GRSetLineStyle(GR_DOTTED_LINE, 0, GR_NORM_WIDTH);
	    GRSLine(0, y, GRScreenMaxX, y);
	    GRSLine(x, 0, x, GRScreenMaxY);
	    GRSMoveTo(x - CurrentCursor -> Width, y - CurrentCursor -> Height);
	    GRSLineTo(x + CurrentCursor -> Width, y - CurrentCursor -> Height);
	    GRSLineTo(x + CurrentCursor -> Width, y + CurrentCursor -> Height);
	    GRSLineTo(x - CurrentCursor -> Width, y + CurrentCursor -> Height);
	    GRSLineTo(x - CurrentCursor -> Width, y - CurrentCursor -> Height);
	    break;
	case INTR_CURSOR_BOX_LAST:
	    GRSetLineStyle(GR_DOTTED_LINE, 0, GR_NORM_WIDTH);
	    GRSLine(0, y, GRScreenMaxX, y);
	    GRSLine(x, 0, x, GRScreenMaxY);
	    GRSLine(x, CurrentCursor -> LastY,
    		    CurrentCursor -> LastX, CurrentCursor -> LastY);
	    GRSLine(CurrentCursor -> LastX, y,
    		    CurrentCursor -> LastX, CurrentCursor -> LastY);
	    break;
	case INTR_CURSOR_ARROW:
	case INTR_CURSOR_MASK:
	default:
	    GRPutArrowCursor(x, y);
	    break;
    }

    GRSetColor(GRLastColor);
    GRPopViewPort();
    GRSetLineStyle(GR_SOLID_LINE, 0, GR_NORM_WIDTH);
    GRSetWriteMode(GR_COPY_PUT);
}

/****************************************************************************
* Routine to push cursor type into cursor stack.			    *
****************************************************************************/
void IntrPushCursorType(void)
{
    IntrSetCursorType2(INTR_CURSOR_PUSH, NULL, 0, 0, 0, 0, FALSE);
}

/****************************************************************************
* Routine to pop cursor type from cursor stack.				    *
****************************************************************************/
void IntrPopCursorType(void)
{
    IntrSetCursorType2(INTR_CURSOR_POP, NULL, 0, 0, 0, 0, FALSE);
}

/****************************************************************************
* Routine to get current cursor shape.					    *
****************************************************************************/
IntrCursorShapeStruct *IntrGetCursorType(void)
{
    return CurrentCursor;
}

/****************************************************************************
* Routine to put cursor shape at given location.			    *
****************************************************************************/
void IntrSetCursorType(IntrCursorShapeStruct *Cursor)
{
    if (Cursor != NULL)
        IntrSetCursorType2(Cursor -> CursorType,
		           Cursor -> CursorRoutine,
                           Cursor -> Width, Cursor -> Height,
                           Cursor -> LastX, Cursor -> LastY,
		           Cursor -> LastHV);
}

/****************************************************************************
* Routine to put cursor shape at given location. Cursor type is selected    *
* globaly by CursorType variable.					    *
****************************************************************************/
void IntrSetCursorType2(IntrCursorType CursorType,
		        void (* CursorRoutine)(int, int),
		        int Width, int Height, int LastX, int LastY,
		        IntrBType LastHV)
{
    CurrentCursor = &CursorStack[StackPtr];

    switch (CursorType) {
	case INTR_CURSOR_PUSH:
	    if (StackPtr >= INTR_CURSOR_STACK_SIZE - 2)
		IntrFatalError("Cursor stack overflow");
            CurrentCursor -> LastX = GRCurrentCursorX;
            CurrentCursor -> LastY = GRCurrentCursorY;
            CurrentCursor -> _CursorVisible = CursorVisible;
	    CursorStack[StackPtr + 1] = CursorStack[StackPtr];
	    CurrentCursor = &CursorStack[++StackPtr];
            if (CursorVisible) IntrUnShowCursor();
	    break;
	case INTR_CURSOR_POP:
	    if (--StackPtr < 0)
		IntrFatalError("Cursor stack underflow");
	    CurrentCursor = &CursorStack[StackPtr];
            GRCurrentCursorX = CurrentCursor -> LastX;
            GRCurrentCursorY = CurrentCursor -> LastY;
            if (CurrentCursor -> _CursorVisible)
               IntrShowCursor(GRCurrentCursorX, GRCurrentCursorY);
	    break;
	case INTR_CURSOR_CROSS:
	case INTR_CURSOR_CROSS_LAST:
	case INTR_CURSOR_SCROSS:
	case INTR_CURSOR_ARROW:
	case INTR_CURSOR_CUSTOM:
	case INTR_CURSOR_BOX:
	case INTR_CURSOR_BOX_LAST:
	    CurrentCursor -> CursorType = CursorType;
	    CurrentCursor -> CursorRoutine = CursorRoutine;
	    CurrentCursor -> CursorType = CursorType;
	    CurrentCursor -> Width = Width;
	    CurrentCursor -> Height = Height;
	    CurrentCursor -> LastX = LastX;
	    CurrentCursor -> LastY = LastY;
	    CurrentCursor -> LastHV = LastHV;
	    break;
    }
}

/****************************************************************************
* Routine to enable cursor display at a given location. Shape is specified  *
* by CurrentCursor variable.						    *
****************************************************************************/
void IntrShowCursor(int x, int y)
{
    if (CursorVisible)
        IntrFatalError("Cursor is already visible.");

    CursorVisible = TRUE;

    if (_IntrActiveDevices & INTR_INPT_DEVICE_MOUSE &&
    	(x != CursorLastX || y != CursorLastY)) {
	/* Update mouse on new position. */
	MouseSetPosition(x, y);
    }

#ifdef __MSDOS__
    /* If this is a mouse mask and mouse exists do it using mouse driver. */
    if (UseMouseDriverCursor &&
        (CurrentCursor -> CursorType == INTR_CURSOR_MASK ||
         CurrentCursor -> CursorType == INTR_CURSOR_ARROW) &&
	_IntrActiveDevices & INTR_INPT_DEVICE_MOUSE) {
        MouseShowCursor();
    }
    else
#endif /* __MSDOS__ */
        IntrDrawCursor(x, y);

    CursorLastX = x;
    CursorLastY = y;
}

/****************************************************************************
* Routine to reposition the cursor. If the cursor is visible, it is redrawn.*
****************************************************************************/
void IntrReposCursor(int x, int y)
{
    if (CursorVisible) {
        if (_IntrActiveDevices & INTR_INPT_DEVICE_MOUSE &&
           (x != CursorLastX || y != CursorLastY)) {
	   /* Update mouse on new position. */
	   MouseSetPosition(x, y);
	}

	/* This is a mouse mask and mouse exists do it using mouse driver. */
 	if (CurrentCursor -> CursorType == INTR_CURSOR_MASK &&
           _IntrActiveDevices & INTR_INPT_DEVICE_MOUSE) {
        }
        else {
            IntrDrawCursor(CursorLastX, CursorLastY);
            IntrDrawCursor(x, y);
        }

        CursorLastX = x;
        CursorLastY = y;
    }
}

/****************************************************************************
* Routine to disable cursor display.					    *
****************************************************************************/
void IntrUnShowCursor(void)
{
   if (!CursorVisible)
       IntrFatalError("Cursor is already invisible.");

#ifdef __MSDOS__
    /* If this is a mouse mask and mouse exists do it using mouse driver. */
    if (UseMouseDriverCursor &&
        (CurrentCursor -> CursorType == INTR_CURSOR_MASK ||
         CurrentCursor -> CursorType == INTR_CURSOR_ARROW) &&
	_IntrActiveDevices & INTR_INPT_DEVICE_MOUSE) {
        MouseHideCursor();
    }
    else
#endif /* __MSDOS__ */
        IntrDrawCursor(CursorLastX, CursorLastY);

   CursorLastX = -1000;
   CursorLastY = -1000;

   CursorVisible = FALSE;
}
