#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <graphics.h>
#ifdef __MSDOS__
#include <conio.h>
#endif /* __MSDOS__ */
#include "intr_lib.h"
#include "intr_gr.h"

static int RWindowID;

static IntrBType
    QuitProgram = FALSE;

static IntrPopUpMenuStruct *PUWndwMenu, *PUMenu1, *PUMenu2, *PUMenu3;

static char *Menu1Str[] = {
    "Selection 0",
    "Selection 1",
    "Selection 2",
    "Selection 3"
};
#define MENU1_SIZE (sizeof(Menu1Str) / sizeof(char *))

static char *Menu3Str[] = {
    "Item 0",
    "Item 1",
    "Item 2",
    "Item 3",
    "Item 4",
    "Item 5",
    "Item 6"
};
#define MENU3_SIZE (sizeof(Menu3Str) / sizeof(char *))

static char *PullDownStrs[] = {
    "Menu1",
    "Menu2",
    "Menu3",
    "Data",
    "View",
    "Status",
    "Quit"
};
static void PullDownMenu1Func(int Index);
static void PullDownMenu2Func(int Index);
static void PullDownMenu3Func(int Index);
static void PullDownDataFunc(int Index);
static void PullDownViewFunc(int Index);
static void PullDownStatusFunc(int Index);
static void PullDownQuitFunc(int Index);
static IntrIntFunc PullDownActions[] = {
    PullDownMenu1Func,
    PullDownMenu2Func,
    PullDownMenu3Func,
    PullDownDataFunc,
    PullDownViewFunc,
    PullDownStatusFunc,
    PullDownQuitFunc
};
#define PULL_DOWN_SIZE (sizeof(PullDownStrs) / sizeof(char *))

static char *WindowMenuStrs[] = {
    "Redraw All",
    "Move",
    "Resize",
    "Pop",
    "Push",
    "Show Red Wndw",
    "Hide Red Wndw"
};
#define WINDOW_MENU_SIZE (sizeof(WindowMenuStrs) / sizeof(char *))

static void RandomBBox(IntrBBoxStruct *BBox);
static void RedRefreshFunction(int WindowID);
static void QuitFunc(int KeyStroke);
static void WndwMenuFunc(int KeyStroke);

/******************************************************************************
* A simple test for the Intr_lib library.				      *
******************************************************************************/
void main(int argc, char **argv)
{
    int GWindowID, BWindowID, YWindowID, CWindowID, MWindowID, WWindowID,
        i, j, x, y, Exit;
    char Buffer[1024], Line[128], Str[128];
    IntrBType SmoothScrolling;
    FILE *f;
    IntrBBoxStruct BBox;
    IntrCursorShapeStruct Cursor;
    IntrPullDownMenuStruct *PDMenu;

#ifdef __MSDOS__
    if (argc == 2)
        switch(argv[1][0]) {
	    case 'b':
                GRInstallSVGA("vga256.1");
		GRSetBGIPath("c:/bc/bgi");
		break;
	    case 'S':
		GRInstallSVGA("ati.2");
		GRSetBGIPath("c:/bc/bgi/ati");
		break;
	    case 's':
		GRInstallSVGA("svga256.3");
		GRSetBGIPath("c:/bc/bgi/ati");
		break;
	    default:
		fprintf(stderr, "Undefined command line argument\n"
				"Usage: \"Test [S] [s]\".\n");
		exit(1);
		break;
	}
    else
	GRSetBGIPath("c:/bc/bgi");

    randomize();
#endif /* __MSDOS__ */

    IntrSetSaveBackPath("d:\\");
    IntrSetSaveBackMethod(INTR_SAVE_DISK);

    IntrInit();

    IntrSetMouseSensitivity(16);
    IntrSetAsyncEventMode(TRUE);

    IntrSetInputDevice(INTR_INPT_DEVICE_MOUSE |
		       /* INTR_INPT_DEVICE_JOYSTICK | */
		       INTR_INPT_DEVICE_KEYBOARD);

    IntrSetAtKeyboard(TRUE);
    IntrRegisterKeyStroke(0x110 /* Alt Q */, QuitFunc);
    IntrRegisterKeyStroke(0x171 /* Alt F10 */, WndwMenuFunc);

    /* Set the default cursor to arrow. */
    Cursor.CursorType = INTR_CURSOR_ARROW;
    IntrSetCursorType(&Cursor);

    /* Prepare a first pop up menu of 4 items, in strings array. */
    PUMenu1 = IntrPopUpMenuCreate("Menu1 Header", Menu1Str, 0, MENU1_SIZE,
				  INTR_COLOR_RED, INTR_COLOR_BLUE,
                                  INTR_COLOR_YELLOW, INTR_COLOR_MAGENTA,
				  8, &Cursor);

    /* Prepare a second menu of 5 items, 15 chars wide. */
    Cursor.CursorType = INTR_CURSOR_SCROSS;
    for (i = 0; i < 5; i++) sprintf(&Str[i * 13], "Menu Item %d", i);
    PUMenu2 = IntrPopUpMenuCreate("Menu2 Header", (char **) Str, 13, 5,
				  INTR_COLOR_GREEN, INTR_COLOR_YELLOW,
                                  INTR_COLOR_CYAN, INTR_COLOR_MAGENTA,
                                  16, &Cursor);

    /* Prepare a third pop up menu with no name, in strings array. */
    PUMenu3 = IntrPopUpMenuCreate(NULL, Menu3Str, 0, MENU3_SIZE,
				  INTR_COLOR_GREEN, INTR_COLOR_YELLOW,
                                  INTR_COLOR_CYAN, INTR_COLOR_MAGENTA,
                                  8, &Cursor);

    /* And prepare the window pop up menu. */
    PUWndwMenu = IntrPopUpMenuCreate("Window", WindowMenuStrs, 0,
    				  WINDOW_MENU_SIZE,
				  INTR_COLOR_GREEN, INTR_COLOR_CYAN,
                                  INTR_COLOR_YELLOW, INTR_COLOR_MAGENTA,
                                  16, &Cursor);

    Cursor.CursorType = INTR_CURSOR_ARROW;
    IntrQueryContinue("This is a \"Continue\" query.",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_RED,
                      8,
                      &Cursor,
                      RWindowID);

    Cursor.CursorType = INTR_CURSOR_SCROSS;
    IntrQueryYesNo("This is a \"Yes-No\" query.",
		      INTR_COLOR_CYAN,
                      INTR_COLOR_RED,
                      INTR_COLOR_WHITE,
                      INTR_COLOR_YELLOW,
                      8,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);

    strcpy(Line, "Preset string");
    IntrQueryLine("This is a \"Line\" query.",
		  Line,
                  79,
    		  INTR_COLOR_MAGENTA,
                  INTR_COLOR_RED,
                  INTR_COLOR_WHITE,
                  12,
                  INTR_WNDW_PLACE_CENTER);

    for (i = 0; i < 50; i++) sprintf(&Buffer[i * 10], "Item %d", i);
    Cursor.CursorType = INTR_CURSOR_ARROW;
    for (i = 0; i < 4; i++) {
        j = IntrQueryList("List Query",
		          (char **) Buffer,
			  10,
        	          50,
	                  10,
			  INTR_COLOR_MAGENTA,
			  INTR_COLOR_BLUE,
			  INTR_COLOR_YELLOW,
			  INTR_COLOR_YELLOW,
	                  12,
        	          &Cursor,
	                  INTR_WNDW_PLACE_CENTER);

	sprintf(Line, "List item %d was selected", j);
	IntrQueryContinue(Line,
    		          INTR_COLOR_RED,
                          INTR_COLOR_BLUE,
                          INTR_COLOR_YELLOW,
                          INTR_COLOR_MAGENTA,
                          16,
                          &Cursor,
                          INTR_WNDW_PLACE_CENTER);
    }

    for (i = 0; i < 4; i++) {
	if (IntrPopUpMenu(PUMenu1, 0)) {
            sprintf(Buffer, "Item %d was selected.", PUMenu1 -> SelectedIndex);
	}
	else {
            sprintf(Buffer, "Abort was keyed on item %d.", PUMenu1 -> SelectedIndex);
	}
	IntrQueryContinue(Buffer,
    		          INTR_COLOR_RED,
                          INTR_COLOR_BLUE,
                          INTR_COLOR_YELLOW,
                          INTR_COLOR_MAGENTA,
                          12,
                          &Cursor,
                          INTR_WNDW_PLACE_CENTER);
    }

    for (i = 0; i < 4; i++) {
	if (IntrPopUpMenu(PUMenu2, 0)) {
            sprintf(Buffer, "Item %d was selected.", PUMenu2 -> SelectedIndex);
	}
	else {
            sprintf(Buffer, "Abort was keyed on item %d.", PUMenu2 -> SelectedIndex);
	}
	IntrQueryContinue(Buffer,
			  INTR_COLOR_RED,
                          INTR_COLOR_BLUE,
                          INTR_COLOR_YELLOW,
                          INTR_COLOR_CYAN,
                          10,
                          &Cursor,
                          INTR_WNDW_PLACE_CENTER);
    }

    Cursor.CursorType = INTR_CURSOR_CROSS;

    BBox.Xmin = 50;
    BBox.Ymin = 50;
    BBox.Xmax = GRScreenMaxX - 50;
    BBox.Ymax = GRScreenMaxY - 50;
    RWindowID = IntrWndwCreate("Red Window",
		               12,
		               &BBox,
		               INTR_COLOR_RED,
			       INTR_COLOR_BLUE,
			       &Cursor,
                               NULL,
                               NULL);

    BBox.Xmin = 100;
    BBox.Ymin = 100;
    BBox.Xmax = GRScreenMaxX - 30;
    BBox.Ymax = GRScreenMaxY - 30;
    PDMenu = IntrPullDownMenuCreate(PullDownStrs, 0, PULL_DOWN_SIZE,
    				    PullDownActions,
				    INTR_COLOR_GREEN, INTR_COLOR_BLACK,
                                    INTR_COLOR_YELLOW, INTR_COLOR_CYAN, 8);
    GWindowID = IntrWndwCreate("Window with Pull Down menu.",
		               8,
		               &BBox,
			       INTR_COLOR_GREEN,
			       INTR_COLOR_YELLOW,
			       &Cursor,
                               PDMenu,
                               NULL);

    RandomBBox(&BBox);
    BWindowID = IntrWndwCreate("Blue Window",
		               8,
		               &BBox,
		               INTR_COLOR_BLUE,
			       INTR_COLOR_RED,
			       &Cursor,
                               NULL,
                               NULL);

    RandomBBox(&BBox);
    YWindowID = IntrWndwCreate("Yellow Window",
		               1,
		               &BBox,
		               INTR_COLOR_YELLOW,
			       INTR_COLOR_BLUE,
			       &Cursor,
                               NULL,
                               NULL);

    RandomBBox(&BBox);
    CWindowID = IntrWndwCreate("Cyan Window",
		               12,
		               &BBox,
		               INTR_COLOR_CYAN,
			       INTR_COLOR_RED,
			       &Cursor,
                               NULL,
                               NULL);

    RandomBBox(&BBox);
    MWindowID = IntrWndwCreate("Magenta Window",
		               8,
		               &BBox,
		               INTR_COLOR_MAGENTA,
			       INTR_COLOR_GREEN,
			       &Cursor,
                               NULL,
                               NULL);

    RandomBBox(&BBox);
    WWindowID = IntrWndwCreate(NULL,
		               10,
		               &BBox,
		               INTR_COLOR_WHITE,
			       INTR_COLOR_MAGENTA,
			       &Cursor,
                               NULL,
                               NULL);


    IntrWndwPop(RWindowID, FALSE, TRUE);

    IntrWndwPop(BWindowID, FALSE, TRUE);
    IntrWndwPop(YWindowID, FALSE, TRUE);
    IntrWndwPop(CWindowID, FALSE, TRUE);
    IntrWndwPop(MWindowID, FALSE, TRUE);
    IntrWndwPop(WWindowID, FALSE, TRUE);

    IntrTextInitWindow(RWindowID, TRUE, INTR_COLOR_YELLOW, INTR_COLOR_RED,
			 	  INTR_SCRLBAR_NONE, INTR_SCRLBAR_LEFT, 50, 80);
    IntrWndwSetRefreshFunc(RWindowID, RedRefreshFunction);

    if ((f = fopen("intr_lib.h", "r")) == NULL) {
	IntrFatalError("Failed to open \"intr_lib.h\".");
        exit(1);
    }

    IntrQueryContinue("Type SPACE to toggle smooth scroll, RETURN to quit.",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);

    /* Fill the window with some text without window update. */
    for (i = j = 0; i < 30 && fgets(Buffer, 127, f); i++)
	IntrPrintf(RWindowID, FALSE, "%3d : %s", j++, Buffer);

    Exit = FALSE;
    IntrTextSetSmoothScroll(SmoothScrolling = FALSE);
    IntrInputFlush();
    while (!Exit && fgets(Buffer, 127, f)) {
	if (IntrKbHit()) switch(IntrGetch())
        {
           case ' ':
	       SmoothScrolling = !SmoothScrolling;
	       IntrTextSetSmoothScroll(SmoothScrolling);
               break;
           case 10:
           case 13:
	       Exit = TRUE;
               break;
        }
	IntrPrintf(RWindowID, TRUE, "%3d : %s", j++, Buffer);
    }

    fclose(f);

    strcpy(Buffer, "Type anything you want, \"Quit\" to quit lines entering.");
    do {
	IntrGetLineWindow(RWindowID, Buffer, 79);
	IntrPrintf(RWindowID, TRUE, Buffer);
    }
    while (strncmp(Buffer, "quit", 4) && strncmp(Buffer, "QUIT", 4));

    IntrQueryContinue("The RED text window is about to be hidden.",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_MAGENTA,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
    IntrWndwHide(RWindowID, TRUE);

    IntrQueryContinue("We are about to pop a window with pull down menu.",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_GREEN,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);

    IntrWndwPop(GWindowID, FALSE, TRUE);

    IntrQueryContinue("Type \"Alt F10\" for window handling",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
		      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);

    IntrSetHandleInternalEvents(TRUE, FALSE);
    Cursor.CursorType = INTR_CURSOR_CROSS;
    do {
        switch (IntrGetEventWait(&x, &y)) {
            case INTR_EVNT_SELECT:
		sprintf(Buffer,"SELECT Event at %d %d", x, y);
	        IntrQueryContinue(Buffer,
    		                  INTR_COLOR_RED,
		                  INTR_COLOR_BLUE,
		                  INTR_COLOR_YELLOW,
	                          INTR_COLOR_CYAN,
		                  16,
		                  &Cursor,
		                  INTR_WNDW_PLACE_CENTER);
                break;
            case INTR_EVNT_ABORT:
		sprintf(Buffer,"ABORT Event at %d %d", x, y);
	        IntrQueryContinue(Buffer,
    		                  INTR_COLOR_RED,
		                  INTR_COLOR_BLUE,
		                  INTR_COLOR_YELLOW,
	                          INTR_COLOR_CYAN,
		                  16,
		                  &Cursor,
		                  INTR_WNDW_PLACE_CENTER);
                break;
	}
    }
    while (!QuitProgram);

    IntrPopUpMenuDelete(PUMenu1);
    IntrPopUpMenuDelete(PUMenu2);
    IntrPopUpMenuDelete(PUWndwMenu);
    IntrWndwDelete(RWindowID, FALSE);
    IntrWndwDelete(GWindowID, FALSE);
    IntrWndwDelete(BWindowID, FALSE);
    IntrWndwDelete(YWindowID, FALSE);
    IntrWndwDelete(CWindowID, FALSE);
    IntrWndwDelete(MWindowID, FALSE);
    IntrWndwDelete(WWindowID, TRUE);

    IntrClose();
}

/******************************************************************************
* A random function to pick a bbox in screen space.			      *
******************************************************************************/
static void RandomBBox(IntrBBoxStruct *BBox)
{
#ifdef __MSDOS__
    BBox -> Xmin = 20 + random(GRScreenMaxX - 180);
    BBox -> Ymin = 20 + random(GRScreenMaxY - 180);
    BBox -> Xmax = BBox -> Xmin + 100 +
				   random(GRScreenMaxX - 140 - BBox -> Xmin);
    BBox -> Ymax = BBox -> Ymin + 100 +
				   random(GRScreenMaxY - 140 - BBox -> Ymin);
#endif /* __MSDOS__ */
#ifdef DJGCC
    BBox -> Xmin = 20 + random() % (GRScreenMaxX - 180);
    BBox -> Ymin = 20 + random() % (GRScreenMaxY - 180);
    BBox -> Xmax = BBox -> Xmin + 100 +
			   random() % (GRScreenMaxX - 140 - BBox -> Xmin);
    BBox -> Ymax = BBox -> Ymin + 100 +
			   random() % (GRScreenMaxY - 140 - BBox -> Ymin);
#endif /* DJGCC */
}

/******************************************************************************
* A routine invoked when ever the RED window needs to be refreshed.	      *
******************************************************************************/
static void RedRefreshFunction(int WindowID)
{
    IntrTextWndwRefresh(WindowID);
}

/******************************************************************************
* A set of routines called upon activation of the pull down menu.	      *
******************************************************************************/
static void PullDownMenu1Func(int Index)
{
    char Buffer[80];
    IntrCursorShapeStruct Cursor;

    if (IntrPopUpMenu(PUMenu1, INTR_WNDW_PULL_DOWN)) {
        sprintf(Buffer, "Item %d was selected.", PUMenu1 -> SelectedIndex);
    }
    else {
        sprintf(Buffer, "Abort was keyed on item %d.", PUMenu1 -> SelectedIndex);
    }

    Cursor.CursorType = INTR_CURSOR_ARROW;
    IntrQueryContinue(Buffer,
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      12,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownMenu2Func(int Index)
{
    char Buffer[80];
    IntrCursorShapeStruct Cursor;

    if (IntrPopUpMenu(PUMenu2, INTR_WNDW_PULL_DOWN)) {
        sprintf(Buffer, "Item %d was selected.", PUMenu2 -> SelectedIndex);
    }
    else {
        sprintf(Buffer, "Abort was keyed on item %d.", PUMenu2 -> SelectedIndex);
    }

    Cursor.CursorType = INTR_CURSOR_ARROW;
    IntrQueryContinue(Buffer,
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      12,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownMenu3Func(int Index)
{
    char Buffer[80];
    IntrCursorShapeStruct Cursor;

    if (IntrPopUpMenu(PUMenu3, INTR_WNDW_PULL_DOWN)) {
        sprintf(Buffer, "Item %d was selected.", PUMenu3 -> SelectedIndex);
    }
    else {
        sprintf(Buffer, "Abort was keyed on item %d.", PUMenu3 -> SelectedIndex);
    }

    Cursor.CursorType = INTR_CURSOR_ARROW;
    IntrQueryContinue(Buffer,
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      12,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownDataFunc(int Index)
{
    IntrCursorShapeStruct Cursor;

    Cursor.CursorType = INTR_CURSOR_SCROSS;

    IntrQueryContinue("Pull Down DATA has been selected",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownViewFunc(int Index)
{
    IntrCursorShapeStruct Cursor;

    Cursor.CursorType = INTR_CURSOR_SCROSS;

    IntrQueryContinue("Pull Down VIEW has been selected",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownStatusFunc(int Index)
{
    IntrCursorShapeStruct Cursor;

    Cursor.CursorType = INTR_CURSOR_SCROSS;

    IntrQueryContinue("Pull Down STATUS has been selected",
    		      INTR_COLOR_RED,
                      INTR_COLOR_BLUE,
                      INTR_COLOR_YELLOW,
                      INTR_COLOR_CYAN,
                      16,
                      &Cursor,
                      INTR_WNDW_PLACE_CENTER);
}

static void PullDownQuitFunc(int Index)
{
    IntrCursorShapeStruct Cursor;

    Cursor.CursorType = INTR_CURSOR_SCROSS;

    if (IntrQueryYesNo("Do you want to quit this demo?",
    		       INTR_COLOR_RED,
                       INTR_COLOR_BLUE,
                       INTR_COLOR_YELLOW,
                       INTR_COLOR_CYAN,
                       16,
                       &Cursor,
                       INTR_WNDW_PLACE_CENTER)) {
        QuitProgram = TRUE;
    }
}

/******************************************************************************
* A function bounded to a quit key.					      *
******************************************************************************/
static void QuitFunc(int KeyStroke)
{
    IntrClose();
    exit(9);
}

/******************************************************************************
* A function bounded to a window handling key.				      *
******************************************************************************/
static void WndwMenuFunc(int KeyStroke)
{
    int WindowID;
    static IntrBType
	RedWindowISDisplayed = FALSE;

    if (IntrPopUpMenu(PUWndwMenu, 0)) {
        switch (PUWndwMenu -> SelectedIndex) {
	    case 0: /* Redraw. */
                IntrWndwRedrawAll();
                break;
            case 1: /* Move. */
                if (IntrPopUpActive() == 0 &&
                    (WindowID = IntrWndwPick()) > 0)
		    IntrWndwMove(WindowID, TRUE);
                break;
            case 2: /* Resize. */
                if (IntrPopUpActive() == 0 &&
                    (WindowID = IntrWndwPick()) > 0)
                    IntrWndwResize(WindowID, TRUE);
                break;
            case 3: /* Pop. */
                if (IntrPopUpActive() == 0 &&
                    (WindowID = IntrWndwPick()) > 0)
                    IntrWndwPop(WindowID, TRUE, FALSE);
                break;
            case 4: /* Push. */
                if (IntrPopUpActive() == 0 &&
                    (WindowID = IntrWndwPick()) > 0)
                    IntrWndwPush(WindowID, TRUE);
                break;
            case 5: /* Show Red Window. */
		IntrWndwPop(RWindowID, TRUE, FALSE);
		RedWindowISDisplayed = TRUE;
                break;
            case 6: /* Hide Red Window. */
	        IntrWndwHide(RWindowID, TRUE);
		RedWindowISDisplayed = FALSE;
                break;

        }
    }
}
