/******************************************************************************
* Iteraction library - generic functions.				      *
*									      *
*					Written by Gershon Elber,  Oct. 1990  *
*******************************************************************************
* History:								      *
*  7 Oct 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __MSDOS__
#include <alloc.h>
#include "mousedrv.h"
#endif /* __MSDOS__ */

#include "intr_loc.h"
#include "intr_gr.h"

#ifdef __TURBOC__			     /* Only for TC++ 1.0 and above. */
#define __DEBUG_MALLOC__
#endif /* __TURBOC__ */

static int InputDevicesUsed = 0;

/*****************************************************************************
* Routine to initialize the library. Must be called before any other call to *
* any other function in the library.					     *
*****************************************************************************/
void IntrInit(void)
{
    if (InputDevicesUsed != 0) {
	/* This is NOT the first time IntrInit is Being called and input     */
    	/* devices has been initialized. Reinitialize them now.		     */
	IntrSetInputDevice(InputDevicesUsed); /* Reenable all input devices. */
    }

    GRInitGraph();

   _IntrAllocColors();
}

/*****************************************************************************
* Routine to close the library. Should be called in the end before the       *
* programs quits.		       		       		             *
*****************************************************************************/
void IntrClose(void)
{
    _IntrRestoreAll();               /* In case something is being poped up. */

    GRCloseGraph();

    InputDevicesUsed = _IntrActiveDevices;
    IntrSetInputDevice(0);		       /* Disable all input devices. */
}

#ifdef __DEBUG_MALLOC__
/*****************************************************************************
* My Routine to	allocate dynamic memory. All program requests must call this *
* routine (no direct call to malloc). Dies if no memory.		     *
*****************************************************************************/
static void AllocError(const char *Msg, VoidPtr *p)
{
    char s[128];

    sprintf(s, "%s, Ptr = %p\n", Msg, p);
    FATAL_ERROR(s);
}
#endif /* __DEBUG_MALLOC__ */

/*****************************************************************************
* My Routine to	allocate dynamic memory. All program requests must call this *
* routine (no direct call to malloc). Dies if no memory.		     *
*****************************************************************************/
VoidPtr _IntrMalloc(unsigned size)
{
    VoidPtr p;

    if ((p = (VoidPtr) malloc(size)) != NULL) {
        return p;
    }

    IntrFatalError("Not enough memory, exit.");

    return NULL;				    /* Make warnings silent. */
}

/*****************************************************************************
* My Routine to	free dynamic memory. All program requests must call this     *
* routine (no direct call to free).					     *
*****************************************************************************/
void _IntrFree(VoidPtr p)
{
#ifdef __DEBUG_MALLOC__
    switch (heapcheck()) {
	case _HEAPCORRUPT:
	    AllocError("Heap is corrupted", p);
	    break;
	case _BADNODE:
	    AllocError("Attempt to free a bogus pointer", p);
	    break;
	case _FREEENTRY:
	    AllocError("Attempt to free an already freed pointer", p);
	    break;
	case _HEAPOK:
	case _HEAPEMPTY:
	case _USEDENTRY:
	    break;
	default:
	    AllocError("Allocation error", p);
	    break;

    }
#endif /* __DEBUG_MALLOC__ */

    free(p);
}

/******************************************************************************
* Fatal Error handler - print the given message to stderr and dies.	      *
******************************************************************************/
void IntrFatalError(char *Msg)
{
    IntrClose();

    fprintf(stderr, "INTR_LIB: %s\n", Msg);

    exit(5);
}

#ifdef __TURBOC__

/*****************************************************************************
* Define dummy floating point routine to force linking of floating point     *
* package.								     *
*****************************************************************************/
IntrRType __DummyFloatingPointRoutine(IntrRType r)
{
    return exp(r);
}

#endif /* __TURBOC__ */

