/* These C functions are for use with the Lattice C Compiler, version
   2.14, and are supplied for your use by Dr. Jim Conn of Micro Solutions 
   Associates, Route 1 Swallowfield, Frankfort, KY  40601 */

#include "stdio.h"
#include "dos.h"
downstr(b)
/*convert string to lower case*/
char *b;
{
	while(*b != '\0') {
		*b = tolower(*b);
		b++;
	}
}
getl(fi, s)
/*get a line of data from file fi, terminated by a newline, into array s */
/*does not include the newline*/
char s[];
FILE *fi;
{
	int c, i;
	i = 0;
	while ((c = fgetc(fi)) != -1 && (c & 127) != '\n') {
		c = c & 127;
		s[i++] = c;
	}
	s[i] = '\0';
	return(i);
}
ltoasc(n, s)
/* convert LONG n to a string pointed to by s */
char *s;
long n;
{
	int i;
	long sign;
	if ((sign = n) < 0L)
		n = -n;
	i = 0;
	do {
		s[i++] = n % 10L + '0';
	} while ((n /= 10L) > 0L);
	if (sign < 0L)
		s[i++] = '-';
	s[i] = '\0';
	reverse(s);
}
upstr(b)
/*convert string b to uppercase */
char *b;
{
	while(*b != '\0') {
		*b = toupper(*b);
		b++;
	}
}
hash(s, hashsize)
/*return hashvalue of string in s, bounded by hashsize */
char *s;
int hashsize;
{
	int hashval;
	for (hashval = 0; *s != '\0';)
		hashval += *s++;
	return(hashval % hashsize);
}
reverse(s)
/* reverse string s */
char s[];
{
	int c, i, j;
	for (i = 0, j = strlen(s)-1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}
instr(s, t)
/* return index of t in s, -1 if none */
char s[], t[];
{
	int i, j, k;
	for (i = 0; s[i] != '\0'; i++) {
		for (j=i, k=0; t[k] != '\0' && s[j] == t[k]; j++, k++)
			;
		if (t[k] == '\0')
			return(++i);
		}
		return(-1);
}
midstr(x, i, j, buf)
int i, j;
char *x, *buf;
{
/*this function returns a string of length j characters
from string x beginning with character number i.
if length of x is less than i, returns null string.
if length of x from i pos. is less than j characters, 
returns all characters to the right of i position.
similar to MID$(X$, I, J) in MBASIC. */

	int l;
	if(i < 1)
		i = 1;
	if((strlen(x)) < i) {
		buf[0] = '\0';
		return(0);
	}
	x = x+i-1;
	if((strlen(x)) < j) {
		strcpy(buf, x);
		return(0);
	}
	for(l = 0; l < j; l++)
		buf[l] = x[l];
	buf[l] = '\0';
}
leftstr(x, i, buf)
int i;
char *x, *buf;
{

/*this function returns a string of length j characters
from the left side of string x.
if i = 0, returns null string.
if i is greater than the length of x, returns x.
similar to LEFT$(X$, I) in MBASIC. */

	int l;
	if(i == 0) {
		buf[0] = '\0';
		return(0);
	}
	if(i > (strlen(x))) {
		strcpy(buf, x);
		return(0);
	}
	for(l = 0; l < i; l++)
		buf[l] = x[l];
	buf[l] = '\0';
}
rightstr(x, i, buf)
int i;
char *x, *buf;
{

/*this function returns a string of length i characters
from the right side of string x.
if i = 0, returns null string.
if i is greater than the length of x, returns x.
similar to  RIGHT$(X$, I) in MBASIC. */

	if(i == 0) {
		buf[0] = '\0';
		return(0);
	}
	if(i > (strlen(x))) {
		strcpy(buf, x);
		return(0);
	}
	x += ((strlen(x)) - i);
	strcpy(buf, x);
	return(0);
}
getline(fi, s, lim)
/* get a line of chars from file fi into s, with maximum of lim chars */
/* if lim is not reached, will return a newline at the end */
char s[];
int lim;
unsigned fi;
{
	int c, i;
	i = 0;
	while (--lim > 0 && (c = fgetc(fi)) != -1 && (c & 127) != '\n') {
		c = c & 127;
		s[i++] = c;
	}
	if ((c & 127) == '\n')
		s[i++] = c & 127;
	s[i] = '\0';
	return(i);
}
char *strsave(s)
/* saves string s, and returns a pointer to the location */
char *s;
{
	char *p, *malloc();
	if ((p = malloc(strlen(s)+1)) != 0)
		strcpy(p,s);
	return(p);
}
getn(fi, w)
/* get the next ascii number string from file fi, and return it in w */
char *w;
unsigned fi;
{
	int c, t;
	c = fgetc(fi);
	while(c != EOF && (isdigit(c) == 0))
		c = fgetc(fi);
	if(c == EOF)
		return(EOF);
	while(c != EOF)
		{
		c &= 127;
		if(isdigit(c))
			*w++ = c;
		else
			{
			*w = '\0';
			return(1);
			}
		c = fgetc(fi);
		}
	return(EOF);
}
getbits(x, p, n)
/* this function is handy for extracting the value of a range of bit
positions in a number, and finds good use when doing system calls
where certain bit positions have value. It returns an int value of
the bits.  NOTE: get n bits from x, beginning at position p, as per
K & R book, p. 45; but the thing is, it gets them from the position p
DOWN! So, to get bits 5, 6 & 7 from number x, specify as follows:
valbits = getbits(x, 7, 3);  See what I mean? 
*/
int x, p, n;
{
	return((x >> (p+1-n)) & ~(~0 << n));
}
getpgrf(fi, s)
/* This function returns a paragraph of text from file fi, in string s.
A paragraph is defined as a string of text terminated by a doublespace.
(Two newlines). */
char *s;
unsigned fi;
{
	int d, c, i;
	i = 0;
	while ((c = fgetc(fi)) != EOF) 
		{
		s[i++] = (c & 127);
		if((d = fgetc(fi)) != EOF)
			if((c == '\n') && ((d & 127) == '\n'))
				break;
		else
			ungetc(d, fi);
		}
	s[i] = '\0';
	if(c == EOF || d == EOF)
		return(EOF);
	else
		return(i);
}
frame(row, col, hgt, wdth)
/* frame makes a window frame on the crt. */
int row, col, hgt, wdth;

{
	int x, y;
    

	cls(); 
	putcur(row, col); 
	putchar(201);
    for(x = col + 1; x <=(col + wdth -1); x++)
     	putchar(205);
        putchar(187);
        for(x = row + 1; x <=(row + hgt - 1); x++){
        putcur(x, col);    
        putchar(186);
        putcur(x, col+wdth);
        putchar(186);
   }
    putcur(x, col);  
    putchar(200);
    for(x= col + 1; x <=(col + wdth -1); x++)
    	putchar(205);
    	putchar(188);	
}
logo(program, name)
/* makes an attractive display of program and author's name on
the CRT.  */
char *program, *name;
{
	int i, c, z;
	char *string(), a1[3], a2[3];
	a1[0] = 'B';
	a1[1] = '\0';
	a2[0] = 'Y';
	a2[1] = '\0';
	beep();
	cls();
	c = 10;
	disp(c, a1, a2, program, name);
	program = string(' ',(strlen(program)));
	a1[0] = ' ';
	a2[0] = ' ';
	name = string(' ',(strlen(name)));
	c= 9;
	disp(c, a1, a2, program, name);
	for(z=1; z < 30000; z++)
		;
}
disp(c, a1, a2, a, a3)
/* function disp is required for the logo function */
int c;
char *a1, *a2, *a, *a3;
{
	int i, j, jj;
	for(i=1; i <= c; i++)
		{
		j = strlen(a);
		j /= 2;
		j = 40-j;
		putsa(a, 0x07, i, j);
		j = 4*i;
		putsa(a1, 0x07, 12, j);
		j = 81-(4*i);
		putsa(a2, 0x07, 12, j);
		j = 24-i;
		jj = 41 - ((strlen(a3))/2);
		putsa(a3, 0x07, j, jj);
		}
}
writeca(c, a, cnt)
/* writes char c with attribute a cnt times beginning at current cursor position */
char c, a;
int cnt;
{
/*
Some attribute values:
REVERSE VIDEO & BLNK	= 0xf0;
REVERSE VIDEO		= 0X70;
NORMAL BUT WITH BLNK 	= 0X87;
NORMAL WITH NOBLNK 	= 0x07;
*/
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.bh = 0;
	inr.h.bl = a;
	inr.h.al = c;
	inr.x.cx = cnt;
	inr.h.ah = 9;
	int86x(0x10, &inr, &outr, &segr);
}
scrlwnd(brow,bcol,erow,ecol,atr,num)
/* scroll a window down. */
char brow,bcol,erow,ecol,atr,num;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ch = brow;
	inr.h.cl = bcol;
	inr.h.dh = erow;
	inr.h.dl = ecol;
	inr.h.bh = atr;
	inr.h.al = num;
	inr.h.ah = 7;
	int86x(0x10, &inr, &outr, &segr);
}
scrlwnu(brow,bcol,erow,ecol,atr,num)
/* scroll a window up. */
char brow,bcol,erow,ecol,atr,num;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ch = brow;
	inr.h.cl = bcol;
	inr.h.dh = erow;
	inr.h.dl = ecol;
	inr.h.bh = atr;
	inr.h.al = num;
	inr.h.ah = 6;
	int86x(0x10, &inr, &outr, &segr);
}
curtype(bgn, end)
/* set the cursor type. beg=0,end=12 for block, beg=11,end=12 for normal */
char bgn, end;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ch = bgn;
	inr.h.cl = end;
	inr.h.ah = 1;
	int86x(0x10, &inr, &outr, &segr);
}
setmode(mode)
/* set the video mode. Returns 1 if not equipped; EOF if bad mode; 0 if ok */
char mode;
{
/* 	0 = 40x25 b&w 
	1 = 40x25 color
 	2 = 80x25 b&w
	3 = 80x25 color
	4 = 320x200 color
	5 = 320x200 b&w
	6 = 640x200 b&w
*/
	int equip;
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
/* return EOF if invalid mode */
	if(mode > 6)
		return(EOF);
	/* now get equipment to see if color or mono */
	int86x(0x11, &inr, &outr, &segr);
	equip = getbits(outr.x.ax, 5, 2);
/* returns: 	1 = 40x25 color card
		2 = 80x25 color card
		3 = monochrome */
	if(equip < 3)
		{
		inr.h.al = mode;
		inr.h.ah = 0;
		int86x(0x10, &inr, &outr, &segr);
		return(0);
		}
	else
		return(1); /* not equipped */
}
statins()
/* see if INS is on */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 7, 1));	/* Insert on */
}	
statcaps()
/* SEE IF CAPS LOK IS ON */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 6, 1));	/* caps lok on */
}
statnum()
/* SEE IF NUM LOK IS ON */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 5, 1));	/* num lok on */
}
statscrl()
/* SEE IF SCROLL LOK IS ON */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 4, 1));	/* scroll lok on */
}
statshalt()
/* SEE IF SHIFT/ALT IS PRESSED */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 3, 1));	/* shift/alt pressed */
}
statshcrl()
/* SEE IF SHIFT/CTRL IS PRESSED */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 2, 1));	/* shift/ctrl pressed */
}
statlshf()
/* SEE IF LEFT-SHIFT KEY IS PRESSED */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 1, 1));	/* left shift pressed */
}
statrshf()
/* SEE IF RIGHT-SHIFT KEY IS PRESSED */
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 2;
	int86x(0x16, &inr, &outr, &segr);
	return(getbits(outr.h.al, 0, 1));	/* right shift pressed */
}
writech(c, cnt)
/* write char c cnt times beginning at current cursor position */
char c;
int cnt;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.bh = 0;
	inr.h.al = c;
	inr.x.cx = cnt;
	inr.h.ah = 10;
	int86x(0x10, &inr, &outr, &segr);
}
char *string(c, len)
/* returns a pointer to a string of character c, len long */
char c;
int len;
{
	int i;
	char *s_tr, *malloc();
	s_tr = malloc(len+1);
	for(i=0; i < len; i++)
		s_tr[i] = c;
	s_tr[i] = '\0';
	return(s_tr);
}
double getdbl()
/* returns a double input as an ascii string at current cursor position */
{
	double atof(), val;
	char *s, *malloc();
	int rowcol, row, col, dot, i, j, len;
	s = malloc(50);
	getcur(&row, &col);
ngd:	gets(s);
	len = strlen(s);
	for(i = 0; i < len; i++)
		if((s[i] < 48 && s[i] != 46) || s[i] > 57)
			{
			putcur(row, col);
			writech(' ', len);
			putcur(row, col);
			goto ngd;
		}
	val = atof(s);
	return(val);
}
long getlong()
/* returns a long input as an ascii string at current cursor positon */
{
	long atol(), val;
	char *s, *malloc();
	int rowcol, row, col, dot, i, j, len;
	s = malloc(50);
	getcur(&row, &col);
ngd:	gets(s);
	if((len = strlen(s)) > 10)
			{
			putcur(row, col);
			writech(' ', len);
			putcur(row, col);
			goto ngd;
			}
	if(len == 10 && s[0] > 1)
			{
			putcur(row, col);
			writech(' ', len);
			putcur(row, col);
			goto ngd;
			}
	for(i = 0; i < len; i++)
		if(s[i] < 48 || s[i] > 57)
			{
			putcur(row, col);
			writech(' ', len);
			putcur(row, col);
			goto ngd;
		}
	val = atol(s);
	return(val);
}
getint()
/* returns an int input as an ascii string at current cursor position */
{
	int atoi(), val;
	char *s, *malloc();
	int rowcol, row, col, dot, i, j, len;
	s = malloc(50);
	getcur(&row, &col);
ngd:	gets(s);
	len = strlen(s);
	for(i = 0; i < len; i++)
		if(s[i] < 48 || s[i] > 57)
			{
			putcur(row, col);
			writech(' ', len);
			putcur(row, col);
			goto ngd;
		}
	val = atoi(s);
	return(val);
}
getcur(row, col)
/*  Return current cursor position.
USAGE:  getcur(&row, &col); with row and col as ints */
int *row, *col;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.bh = 0;
	inr.h.ah = 3;
	int86x(0x10, &inr, &outr, &segr);
	*row = outr.h.dh;
	*col = outr.h.dl;
}
putcur(row, col)
/* put the cursor to col, row */
char row, col;
{
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.bh = 0;	/* page zero */
	inr.h.dh = row;
	inr.h.dl = col;
	inr.h.ah = 2;
	int86x(0x10, &inr, &outr, &segr);
}
getkb()
/* gets a keyboard character, with scan code in bits 7-4, character in 
bits 3-0. use getbits to extract from return value. */
{
	int c;
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 0;
	int86x(0x16, &inr, &outr, &segr);
	c = outr.x.ax;
	return(c);
}
getfk()
/* gets an extended key code (function or alt-key character). */
{
	int c;
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	inr.h.ah = 0;
	int86x(0x16, &inr, &outr, &segr);
	c = outr.h.ah;
	return(c);
}
putcom(port, c)
/* puts a character to com1 or Com2.  port for
   Com1 = 1, Com2 = 2 */
char c;
int port;
{
	long q;
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	if(port == 2)
		port = 1;
	else
		port = 0;
	inr.h.ah = 1;
	inr.h.al = c;
	inr.x.dx = port;
	int86x(0x14, &inr, &outr, &segr);
}
initcom(port)
/* initializes Hayes Smartmodem */
char port;
{
		long q;
		if(port == 2)
			port = 1;
		else
			port = 0;
		putcom(port, 'A');
		putcom(port, 'T');
		putcom(port, 'Z');
		putcom(port, 13);
		for(q=0L; q<50000L; q++);
}
hangup(port)
/* hangs up the comport 'port'. 1 = Com1:, 2 = Com2: */
char port;
{
		if(port == 2)
			port = 1;
		else
			port = 0;
		putcom(port, 'A');
		putcom(port, 'T');
		putcom(port, 'H');
		putcom(port, 13);
}
dial(port, num)
/* dials the number string in num via Hayes Smartmodem attached to port. 1=Com1:
2=Com2:
char *num;
{
	long q;
	int i, len;
	if(port == 2)
		port = 1;
	else
		port = 0;
	len = strlen(num);
	for(q=0L; q < 10000L; q++);
	putcom(port, 'A');
	putcom(port, 'T');
	putcom(port, 'D');
	putcom(port, 'T');
	for(i = 0; i < len; i++)
		putcom(port, num[i]);
	putcom(port, 13);
}
putsa(s, a, row, col)
/* put string s to console with attribute a beginning at row, col */
char *s, a;
int row, col;
{
	int i;
	for(i = 0; s[i] != '\0'; i++)
		{
		putcur(row, col++);
		writeca(s[i], a, 1);
		}
}
getca(c, row, col)
/* Read character and attribute at cursor position. */
/* Usage:  attr = getca(&c, row, col); */
char *c;
int row, col;
{
	int attr;
	union REGS inr;
	union REGS outr;
	struct SREGS segr;
	segread(&segr);
	putcur(row, col);
	inr.h.ah = 8;
	inr.h.bh = 0;
	int86x(0x10, &inr, &outr, &segr);
	*c = outr.h.al;
	attr = outr.h.ah;
	return(attr);
}
