/***********************************************************************
 *  ASM4QC, Assembly routines for QuickC                               *
 *  Version 2.02, Copyright (c) 1989-90 SoftCircuits (tm)              *
 *                                                                     *
 *  ASM4QC.H, ASM4QC header file                                       *
 *  C source code                                                      *
 ***********************************************************************/

struct vconfig {                 /* structure for getvconfig() */
	unsigned int vsegment;      /* video segment */
	unsigned int vmode;         /* video mode */
	unsigned int vpage;         /* video page */
	unsigned int textrows;      /* number of text rows */
	unsigned int textcols;      /* number of text columns */
	unsigned int snowcheck;     /* snow checking status */
	int vcombo;                 /* video display combination code */
};

/* function declarations for data4qc (global data for ASM4QC library) */
int  _color(int);
void getvconfig(struct vconfig *);
int  initvideo(void);
int  setbackcolor(int);
int  setdefvenv(void);
int  setforecolor(int);
void setsnowcheck(int);
void setvoff(int,int);
int  setvsegment(int);

/* function declarations for stdvideo (standard video routines) */
void biosprintsa(char *);
void cls(void);
int  curscol(void);
int  cursrow(void);
void hidecurs(void);
void repch(char,int);
void restorecurs(void);
void scroll(int,int,int,int,int);
void setborder(void);
void setcurs(int,int);
int  setvmode(int);
int  vmode(void);
int  voffcol(void);
int  voffrow(void);
int  vpage(void);

/* function declarations for extvideo (extended video routines) */
void frame(int,int,int,int);
void hscroll(int,int,int,int,int);
void printa(int,int);
void prints(char *);
void printsa(char *);
int  reada(int,int);
char readc(int,int);
void setframetype(char,char,char,char,char,char);

/* function declarations for window (windowing routines) */
void restorewin(int *,int,int,int,int);
void savewin(int *,int,int,int,int);

/* function declarations for kbdio (keyboard input/output) */
void beep(int,int);
int  edstring(char *,int);
int  getkey(void);
int  kbded(char *,int);
void kbdflush(void);
void pause(int);

/* macros */
#define  foreback(f,b) ((f & 0x0F) | ((f & 0x10) << 3) | ((b & 0x07) << 4))
#define  color(f,b) _color(foreback(f,b))
#define  getasciicode() (getkey() & 0x00FF)
#define  getscancode()  (getkey() >> 8)
#define  setdoubleframe() \
	setframetype('\xCD','\xBA','\xC9','\xBB','\xC8','\xBC')
#define  setsingleframe() \
	setframetype('\xC4','\xB3','\xDA','\xBF','\xC0','\xD9')

/* constants */
#define  TRUE        1
#define  FALSE       0
#define  ON          1
#define  OFF         0
#define  MONO_SEG    0xB000
#define  COLOR_SEG   0xB800

/* attribute constants */
#define  BLACK       0x00
#define  BLUE        0x01
#define  GREEN       0x02
#define  CYAN        0x03
#define  RED         0x04
#define  MAGENTA     0x05
#define  YELLOW      0x06
#define  WHITE       0x07
#define  BOLD        0x08
#define  BLINKING    0x10

/* key constants as returned by getkey */
#define  ESCAPE_KEY     0x011B
#define  BACKSPACE_KEY  0x0E08
#define  TAB_KEY        0x0F09
#define  SHIFTTAB_KEY   0x0F00
#define  RETURN_KEY     0x1C0D
#define  F1_KEY         0x3B00
#define  F2_KEY         0x3C00
#define  F3_KEY         0x3D00
#define  F4_KEY         0x3E00
#define  F5_KEY         0x3F00
#define  F6_KEY         0x4000
#define  F7_KEY         0x4100
#define  F8_KEY         0x4200
#define  F9_KEY         0x4300
#define  F10_KEY        0x4400
#define  HOME_KEY       0x4700
#define  UP_KEY         0x4800
#define  PGUP_KEY       0x4900
#define  LEFT_KEY       0x4B00
#define  CENTER_KEY     0x4C00
#define  RIGHT_KEY      0x4D00
#define  END_KEY        0x4F00
#define  DOWN_KEY       0x5000
#define  PGDN_KEY       0x5100
#define  INSERT_KEY     0x5200
#define  DELETE_KEY     0x5300
