/* 43/50 line screen mode functions */

#include <dos.h>

#define CGASIZE 24     /* bottom line, CGA/normal text screen */
#define EGASIZE 42     /* bottom line, EGA extended text screen */
#define VGASIZE 49     /* bottom line, VGA extended text screen */

/* video adapter constants */
#define MDA_CARD    0     /* monochrome display adapter */
#define CGA_CARD    1     /* color graphics adapter */
#define EGA_CARD    2     /* enhanced graphics adapter */
#define VGA_CARD    3     /* video graphics array */
#define MCGA_CARD   4     /* multi-color graphics array */
#define HERC_CARD   5     /* Hercules card */

#define VIDEO() int86(0x10,&regs,&regs)

#define FALSE 0
#define TRUE 1


 
  
int ext_screen(int video_card)  /* set 43-line (EGA) or 50-line (VGA) text */

{
	/* Local variables */
	union REGS regs;
	
	int screen_size;
	
	switch(video_card){
		case EGA_CARD: {
			screen_size=EGASIZE;
		}
    		break;
		case VGA_CARD: {
			screen_size=VGASIZE;
		}
		break;
		default: {
         		screen_size=CGASIZE; 
			return screen_size;
		}
	}
  
	regs.x.ax=0x1112;             /* load 8x8 font */
	regs.h.bl=0x00;
  
	VIDEO();
  
	regs.x.cx=0x0600;             /* set cursor size */
	regs.h.ah=0x01;
  
	VIDEO();
  
	outp(0x03b4, 0x0714);         /* fix up underline */
  
	return screen_size;
	
}
 



int normal_screen(video_card)  /* restore 25-line text */

{
	/* Local variables */
	union REGS regs;
	
	int screen_size;

	if(video_card!=MDA_CARD){         /* if not in monochrome mode */
		regs.x.ax=0x0003;
		VIDEO();
	}
  
	screen_size=CGASIZE;
  
	return screen_size;
	
}




int screen_lines()  /* Read current screen line setting */

{
	/* Local variables */
	int lines;
	
	lines=peekb(0x40,0x84);
	
	if (lines==0)
		lines=24;
	
	return (lines+1);
}
