/* CJSLIB */

/* Typedefs */
typedef struct {
	char spec_func;		/* special functions */
	char	dev_type;			/* device type */
	int	dev_attr;			/* device attributes */
	int	cyl;				/* number of cylinders */
	char	med_type;			/* media type */
	int	bytes_psec;		/* bytes per sector */
	char	secs_pclus;		/* sectors per cluster */
	int	res_secs;			/* reserved sectors */
	char	fats;			/* number of file allocation tables */
	int	root_ent;			/* max root directory entries */
	int	sectors;			/* total number of sectors */
	char	media;			/* media descriptor */
	int	fat_secs;			/* number of sectors per FAT */
	int	secs_ptrk;		/* number of sectors per track */
	int	heads;			/* number of heads */
	int (far *hid_secs)();	/* number of hidden sectors */
	int (far *huge_secs)();	/* number of sectors (>32k partition) */
	
} DEVPARAMS;

typedef struct {
	char infolevel;		/* information level */
	long serialnum;		/* volume serial number */
	char vollabel[11];		/* volume label */
	char filesystype[8];	/* file system type */
	
} MID;

typedef char far * FPTR;


/* #defines */
/* video adapter constants */
#define MDA_CARD    0     /* monochrome display adapter */
#define CGA_CARD    1     /* color graphics adapter */
#define EGA_CARD    2     /* enhanced graphics adapter */
#define VGA_CARD    3     /* video graphics array */
#define MCGA_CARD   4     /* multi-color graphics array */
#define HERC_CARD   5     /* Hercules card */


/* Function declarations */
int sounder();
int menubox(int r1,c1,r2,c2,color,boxtype,shadow,shade,max_rows);
int text_box(int r1,c1,r2,c2,fill,color,max_rows);
int color_time(char *format,int r1,c1,color,max_rows);
int colortext(char text[], int r1, int c1, int color,max_rows);
int colortext2(char text[], int r1, int c1, int color, int hilite, int hpos,max_rows);
int repchar(char *s, char c, r);
int remchar(char *s, char c);
int pick_color();
int ext_screen(int video_card);
int normal_screen(video_card);
int screen_lines();
int play_cm1(char *song);
int clear(int color);
int Mstr_delenv (char far *Env, unsigned EnvSize, char far *name);
int Mstr_putenv (char far *Env, unsigned EnvSize, char far *name);
int get_dtype(int drive);
int get_banv();
int get_files();
int check_time(char *this_time);
int line_input(char *text, int text_length, int display_length);
int random_files(char *mask, char *filename);

char *dirselect(char*, int);

char far *Mstr_getenv (char far *Env, char far *name);

void Mstr_FindEnvironment (char far **Env, unsigned *EnvSize);
void remove_chars();
void remove_digits();
void epsonize(char *s, int c);


