/**************************************************************************/
/*         Calculate  by  dropping a pin on a wood plank floor.          */      
/*       If any part of the pin touches the "crack" between boards,       */
/*                            it is a HIT.                                */
/*     is calculated from the ratio of hits to total drops of the pin.   */
/*                                                                        */
/*                           Mendel Cooper                                */
/*                          3138 Foster Ave.                              */
/*                         Baltimore, MD 21224                            */
/*                                                                        */
/*                                06/91                                   */
/*             Source code placed in the public domain.                   */
/**************************************************************************/



/* May need #include <math.h> */
#define MAX 32000

/*********************************************************************/
/*                            GET_SEED                               */  
/*     Returns 4-digit random seed from BIOS time (up to 5959)       */
/*********************************************************************/

int get_seed()

{
char  *time, *gettime(),time$[5];
int j;

time = gettime();

*(time$) = *(time + 3);
*(time$ + 1) = *(time + 4);
*(time$ + 2) = *(time + 6);
*(time$ + 3) = *(time + 7);
*(time$ + 4) = '\0';

     j = atoi(time$);

     return (j);

}

/**********************************************************************/
/*                           GETRAND()                                */
/*               Outputs random number (0.0 - 1.0)                    */
/**********************************************************************/

double getrand()

{
int random;   /*number generated by rand() function*/
double scale_factor = 32768.0;   /*scaling factor*/
double dx;         /*Random number between 0.0 and 1.0 returned by fn*/
                   /* X-coordinate of one end of the dropped pin */

srand(get_seed());  /*seeds random generator*/

random = rand();

dx = (double)random / scale_factor;

return (dx);
}


/**********************************************************************/
/*                           GETANGLE()                               */
/*               Outputs random number (0.0 - 180.0)                  */
/**********************************************************************/

double getangle()

{
int random;   /*number generated by rand() function*/
double scale_factor = 182.039;   /*scaling factor*/
double angle;      /*Random number between 0.0 and 180.0 returned by fn*/
                   /* Angle to the horizontal of the dropped pin */

srand(get_seed());  /*seeds random generator*/

random = rand();

angle = (double)random / scale_factor;

return (angle);
}

/**************************************************************************/

main()
{
double cos(), getrand(), getangle();
double Dx, theta, ratio, Pi;
int hits = 0, drops = 0, getseed();


clrscrn();       /* Clears screen.  You may delete this line if error. */


while (drops < MAX) {      /*integer value, still...*/

drops++;

Dx =  getrand();   /*Generate horizontal position of one end of the pin*/
theta = getangle();   /* Angle of the pin from the horizontal */

if (theta <= 90.0)
   if ( Dx + cos(theta) >= 1)
      hits++;

if (theta > 90.0)
   if ( (Dx - cos (180.0 - theta)) <= 0 )
      hits++;

ratio = (double)hits / (double) drops;

printf("Drops = %5d   ---   Hits = %5d               ============>    %f \n",
        drops, hits, 10.0 * ratio);

}
}
