/* lprgraf.c     Copyright (c) 1992 Kevin Stokes, Pie in the Sky Software */

#include <stdio.h>
#include <math.h>
#include <malloc.h>

extern char far *fptr;
extern FILE *lptptr;

lprinit()
{
	fptr=farcalloc( (unsigned long) 720*90, (unsigned long) sizeof(char));
	   if(fptr==NULL) {printf("\nOut of RAM!\n"); exit(0); }
	lptptr=fopen("PRN","wb");
	if(lptptr == NULL) {printf("can't open PRN device for writing\n");
                 exit(0); }
	setlinesp(24);
}


lprprint()
{
	int linesp,i,randn;
        unsigned char cdata;
	unsigned long ilong,icol,irow;
/*	lprdrawline(10,10,700,700); */
	for(irow=0; irow < 90; irow=irow+3)	
        {
	lpremit(0x0d);
	lpremit(27);
	lpremit(0x2a);
	lpremit(39);
	lpremit(208);
	lpremit(2);
	for(icol=0; icol < 720; icol++)
	  {
	     ilong=icol*90+irow;
             cdata=*(fptr+ilong);
	     lpremit(cdata);	
             cdata=*(fptr+ilong+1);
	     lpremit(cdata);	
             cdata=*(fptr+ilong+2);
	     lpremit(cdata);	
          }
	lpremit(0x0d);
	lpremit(0x0a);
	}
	lpremit(0x0d);
	lpremit(0x0a);
	for(ilong=0; ilong < 64800L; ilong++)  /* clear page */
           *(fptr+ilong)=0;
}

void setlinesp(nlinesp)
int nlinesp;
{
	if((nlinesp < 0)||(nlinesp > 255)) { 
		printf("\nLinespace value out of range : %d \n",nlinesp);
	}
        else
        {
	lpremit(27);
	lpremit(0x33);
	lpremit(nlinesp);
	printf("\nLine spacing set to %d 180/ths of an inch \n",nlinesp);
	}
}

void erroob(ix,iy)
{
printf("\nError: Setpoint out of bounds : %d %d \n",ix,iy);
exit(0);
}

void setpoint(ix,iy)
int ix,iy;
{
unsigned long ilong;
unsigned char databit;

if((ix<0)||(ix>719)||(iy<0)||(iy>719)) erroob(ix,iy);

databit=128 >> (iy & 7);
ilong=iy/8+ix*90;
*(fptr+ilong)=*(fptr+ilong)|databit;
}

void lprdrawline(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
float t,delt,length,i;
double ddx,ddy;
int ix,iy,nt;
ddx=(double) (x2-x1);
ddy=(double) (y2-y1);
length= (float) sqrt( ddx*ddx + ddy*ddy);
delt=1./3.;
nt=(int) (length/delt+.5);
for(i=0; i < nt; i++)
  {
  ix=(int) ( (float) i*ddx/(float) nt +(float) x1+.5) ;
  iy=(int) ( (float) i*ddy/(float) nt + (float) y1+.5) ;
  setpoint(ix,iy);
  }
}

void lpremit(lchar)
char lchar;
{
	fwrite(&lchar,sizeof(char),1,lptptr);	
}
