/* Pumpkin.C                                                                */
/* Copyright (c) Genus Microprogramming, Inc. 1988-91  All Rights Reserved. */

/****************************************************************************

  This program is a C program using the GX Effects and the PCX Programmer's 
  Toolkit to illustrate the use of the Sound Blaster voice support in FX, 
  and how to combine the two.

  To Compile: Microsoft C 6.x   cl  /AS pumpkin.c /link gx_cs pcx_cs fx_cs

              Quick     C 2.x   QC  pumpkin
                                (Specify a MAK file, 4 lines: pumpkin.c  )
                                (                             gx_cs.lib  )
                                (                             pcx_cs.lib )
                                (                             fx_cs.lib  )
                                (press "F5" to run                       )
                           or   QCL /AS pumpkin.c /link gx_cs pcx_cs;

              Turbo     C 2.x   tc  pumpkin
                                (Specify a PRJ file, 4 lines: pumpkin.c  )
                                (                             gx_cs.lib  )
                                (                             pcx_cs.lib )
                                (                             fx_cs.lib  )
                                (and press "Ctrl-F9" to run              )
                           or   tcc  -I\tc\h -L\tc\lib pumpkin gx_cs.lib pcx_cs.lib fx_cs.lib

              Lattice   C 6.x   lc  -ms -L+gx_cs+pcx_cs+fx_cs pumpkin
                                (Use the Microsoft C small model library )


         ***** THIS PROGRAM MAY BE FREELY COPIED AND DISTRIBUTED *****


  Microsoft C version 6.0                 Programmer : Chris Howard 10/31/91

*****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifndef LATTICE
#include <conio.h>
#endif

/* Include GX Development Series defines */
#include "gxlib.h"
#include "pcxlib.h"
#include "fxlib.h"

/* Local defines */
#define  MAXIMAGES   5                 /* Maximum pumpkin images          */
#define  MAXFRAMES   15                /* Maximum frames in pumpkin       */
#define  DELAYBASE   10                /* Delay base between frames       */
#define  X1          150               /* Position of pumpkin frames      */
#define  Y1          250               /*                                 */
#define  X2          400               /*                                 */
#define  Y2          410               /*                                 */

/* Globals variables */
int      gxtype    = gxVGA_12;         /* GX Display type                 */
int      memtype   = gxCMM;            /* GX Memory  type                 */
int      libtype   = gxEXE;            /* GX Library type                 */
char     libname[] = "pumpkin.EXE";    /* GX Library name                 */
char     pvoice[]  = "pumpkin.VOC";    /* Pumpkin voice file              */

/*       Sentence:    Ha-ppy Ha-lo-we-en       Ha-ah  Ha-ah  Ha-ah  Ha-ah  end */
int      porder[]  = { 1, 2,  1, 1, 3,  2,  1, 4,  1, 4,  1, 4,  1, 4,  1};
int      pdelay[]  = {20,10, 10,20,20,120, 50,40, 20,30, 15,20, 10,20,200};

GXLIB    lib;                          /* Library header                  */

GXHEADER pumpkin[MAXIMAGES];           /* Pumpkin virtual structures      */

FXSOUND  sh;                           /* Sound structures                */

char     pcxpal[768];                  /* PCX Palette buffer              */
char     bucket[1024];                 /* GX Library bucket               */
char     buffer[24*1024];              /* GX Kernel buffer                */

int      retcode;                      /* General return code             */

/**********/

/*
 * This function loads all of the images, and the necessary voice files.
 *
 */

int  InitSystem(void)
{
  char filename[64];
  long ssize;
  int  imagenum = 0;
  int  i,ok;

  /* Assume not successful */
  retcode = !gxSUCCESS;

  /* Create sound buffer */
  ssize = fxLibSoundSize(&lib,pvoice,fxVOC);
  retcode = fxCreateSound(&sh,fxVOC,ssize);
  if (retcode == fxSUCCESS) {

    /* Load the VOC sound */
    retcode = fxLibSound(&lib,pvoice,&sh);
    if (retcode == fxSUCCESS) {

      /* Load the images */
      ok = gxTRUE;
      while (ok && (imagenum < MAXIMAGES)) {

        /* Format the image name */
        sprintf(filename,"pumpkin%1d.PCX",imagenum);

        /* Load it */
        retcode = pcxLibImage(memtype,&lib,filename,&pumpkin[imagenum],gxtype);
        if (retcode != gxtype) {

          /* The image did not load, so free loaded images */
          for (i=imagenum-1; i>=0; i--) {
            retcode = pcxFreeImage(&pumpkin[i]);
          }

          /* Set flag */
          ok = !ok;

        }

        /* Bump */
        imagenum++;

      }

      /* Were the images successfully loaded? */
      if (ok) {
        /* Yes, so successful */
        retcode = gxSUCCESS;
      }

    }

  }

  /* Return whether successful */
  return(retcode);
  
} /* end of InitSystem */

/**********/

/*
 * This function cleans up before exiting, removing loaded images and
 * voice files.
 *
 */

void ExitSystem(void)
{
  int  i;

  /* Free all images */
  for (i=MAXIMAGES-1; i>=0; i--) {
    retcode = pcxFreeImage(&pumpkin[i]);
  }

  /* Free the voice file */
  retcode = fxDestroySound(&sh);

} /* end of ExitSystem */

/**********/

/*
 * This function simply displays the exit information screen.
 *
 */

void  DisplayInfo(void)
{

  printf("յ Pumpkin Info ͸\n");
  printf("                                                                           \n");
  printf("  Pumpkin was written using the power of the Genus GX Development Series.  \n");
  printf("                                                                           \n");
  printf("  The GX Development Series supports C, Pascal, Basic, Fortran, Clipper    \n");
  printf("  and Assembly Language. The products include GX Graphics, GX Effects,     \n");
  printf("  GX Text, and the PCX Toolkit. All are written entirely in Assembly       \n");
  printf("  and support CGA, HERC, EGA, VGA, and Super VGA modes.                    \n");
  printf("                                                                           \n");
  printf("  For more information, contact:                                           \n");
  printf("                                                                           \n");
  printf("                      Genus Microprogramming, Inc.                         \n");
  printf("                      2900 Wilcrest, Suite 145                             \n");
  printf("                      Houston, TX 77042-3355 USA                           \n");
  printf("                                                                           \n");
  printf("                      (713) 870-0737  Main                                 \n");
  printf("                      (800) 227-0918  Sales/Questions                      \n");
  printf("                      (713) 977-0680  Support                              \n");
  printf("                      (713) 870-0288  Fax                                  \n");
  printf("                      (713) 266-9362  BBS                                  \n");
  printf("                      GO GENUS        CompuServe                           \n");
  printf("                                                                           \n");
  printf(";\n");

} /* end of DisplayInfo */

/**********/

/*
 * This function actually makes the pumpkin talk.
 *
 */

void PumpkinTalk(void)
{

  int  f;

  /* Set up effect parameters */
  retcode = fxSetEffect(fxRANDOM);

  /* Display first image with an effect, before talking */
  retcode = fxVirtualDisplay(&pumpkin[0],0,0,0,0,639,479,fxNONE);

  /* Play the pumpkin voice */
  retcode = fxPlaySound(&sh,0,1,fxBACK);

  /* Now synchronize the images */
  f=0;
  while ((!kbhit()) && (f < MAXFRAMES)) {

    /* Display the image */
    retcode = gxVirtualDisplay(&pumpkin[porder[f]],0,0,X1,Y1,X2,Y2,0);
    retcode = gxDelay(pdelay[f]*DELAYBASE);

    /* Bump */
    f++;

  }

  /* Wait for sound status to be DORMANT */
  while ((!kbhit()) && (fxGetSoundStatus(fxVOC) == fxACTIVE));

  /* If key has been pressed, kill any remaining sound */
  if (kbhit()) {
    getch();
    retcode = fxKillSound(fxVOC);
  }

  /* Clear the screen */
  retcode = fxClearDisplay(0,0,639,479,gxBLACK,fxNONE);

} /* end of PumpkinTalk */

/**********/

void main(void)
{

  /* Display program header */
  printf("\n");
  printf("͸\n");
  printf(" Pumpkin: A Halloween Program      (MAY BE FREELY COPIED AND DISTRIBUTED) \n");
  printf(" Copyright (c) Genus Microprogramming, Inc. 1988-91  All Rights Reserved. \n");
  printf(";\n");
  printf("\n");

  /* Get a key, to begin */
  printf("Press a key to run . . .");
  getch();
  printf("\n");

  /* Make sure we can display the image with current hardware (need EGA) */
  if (gxVerifyDisplayType(gxtype) == gxSUCCESS) {

    /* See if SoundBlaster is installed */
    if (fxSBInstalled() == fxSUCCESS) { 
    
      /* Check for SoundBlaster */
      retcode = fxInstallSound(fxSOUNDBLASTER);
      if (retcode == fxSUCCESS) {

        /* Open the lib */
        retcode = gxOpenLib(libtype,libname,&lib,bucket,1024);
        if (retcode == gxSUCCESS) {

          /* Load the images and sound files */
          retcode = InitSystem();
          if (retcode == gxSUCCESS) {

            /* Set the display type and mode */
            retcode = gxSetDisplay(gxtype);
            retcode = gxSetMode(gxGRAPHICS);
            if (retcode == gxSUCCESS) {
            
              /* Get the file palette */
              retcode = pcxGetLibPalette(gxtype,&lib,"pumpkin1.pcx",pcxpal);
              if (retcode == pcxSUCCESS) {

                /* Set the display palette */
                retcode = gxSetDisplayPalette(pcxpal);
                if (retcode == gxSUCCESS) {

                  /* Now make the pumpkin talk */
                  PumpkinTalk();

                }
                else {
                  /* Error setting the palette on the display */
                  printf("gxSetDisplayPalette error: %d\n",retcode);
                  getch();
                }
            
              }
              else {
                /* Error getting the palette from the file */
                printf("pcxGetLibPalette error: %d\n",retcode);
                getch();
              }

              /* Return to text mode */
              retcode = gxSetMode(gxTEXT);

            }
            else {
              /* Error setting the mode */
              printf("gxSetMode error: %d\n",retcode);
            }

            /* Clean up */
            ExitSystem();

            /* Display info screen */
            DisplayInfo();

          }

          /* Close the lib */
          retcode = gxCloseLib(&lib);

        }
        else {
          /* Error opening lib */
          printf("gxOpenLib error: %d\n",retcode);
        }

        /* Remove the SoundBlaster driver */
        retcode = fxRemoveSound(fxSOUNDBLASTER);

      }
      else {
        /* Error installing SoundBlaster driver */
        printf("fxInstallSound error: %d\n",retcode);
      }

    }
    else {
      /* Necessary hardware is not available to run this program */
      printf("Error: This program requires a SoundBlaster card to run . . .");
    }

  }
  else {
    /* Necessary hardware is not available to run this program */
    printf("Error: This program requires at least a VGA system to run . . .");
  }

} /* end of main */

