//                                    Copyright John V. Rodley   1994
//
// ARGS.C - A module for processing command line arguments.  CmdArgs[]
// global structure array should be declared in the main() module of the
// program.  

#define INCL_DOS
#define INCL_WIN
#define INCL_WINSHELLDATA
#define INCL_GPI
#define INCL_BITMAPFILEFORMAT

#include <os2.h>

#include <stdio.h>
#include <string.h>
#include "args.h"

extern CMDARG CmdArgs[];


// ShowArgs - Display all the 'help' strings from the command line args
// specified in the CmdArgs structures.
int ShowArgs()
{
    int k;

    for( k = 0; CmdArgs[k].argstring != NULL; k++ )
        fprintf( stderr, "\t%s %s\n", CmdArgs[k].argstring, CmdArgs[k].helpstring );
    return( 0 );
}

// flagset - Tell if the specified flag is set.  returns > 0 if the
// flag is set, and -1 otherwise.
int flagset( int ac, char *av[], char *flag )
{
    int i;
    for( i = 1; i < ac; i++ )
        {
        if( strcmp( av[i], flag ) == 0 )
            return( i );
        }
    return( -1 );
}

// ProcessArgs - Process all the command line arguments, checking them
// against the ones defined in CmdArgs.  returns 0 if  OK, 1 if not
// args not defined in CmdArgs are an error.
int ProcessArgs( int ac, char *av[] )
{
int i, k;
BOOL ArgOk;

// Check for unrecognized args, or for the help string "?"
for( i = 1; i < ac; i++ )
    {
    ArgOk = FALSE;
    if( strcmp( av[i], "?" ) == 0 )
        return( 1 );
    if( strcmp( av[i], "-?" ) == 0 )
        return( 1 );
    for( k = 0; CmdArgs[k].argstring != NULL; k++ )
         {
        if( strcmp( av[i], CmdArgs[k].argstring ) == 0 )
            {
            ArgOk = TRUE;
            i += CmdArgs[k].numargs;
            break;
            }
         }
    if( !ArgOk )
        {
        fprintf( stderr, "Argument %s not recognized\n", av[i] );
        return( 1 );
        }
    }

// Actually process all the args.
for( i = 0; CmdArgs[i].argstring != NULL; i++ )
    {
    if(( k = flagset( ac, av, CmdArgs[i].argstring )) > 0 )
        {
        if( CmdArgs[i].func )
            {
            (*CmdArgs[i].func)( av[k+1] );
            continue;
            }
        if( CmdArgs[i].pFlag )
            *CmdArgs[i].pFlag = CmdArgs[i].SetToThisIfTrue;
        }
    else
        {
        if( CmdArgs[i].pFlag )
            {
            if( CmdArgs[i].SetToThisIfTrue == TRUE )
                *CmdArgs[i].pFlag = FALSE;
            else
                *CmdArgs[i].pFlag = TRUE;
            }
        }
    }

return( 0 );
}


