// NE_EXE.h - The format of the NE Executable type is described here.
//
//	History:
//		JVRodley	6/1/1990	Initial coding
//
//
#ifndef NEEXE_INCLUDED
#define NEEXE_INCLUDED

#define CHAIN_END 0xFFFF

typedef struct SEG_DESC {
   unsigned number;  // the segment number, 1-based
   long file_start;  // The File location.
   long file_end;    //
   unsigned size;
   unsigned num_relocs;
   };


typedef struct relseg_tag {

   long lFileStart;
   long lFileEnd;
   unsigned uSize;
   unsigned uNumRecs;

   }  RELOCATION_SEGMENT;

extern RELOCATION_SEGMENT *RelSegmentList[];

// an entry in a NE Fixup Record Table
struct NEW_REL {
   unsigned char target;   // The type of target (see targets below)
   unsigned char source; // The type of source (see sources below)
   unsigned offset;  // Offset in this segment of target.
   unsigned module_num;  // Module number (see Module Reference entry) 
                        // if source = 1 or 2, segment number if source = 0
   unsigned ordinal;    // target offset if source = 0, function ordinal
                        // if source = 1 and function name offset in 
                        // Imported Name Table if source = 2
   };

// Possible values for target
#define NE_TARG_16SEG   2     // 16-bit segment
#define NE_TARG_16SEGOFS   3  // 16-bit segment, 16-bit offset
#define NE_TARG_16OFS   5  // 16-bit offset
#define NE_TARG_16SEG32OFS   11  // 16-bit segment, 32-bit offset
#define NE_TARG_32OFS   13 // 32-bit offset

// Possible values for source
#define NE_DEST_THISEXE 0     // Source is in this executable.
#define NE_DEST_DLLBYORDINAL 1   // Source is imported by ordinal.
#define NE_DEST_DLLBYNAME  2     // Source is imported by name.

// structure of NE header.  Follows magic bytes "NE" in file.
typedef struct {
   unsigned char ver;   // Version.
   unsigned char rev;   // Revision
   unsigned short enttab;  // File offset of Entry Table from lfanew.
   unsigned short cbenttab;  // Entry Table byte count.
   long crc;               // CRC checksum of entire file.
   unsigned short flags;   // Exe flags (such as ERROR ...)
   unsigned short autodata;   // Segment number of Auto-DS segment, 1-based.
   unsigned short heap; // Segment number of heap, 1-based.
   unsigned short stack;   // Segment number of stack, 1-based.
   unsigned short ip;   // Initial value of IP register.
   unsigned short cs;   // Initial value of CS register.
   unsigned short sp;   // Initial value of SP register.
   unsigned short ss;   // Initial value of SS register.
   unsigned short cseg; // Number of segments in Segment Table.
   unsigned short cmod; // Number of modules in Module Reference Table.
   unsigned short cbnrestab;  // Byte count of Non-Resident Name Table.
   unsigned short segtab;  // File offset of Segment Table from lfanew.
   unsigned short rsrctab; // File offset of Resource Table from lfanew.
   unsigned short restab;  // File offset of Resident Name Table from lfanew.
   unsigned short modtab;  // File offset of Module Reference Table from lfanew.
   unsigned short imptab;  // File offset of Imported Name Table from lfanew.
   unsigned long nrestab;  // File offset of Non-Resident Name Table from beginning of file.
   unsigned short cmovent; // Number of movable entries.
   unsigned short align;   // File sector size, Segments are aligned on boundaries of this value.
   unsigned short cres; // Item count of Resource Table.
   char resv[10]; // reserved.
   } NE_EXE;

extern NE_EXE newexe;

   /* flags */
   #define NENOTP 0x8000
   #define NEIERR 0x2000
   #define NEWCPT 0x0200
   #define NEWAPI 0x0100
   #define NEFLTP 0x0080
   #define NEI386 0x0040
   #define NEI286 0x0020
   #define NEI086 0x0010
   #define NEPROT 0x0008
   #define NEPPLI 0x0004
   #define NEINST 0x0002
   #define NESOLO 0x0001

   /* resv */
   #define NELFNS 0x01
   #define NE_OS2 0x01
   #define NEWIND 0x02

// an entry in the NE Segment Table
struct SEG {
   unsigned short ns_sector;  // The file sector segment starts at.
   unsigned short ns_cbseg;   // The number of bytes in segment image.
   unsigned short ns_flags;   // Type of segment (code,data ...)
   unsigned short ns_minalloc;   // Minimum size in memory.
   };

#define RELOCATION_AVAIL 0x0100



   #define NSTYPE 0x0007
   #define NSCODE 0
   #define NSDATA 1
   #define NSITER 0x0008
   #define NSMOVE 0x0010
   #define NSPURE 0x0020
   #define NSPRELOAD 0x0040
   #define NSEXRD 0x0080
   #define NSRELOC 0x0100
   #define NSCONFORM 0x0200
   #define NSDPL 0x0c00
   #define SHIFTDPL 10
   #define NSDISCARD 0x1000
   #define NS32BIT 0x2000
   #define NSHUGE 0x4000

struct IMP_NAME {
   unsigned index;
   unsigned short offset;
   char name[255];
   };

// an entry in NE Module Reference Table.
struct MOD_REF {
   unsigned index;   // An index into the Imported Name Table.
   unsigned uModNum; // The module number used by Fixup Records trying to use this Module Reference.
   };

struct RES_NAME {
   unsigned ordinal;
   char name[255];
   };

struct NONRES_NAME { 
   unsigned ordinal;
   char name[255];
   };

struct ENTRY_BUNDLE {
   unsigned char num;
   unsigned char type;
   char placeholder;
   };
// bundle types
#define EB_MOVEABLE_SEGMENT   0xFF
#define EB_NULL_BUNDLE   0x00

struct ENTRY_FIXED {
   unsigned char flags;
   unsigned short offset;
   };
      
struct ENTRY_MOVEABLE {
   unsigned char flags;
   char signature[2];   // == 0xCD, 0x3F
   unsigned char seg;
   unsigned short offset;
   };
      
struct ENTRY {
      unsigned seg;
      unsigned offset;
      unsigned flags;
      unsigned ordinal;
       };

struct RESOURCE {
int dummy;
};

#define MAX_SEGMENTS 300
#define MAX_MODREFS 300
#define MAX_IMPNAMES 300
#define MAX_RESNAMES 300
#define MAX_NONRESNAMES 600
#define MAX_ENTRIES 600
#define MAX_RELOCATIONS 300
#define MAX_RESOURCES 300

extern struct SEG *SegmentList[];
extern struct SEG_DESC *SegmentDescList[];
extern struct NEW_REL *RelocationList[];
extern struct RES_NAME *ResNameList[];
extern struct MOD_REF *ModRefList[];
extern struct IMP_NAME *ImpNameList[];
extern struct ENTRY *EntryList[];
extern struct NONRES_NAME *NonResNameList[];
extern struct RESOURCE *ResourceList[];
extern RELOCATION_SEGMENT *RelSegmentList[];
extern long RelocationFileLoc[];
extern unsigned uRelIndex;
extern unsigned RelocationTailList[];

extern long lModRef;
extern long lEntTab;

extern int Read_NEExe(void);
extern int DumpNEExeHdr(void);
extern int DumpNETables(void);
extern void FreeNETables(void);

/* Return values from ReadExe() */
#define VALID_NEWEXE 0
#define VALID_OLDEXE 1
#define INVALID_EXE 	2

#endif
