//                                    Copyright John V. Rodley   1994
//
// SHOWEXE.C - The main module for SHOWEXE.EXE.  Includes main,
// argument processing, subdirectory recursion and global variable
// setting.

#include <os2.h>
#include <stddef.h>
#include <ctype.h>
#include <malloc.h>
#include <share.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <direct.h>  // chdir() prototype
#include "types.h"
#include "exe.h"
#include "utils.h"
#include "args.h"

FILE *fp = NULL;  // Used by mz_exe, ne_exe and lx_exe for open file.

struct exestyle exetypes[] = {
   "MZ", TYPE_MZ, TRUE,    // DOS MZ style
   "NE", TYPE_NE, TRUE,    // Win 3.X NE style
   "LE", TYPE_LE, FALSE,    // LE style
   "LX", TYPE_LX, FALSE,    // OS/2 2.1 LX style
   "PE", TYPE_PE,  FALSE,    // Win NT PE style
   "??", TYPE_OTHER,  FALSE    // Any others
};

void ShowIt( char *filename );
void FindAndShow( char *directory, char *lastdir );
void PrintOpenError( char *filename );

int SetFileName( char *v );
char *TargetFile = NULL;             // Name of exe file to dump, can be wildcard.
unsigned char TargetDisk = 'A';
char *TargetDir = NULL;

int TypeOnly = 0;       // Should we just report exe type?
int DumpSegs = 0;       // Should we dump physical segments/pages?
int Recurse = 0;        // Should we traverse subdirectorys too?
unsigned short filecount = 0;    // The count of files actually dumped.
char base_filename[CCHMAXPATH];  // The filename of the exe

// A definition of the command line args supported so far.  See args.h
// for definition of CMDARG structure.
CMDARG CmdArgs[] =
    {
    "-v",TRUE, &bVerbose, NULL, 0, "\tProduce all possible diagnostic output.",
    "-dumpsegs",TRUE, &DumpSegs, NULL, 0, "\tProduce formatted hex dump of all segments/pages.",
    "-r",TRUE, &Recurse, NULL, 0, "\tRecurse through all subdirectories.",
    "-f",TRUE, NULL, SetFileName, 1, "<filename>\tShow file <filename>.",
    "-type",TRUE, &TypeOnly, NULL, 0, "\tOnly show exe/dll type (MZ,NE,LE,LX,PE).",
   NULL,TRUE,NULL,NULL,0,NULL
   };

int SetFileName( char *v ) 
{ 
unsigned long ldummy;   // used in QCurDisk
unsigned short drive;   // drive number ( a: = 1 )
char temp[CCHMAXPATH];
char temp1[CCHMAXPATH];
char tempdir[CCHMAXPATH];
char thisdir[CCHMAXPATH];
char *p;
int i;
unsigned short usSize;

strcpy( temp, v );

if( temp[1] == ':' )
   {
   TargetDisk = toupper( temp[0] );
   p = &temp[2];
   }
else
   {
   DosQCurDisk( &drive, &ldummy );
   TargetDisk = 'A' + ( drive - 1 );
   p = &temp[0];
   }
   
// If the path is fully qualified
if( p[0] == '\\' )
   {
   i = 0;
   do {
      temp1[i] = p[i];
      i++;
      if( p[i] == '\0' )
         {
         printf( "incorrectly qualified filename (%s)\n", v );
         goto error;
         }
      }
   while( strchr( &p[i], '\\' ) != NULL );
   if( i != 1 && temp1[i-1] == '\\' )
      temp1[i-1] = '\0';   // chop off the trailing backslash
   else
      temp1[i] = '\0';     // we were talking about root directory
                           // or it was just directory, no file
   if( TargetDir )
      free( TargetDir );
   if( TargetFile )
      free( TargetFile );
   sprintf( thisdir, "%c:%s", TargetDisk, temp1 );
   TargetDir = strdup( thisdir );
   TargetFile = strdup( &p[i] );
   }
else
   {
   // if the path is completely unqualified
   if( strchr( temp, '\\' ) == NULL )
      {
      // unqualified except for drive letter
      if( temp[1] == ':' )
         drive = (toupper( temp[0] ) - 'A')+1;
      else
         DosQCurDisk( &drive, &ldummy );

      TargetDisk = 'A' + ( drive - 1 );
      usSize = sizeof(tempdir);
      DosQCurDir(drive, tempdir, &usSize );
      if( tempdir[0] == '\0' )
         sprintf( thisdir, "%c:", TargetDisk );
      else
         sprintf( thisdir, "%c:\\%s", TargetDisk, tempdir );
      if( TargetDir )
         free( TargetDir );
      if( TargetFile )
         free( TargetFile );
      TargetDir = strdup( thisdir );
      TargetFile = strdup( temp );
      }
   else
      {
      printf( "Can't deal with partially qualified pathnames!\n" );
      goto error;
		}
	}

return( 0 );
error:
return( 1 );
}



// main - SHOWEXE main function.
int main( int argc, char *argv[] )
{
char thisdir[CCHMAXPATH];
char tempdir[CCHMAXPATH];
unsigned long ldummy;   // used in QCurDisk
unsigned short drive;   // drive number ( a: = 1 )
unsigned short usSize;
unsigned short uRet;

DosQCurDisk( &drive, &ldummy );
TargetDisk += ( drive - 1 );
usSize = sizeof(tempdir);
DosQCurDir(drive, tempdir, &usSize );
if( tempdir[0] == '\0' )
   sprintf( thisdir, "%c:", TargetDisk );
else
   sprintf( thisdir, "%c:\\%s", TargetDisk, tempdir );
TargetDir = strdup( thisdir );

if( ProcessArgs( argc, argv ))
   {
   ShowArgs();
   return( 0 );
   }

drive = ( TargetDisk - 'A') + 1;
uRet = DosSelectDisk(drive);
chdir( TargetDir );

FindAndShow( NULL, TargetDir );

if( TargetDir )
   free( TargetDir );
if( TargetFile )
   free( TargetFile );
printf( "%d files found.\n", filecount );
return 0;
}

// CloseExe - Close the file and null the file pointer.
int CloseExe()
{
if( fp )
	fclose( fp );
fp = NULL;
return( 0 );
}

// FindAndShow - Show the executable specified by <directory/TargetFile>
// TargetFile is set by the ProcessArgs function.
//
// This function can be recursive.  lastdir MUST BE FULLY QUALIFIED!!
void FindAndShow( char *directory, char *lastdir )
{
FILEFINDBUF buffer;
HDIR uH = 0xFFFF;
unsigned short count = 1;
char filename[256];
USHORT attributes = 0x16; // dirs, hidden and system files
char thisdir[CCHMAXPATH];
char fullfilename[CCHMAXPATH];
USHORT uRet;

if( directory )
   {
   chdir( directory );
   sprintf( thisdir, "%s\\%s", lastdir, directory );
   }
else
   strcpy( thisdir, lastdir );      

if(( uRet = DosFindFirst( TargetFile, &uH, attributes, &buffer, sizeof( buffer ), &count, 0 )) == 0 )
	{
	do {
		if( count == 1 )
			{
			strncpy( filename, buffer.achName, buffer.cchName );
			filename[buffer.cchName] = '\0';
         if(! ( buffer.attrFile & FILE_DIRECTORY ))
            {
            sprintf( fullfilename, "%s\\%s", thisdir, filename );
   			ShowIt( fullfilename );
            }
			}
		count = 1;
		}
	while( DosFindNext( uH, &buffer, sizeof( buffer ), &count ) == 0 );
	}
if( !Recurse )
   return;

count = 1;
memset( &buffer, '\0', sizeof( buffer ));
uH = 0xFFFF;

// Now look for directories to recurse into
if( DosFindFirst( "*.*", &uH, attributes, &buffer, sizeof( buffer ), &count, 0 ) == 0 )
	{
	do {
		if( count == 1 )
			{
			strncpy( filename, buffer.achName, buffer.cchName );
			filename[buffer.cchName] = '\0';
         if( strcmp( filename, "." ) == 0 )
            continue;
         if( strcmp( filename, ".." ) == 0 )
            continue;
         // If it's a directory, recurse into it.
         if( buffer.attrFile & FILE_DIRECTORY )
            FindAndShow( filename, thisdir );
			}
		count = 1;
		}
	while( DosFindNext( uH, &buffer, sizeof( buffer ), &count ) == 0 );
	}

// If this wasn't top level, go up one.
if( directory )
   chdir( ".." );
}                       /* main */

// GetNewExeType - Return the type of exe beyond MZ that this exe happens
//	to be.
int GetNewExeType( char *filename )
{
	USHORT word;
   int i;

    if( mz_exe.lfanew == 0 )
		goto mz;

    if( fseek( fp, (long)mz_exe.lfanew, 0 ))
      {
      printf(  "Can't seek to %04xh\n", mz_exe.lfarlc );
      goto toonewexe;
      }

    if( fread( (char *)&word, sizeof( word ), 1, fp ) != 1 )
      {
      printf(  "%s is %s type EXE\n", filename, exetypes[TYPE_MZ].idstring );
      goto toonewexe;
      }

     // Now figure out what type of exe it really is
    for( i = 0; i <= sizeof( exetypes )/sizeof( exetypes[0] ); i++ )
      {
      if( i == sizeof( exetypes )/sizeof( exetypes[0] ))
         goto toonewexe;
      if( strncmp( (char *)&word, exetypes[i].idstring, sizeof( word )) == 0 )
         break;
      }

    return( i );

mz:
    return( TYPE_MZ );

toonewexe:
	 printf( "New type %c%c", (char )((word>>8)&0x00FF, (char )(word&0x00FF)));
    return( TYPE_OTHER );
    }    /* ReadExe */

// OpenExe - Just open the file and set global fp.    
int OpenExe( char *filename )
{
    if(( fp = fopen( filename, "rb" )) == NULL )
      {
		PrintOpenError( filename );
      goto notanexe;
      }

	return( 0 );
notanexe:
	return( 1 );
}

// PrintOpenError - An open error occurred, display.
void PrintOpenError( char *filename )
{
char buffer[80];
sprintf( buffer, "Couldn't open %s - ", filename );
perror( buffer );
}


// ShowIt - Show the executable.  Get the exe type, and dump the 
// exes tables and such.
void ShowIt( char *filename )
{
int ret;
int type;

if( OpenExe( filename ))
	goto error;

if( Read_MZExe())
	goto error;

type = GetNewExeType(filename);

switch( type )
{
	case TYPE_MZ:
      printf( "%s is type MZ!\n", filename );
      filecount++;
      if( TypeOnly )
         break;
	   bVerbose = 1;
	   DumpMZExeHdr();
		break;
	case TYPE_LX:
      printf( "%s is type LX!\n", filename );
      filecount++;
      if( !TypeOnly )
         {
   	   bVerbose = 1;
         Read_LXExe();
	      DumpLXExeHdr();
         DumpLXTables();
         if( DumpSegs)
            DumpLXPages();
         FreeLXPages();
         FreeLXTables();
         }
		break;
	case TYPE_NE:
      printf( "%s is type NE!\n", filename );
      filecount++;
      if( !TypeOnly )
         {
      	bVerbose = 1;
   		ret = Read_NEExe();
	      DumpNEExeHdr();
	      DumpNETables();
//         if( DumpSegs)
//            DumpNESegments();
//         FreeNESegments();
	   	FreeNETables();
         }
		break;
	case TYPE_LE:
      printf( "%s is type LE!\n", filename );
		break;
	default: 
      printf( "%s is not an exe!\n", filename );
      break;
}
error:
CloseExe();

}              /* ShowIt */


